package fr.ifremer.isisfish.ui.script;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ExportDialogUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVUO28TQRDemNiJYyAkUQyIACEEKnIOEogiiFeCRYx5iAQpwg3ru41vk/XtsTsXDgrET+AnQE+DREeFKKgpaBB/ASEKWsTs+XFcYhwLCxd71sw333wzuzOvv5G0VuTEBg1DSwUe8DqzSlfX1u5UN5gNS0zbivsgFWn8BlIkVSE5p23XQE5Wyia80AwvLMq6Lz3m/RG9UCYjGp4Ipl3GAMjRZIStdWGl7V4I/UC1WNuiOrG+/PE99cJ5/ipFSOijuhyWMr1bVFzJYJmkuANkHDNt0YKgXg1lKO7VUO8+Y1sUVOvbtM4ekWdkqEwyPlVIBmSm95Ijjig+9IFkZ0tLnApZmwdyZl1ZfF2xOsOv5nqda9cKuNWgsK6HvlTQQN9f9v2IJANkYnYlAix7HNDJnzKFZKejum0UwgXyNTl2IGOaodlVWhUMQw8lWqYfYwOsyGeQ2XZAGowNyEHTmbCJK2EGKcRd6kXo0RjNgdXxdYwn0G3a8TYwR5Xt8i12l4ILJJ+EsxCKnAknyZ21XSk1W+IKu5EIuBYASC+JHp4tGXlifruYyLoNa7vM3rwqBJDJBHbR2K/J0OCOxXC5GWc8mvTttalnM7HTr8iRRMPx9Vvx64+f50CFpFWAZryhys6BuYeuxqgc2jYqhjDy/spPfH739W2xNR9jmHuyI/SP8cZ36yvpMwXcpB5tDEcAXBRuUX+hQrKaCdwN0exPdRC20nSjOMw3ZsItE27doNpFivTQl/cf8g8/7SGpIhkRkjpFavDLJAuuwi5I4YT+5SuRor2Ph/E8YLThm6pLh+LVjF/knuAem6aA41oNgF0KsQ9THfrQFlPNfvw5sfLmSqsXA6jt8F/hcT/SD0imkS3aFs1F0HE75HzNAkfGA99pBQyY74jfnMO56DzbqdgstoI/bc3LuTAwn/ORcvPvQs9EaeDQN8l+GoC8ZxSxW9LpxpbvgW2IeaYw3L37LzoU6HSVew7O2aU+KG0pgrqnuyg7vCuNMZfMcfNfGfDe1qUHc6ZRfUkBknEZr7nwXwua6kHHIOAW7qKiF44cSClWub/aP1VG0CcygC5FHe+7LTM9MdS6VNIbg+iboVsVp5DhN2VADKjhCQAA";
    private static final Log log = LogFactory.getLog(ExportDialogUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextField archivePath;
    protected JButton cancelButton;
    protected JCheckBox checkAll;
    protected JButton chooseDir;
    protected JTable items;
    protected JButton okButton;
    protected JScrollPane table;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ExportDialogUI $JDialog0 = this;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    //    public org.nuiton.vcs.ui.FieldModelUtil.ModuleFile model;
        public Object model;
    
        public boolean isOkEnabled() {
            return !isEmpty(); // && model.getSelected(0).size() > 0;
        }
        public boolean isEmpty() {
           return model == null; // || model.getRowCount() == 0;
        }
        
        public void doCheckAll() {
    //        if (model!=null) model.checkAll();
            doRefresh();        
        }
    
        public void doRefresh() {
            fr.ifremer.isisfish.ui.util.JaxxUtil.refresh(this,"items.enabled",
                "checkAll.enabled","ok.enabled","chooseDir.enabled",
                "archivePath.enabled");        
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ExportDialogUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI() {
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ExportDialogUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ExportDialogUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__checkAll(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheckAll();
    }

    public void doMouseClicked__on__items(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doRefresh();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextField getArchivePath() {
        return archivePath;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JCheckBox getCheckAll() {
        return checkAll;
    }

    public JButton getChooseDir() {
        return chooseDir;
    }

    public JTable getItems() {
        return items;
    }

    public JButton getOkButton() {
        return okButton;
    }

    public JScrollPane getTable() {
        return table;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTable() {
        if (!allComponentsCreated) {
            return;
        }
        table.getViewport().add(items);
    }

    protected void createArchivePath() {
        $objectMap.put("archivePath", archivePath = new JTextField());
        
        archivePath.setName("archivePath");
        archivePath.setColumns(15);
        archivePath.setColumns(30);
        if (archivePath.getFont() != null) {
            archivePath.setFont(archivePath.getFont().deriveFont((float) 11));
        }
        SwingUtil.setComponentHeight(archivePath,25);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
    }

    protected void createCheckAll() {
        $objectMap.put("checkAll", checkAll = new JCheckBox());
        
        checkAll.setName("checkAll");
        checkAll.setText(t("isisfish.script.export.checkAll"));
        checkAll.setToolTipText(t("isisfish.script.export.tooltip.checkAll"));
        checkAll.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__checkAll"));
    }

    protected void createChooseDir() {
        $objectMap.put("chooseDir", chooseDir = new JButton());
        
        chooseDir.setName("chooseDir");
        chooseDir.setText(t("isisfish.script.export.chooseDir"));
        chooseDir.setToolTipText(t("isisfish.script.export.tooltip.chooseDir"));
    }

    protected void createItems() {
        $objectMap.put("items", items = new JTable());
        
        items.setName("items");
        items.setAutoResizeMode(3);
        items.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__items"));
    }

    protected void createOkButton() {
        $objectMap.put("okButton", okButton = new JButton());
        
        okButton.setName("okButton");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JScrollPane());
        
        table.setName("table");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(table, new GridBagConstraints(0, 0, 2, 1, 0.0, 2.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivePath, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(chooseDir, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToTable();
        // inline complete setup of $JPanel0
        $JPanel0.add(checkAll);
        $JPanel0.add(okButton);
        $JPanel0.add(cancelButton);
        
        // apply 6 property setters
        items.setEnabled(!isEmpty());
        archivePath.setEnabled(!isEmpty());
        chooseDir.setEnabled(!isEmpty());
        checkAll.setEnabled(!isEmpty());
        okButton.setEnabled(isOkEnabled());
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        model = null;
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createTable();
        createItems();
        createArchivePath();
        createChooseDir();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0, 3, 2, 2));
        createCheckAll();
        createOkButton();
        createCancelButton();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        setResizable(false);
        setTitle(t("isisfish.script.export"));
        
        $completeSetup();
    }

}