/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input.model;

import java.util.List;

import javax.swing.DefaultListModel;

import fr.ifremer.isisfish.entities.EffortDescription;

/**
 * Model pour la liste des metiers de l'interface SetOfVessels.
 *
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (Thu, 17 Apr 2014) $
 * By : $Author: echatellier $
 */
public class EffortDescriptionListModel extends DefaultListModel<EffortDescription> {

    /** serialVersionUID. */
    private static final long serialVersionUID = -2715181950778932871L;
    
    /** Listes des EffortDescription */
    protected List<EffortDescription> effortDescriptions;

    /**
     * Empty constructor.
     */
    public EffortDescriptionListModel() {
        this(null);
    }

    /**
     * Constructor with effortDescriptions list.
     * 
     * @param effortDescriptions liste des effortDescriptions
     */
    public EffortDescriptionListModel(List<EffortDescription> effortDescriptions) {
        setEffortDescriptions(effortDescriptions);
    }

    /**
     * Get effortDescriptions lists.
     * 
     * @return the effortDescriptions
     */
    public List<EffortDescription> getEffortDescriptions() {
        return effortDescriptions;
    }

    /**
     * Set effortDescriptions list.
     * 
     * @param effortDescriptions the effortDescriptions list to set
     */
    public void setEffortDescriptions(List<EffortDescription> effortDescriptions) {
        this.effortDescriptions = effortDescriptions;
        fireContentsChanged(this, 0, getSize());
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public EffortDescription getElementAt(int index) {
        return effortDescriptions.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (effortDescriptions != null) {
            size = effortDescriptions.size();
        }
        return size;
    }
}
