package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n.t;

public class PopulationRecruitmentUI extends InputContentUI<Population> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_FIELD_POPULATION_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT_ENABLED = "fieldPopulationMonthGapBetweenReproRecrutement.enabled";
    public static final String BINDING_FIELD_POPULATION_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT_TEXT = "fieldPopulationMonthGapBetweenReproRecrutement.text";
    public static final String BINDING_FIELD_POPULATION_RECRUITMENT_COMMENT_ENABLED = "fieldPopulationRecruitmentComment.enabled";
    public static final String BINDING_FIELD_POPULATION_RECRUITMENT_COMMENT_TEXT = "fieldPopulationRecruitmentComment.text";
    public static final String BINDING_FIELD_POPULATION_RECRUITMENT_DISTRIBUTION_ENABLED = "fieldPopulationRecruitmentDistribution.enabled";
    public static final String BINDING_FIELD_POPULATION_RECRUITMENT_DISTRIBUTION_MATRIX = "fieldPopulationRecruitmentDistribution.matrix";
    public static final String BINDING_REPRODUCTION_EQUATION_ACTIVE = "reproductionEquation.active";
    public static final String BINDING_REPRODUCTION_EQUATION_BEAN = "reproductionEquation.bean";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28TRxSeuLFD+FEoISEI2iatRQ+gdUpbqWoQDSQEYjkQ4VCh+tLx7tgeNJ4dZmaTDQfEn8Cf0N57QeLGCfXQcw+9VP0XqqqHXqu+mbW9XmfZrFgfZu15733zvW/efv75L1RWEi0/xmHoyIBr2idO/eajR/fbj4mrN4hyJRXalyj6TJVQqYVOeKN9pdGnrYYprw3Ka+t+X/ic8LHq1QY6rvQBI6pHiNbow2SFq1StOQqvhiKQQ9QRqTTUH//5u/TCe/5TCaFQALs5aGXpqKq4k+kGKlFPo7Nw0h6uMcy7QENS3gW+p8zeOsNK3cN98gQ9QzMNVBFYAphGn+Rv2WLY+lBodKa6xUWg132uIf3h1opGX3akQzuS9Ak8FVUdqnpOQB1qEp0dXwQMa+rzB8SVAdV9WyeExaxoNN0mmGv0WRoKpFJNiRpDiQtn9zCjHgauGl1JqDYKOGof1HCaZv1uuDl+tO8dgH5GqnCQW9/BnLA4Z6a6i9uMQJ+LiTOibBszmWcnCz43P8+bZX4UOieJkL4XuKaR208C25BGtUwBrd73ORnmP9wyaIsj0GPVegO3CVuZbMTuJnOdDiXMi8XchuN7d7C4RfQ+IXBDQM9ekyZ9OycLCcRdEupNg5DOwLb8cTJ2eeLEsSHYoAqGtR1EIlz1ZdfhEPK508e6ZxZJQ6cLQmzbr/ZibnuQIQ+db2Mr5ve5ZKziSoI10Wgu0cmtQMNB6W1cS2njVLXedKXPmDkIlD6fQItDyarltzcPb1yk8PwhhW8CYwNQmxypaykjNa3wnj31qlm+Gusbcze6/mFEoouJCQbXcmLXim1lqoXKMoBtGPnWYaN7AKHI4hYnLM4A2uh/C3O/v/7z1ebQ1xbh7PnU1DFbBr+B6RNEmhdeo9ORqcF0sNo2FqstNKsIA0+3nn0phVhzEAZycN4Hptwx5c5drHoAUZ75480vCz/89h4qbaLjzMfeJjb5W2hW9ySo4DMvFN+uWUYn94/BesZwAzEhj+6BRu9fBwfBS23KPbiuGyGIcClFhBGT9uyv/841X64NhZgCYhfemh6LUf4eVShnlBNr8QP3TrX0E0KRwPNjl07z7SnzvCgGrrZm1420Tq0Zm+idMDCPu5a0+VbPjXHSYOxEV2nc9XrUyRLW0etObrw7dtll+OnTggRPd3zZh+FbB2Po+vLAJO6+O9y0hpe2IMYM4eYN9zI6++hIGLPtZhDJh9DL4LCcn0MhhCwO1cI65EPI4nA5x5VWoj+wQihH8bhSWIt8CFkcnMIc8iFkcfii8FzmQ8ji8HVhHfIhZHH4pjAHg/A/Ou75Q1UNAAA=";
    private static final Log log = LogFactory.getLog(PopulationRecruitmentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected JButton cancel;
    protected JButton create;
    protected JTextField fieldPopulationMonthGapBetweenReproRecrutement;
    protected JTextArea fieldPopulationRecruitmentComment;
    protected MatrixPanelEditor fieldPopulationRecruitmentDistribution;
    protected InputOneEquationUI reproductionEquation;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Population> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationRecruitmentUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    fieldPopulationMonthGapBetweenReproRecrutement.setText("");
                    fieldPopulationRecruitmentComment.setText("");
                }
                if (evt.getNewValue() != null) {
    
                }
            }
        });
    }
    
    protected void populationRecruitmentDistributionMatrixChanged(MatrixPanelEvent event) {
        if (getBean() != null){
            if (fieldPopulationRecruitmentDistribution.getMatrix() != null){
                getBean().setRecruitmentDistribution(fieldPopulationRecruitmentDistribution.getMatrix().copy());
            }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationRecruitmentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationRecruitmentUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationRecruitmentUI() {
        $initialize();
    }

    public PopulationRecruitmentUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationRecruitmentUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationRecruitmentUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationRecruitmentUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationRecruitmentUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().createRecruitmentDistribution(getBean());
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldPopulationMonthGapBetweenReproRecrutement(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setMonthGapBetweenReproRecrutement(Integer.parseInt(fieldPopulationMonthGapBetweenReproRecrutement.getText()));
    }

    public void doKeyReleased__on__fieldPopulationRecruitmentComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setRecruitmentComment(fieldPopulationRecruitmentComment.getText());
    }

    public void doMatrixChanged__on__fieldPopulationRecruitmentDistribution(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        populationRecruitmentDistributionMatrixChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JButton getCreate() {
        return create;
    }

    public JTextField getFieldPopulationMonthGapBetweenReproRecrutement() {
        return fieldPopulationMonthGapBetweenReproRecrutement;
    }

    public JTextArea getFieldPopulationRecruitmentComment() {
        return fieldPopulationRecruitmentComment;
    }

    public MatrixPanelEditor getFieldPopulationRecruitmentDistribution() {
        return fieldPopulationRecruitmentDistribution;
    }

    public InputOneEquationUI getReproductionEquation() {
        return reproductionEquation;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Population> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.newMatrix"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createFieldPopulationMonthGapBetweenReproRecrutement() {
        $objectMap.put("fieldPopulationMonthGapBetweenReproRecrutement", fieldPopulationMonthGapBetweenReproRecrutement = new JTextField());
        
        fieldPopulationMonthGapBetweenReproRecrutement.setName("fieldPopulationMonthGapBetweenReproRecrutement");
        fieldPopulationMonthGapBetweenReproRecrutement.setColumns(15);
        fieldPopulationMonthGapBetweenReproRecrutement.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationMonthGapBetweenReproRecrutement"));
        fieldPopulationMonthGapBetweenReproRecrutement.putClientProperty("sensitivityBean", Population.class);
        fieldPopulationMonthGapBetweenReproRecrutement.putClientProperty("sensitivityMethod", "MonthGapBetweenReproRecrutement");
    }

    protected void createFieldPopulationRecruitmentComment() {
        $objectMap.put("fieldPopulationRecruitmentComment", fieldPopulationRecruitmentComment = new JTextArea());
        
        fieldPopulationRecruitmentComment.setName("fieldPopulationRecruitmentComment");
        fieldPopulationRecruitmentComment.setColumns(15);
        fieldPopulationRecruitmentComment.setLineWrap(true);
        fieldPopulationRecruitmentComment.setWrapStyleWord(true);
        fieldPopulationRecruitmentComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationRecruitmentComment"));
    }

    protected void createFieldPopulationRecruitmentDistribution() {
        $objectMap.put("fieldPopulationRecruitmentDistribution", fieldPopulationRecruitmentDistribution = new MatrixPanelEditor());
        
        fieldPopulationRecruitmentDistribution.setName("fieldPopulationRecruitmentDistribution");
        fieldPopulationRecruitmentDistribution.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__fieldPopulationRecruitmentDistribution"));
        fieldPopulationRecruitmentDistribution.putClientProperty("sensitivityBean", Population.class);
        fieldPopulationRecruitmentDistribution.putClientProperty("sensitivityMethod", "RecruitmentDistribution");
    }

    protected void createReproductionEquation() {
        $objectMap.put("reproductionEquation", reproductionEquation = new InputOneEquationUI(this));
        
        reproductionEquation.setName("reproductionEquation");
        reproductionEquation.setBeanProperty("ReproductionEquation");
        reproductionEquation.setFormuleCategory("Reproduction");
        reproductionEquation.setText(t("isisfish.populationRecruitment.reproductionEquation"));
        reproductionEquation.putClientProperty("sensitivityBean", Population.class);
        reproductionEquation.putClientProperty("sensitivityMethod", "ReproductionEquation");
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Population.class, "recruitement"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(SwingUtil.boxComponentWithJxLayer(reproductionEquation), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationMonthGapBetweenReproRecrutement), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationRecruitmentDistribution), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel0, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldPopulationRecruitmentComment));
        // inline complete setup of $Table2
        $Table2.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        reproductionEquation.setClazz(fr.ifremer.isisfish.equation.PopulationReproductionEquation.class);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createReproductionEquation();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.populationRecruitment.monthgapgetweenreprorecruitment"));
        createFieldPopulationMonthGapBetweenReproRecrutement();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.populationRecruitment.recruitmentDistribution"));
        createFieldPopulationRecruitmentDistribution();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreate();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.populationRecruitment.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldPopulationRecruitmentComment();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        /*public void refresh() {
            Population population = getSaveVerifier().getEntity(Population.class);
            
            // add null before, for second to be considered as a changed event
            // otherwize, setBean has no effect
            setBean(null);
            setBean(population);
        
            if (getBean() != null && getBean().getRecruitmentDistribution() != null) {
                fieldPopulationRecruitmentDistribution.setMatrix(getBean().getRecruitmentDistribution().copy());
                
                // chatellier : number editor is not working
                //fieldPopulationMonthGapBetweenReproRecrutement.init();
            }
            
            // TODO add only once
            //fieldPopulationRecruitmentDistribution.addMatrixListener(listener);
        }*/;// registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REPRODUCTION_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                reproductionEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REPRODUCTION_EQUATION_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                reproductionEquation.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMonthGapBetweenReproRecrutement.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationMonthGapBetweenReproRecrutement, String.valueOf(getBean().getMonthGapBetweenReproRecrutement()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_RECRUITMENT_DISTRIBUTION_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationRecruitmentDistribution.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_RECRUITMENT_DISTRIBUTION_MATRIX, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (bean != null) {
                    bean.addPropertyChangeListener("recruitmentDistribution", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null && bean.getRecruitmentDistribution() != null) {
                    fieldPopulationRecruitmentDistribution.setMatrix(getBean() == null ? null : bean.getRecruitmentDistribution().copy());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (bean != null) {
                    bean.removePropertyChangeListener("recruitmentDistribution", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                create.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_RECRUITMENT_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationRecruitmentComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_RECRUITMENT_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationRecruitmentComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getRecruitmentComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}