package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.util.CompileHelper;
import fr.ifremer.isisfish.util.EvaluatorHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.widget.editor.Editor;
import static org.nuiton.i18n.I18n.t;

public class EquationEditorPaneUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_RESULT_OK = "resultOk";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28TRxSeGJzE+VHaRAkgUhGoVRBCa+BQqU1UCDRRkwaocCoQvnS8O/EOGc8MM2/JpqpQ/4T+Ce2dC1JvPVU99NxDL1X/harqoVfEm1nHm8XGsWofvPZ73/ve997Oe/Pib1K2hlx4QtM0MIkE3mbB1tqjR/ebT1gInzEbGq5BGZJ9xkqk1CDTUddugXzQ2HbhtU547Y5qayWZPBK9sk2mLBwIZmPGAMj7xYjQ2lq9615JdWIOWbui+rH+8O8/pe+j734sEZJqVDeLpSwfF5VXcnKblHgEZA4zPaM1QWULZRguW6h31tnuCGrtPdpmT8lzMrFNxjU1SAbk4vAlew4fn2rMtf40ocCVXI84or6kkgG5vmsCvmtYm+HTcrvLbRwkPOBSJxD0Rny1qbWnHAcyaZhNBNzfA/Kekxy4MoLbSglGZQ6br9a9sE3JgVPBv2HmGpAPfbNCVM8F5s60Bz3InGaiukObgmHomUKf7T52LfA+h6x0A2arW0inhHC6Mey005h28EdcDj7XjToRqfBNbF6+Ay10sWWrBcdXslhkdsZe4nHmWYCcV6YVyAT/yGCfRy0GQeYKsjwOf65/Fded8XQRMB3GLNx7yGWk9oEsFKTssBTWDKMOeqEbUalu3U4A02NT5gv4zFzUPan2cvPlom8mpDJkotdvyLnCS8IxC/Ixy+dgrEHKJkEzvtVG72Q+QFc2k2femElH6L2vFuf/+PmvnzYOB/FdzL3QF3pkj+CAaKM0M8Bd6lPZFCbARe0u1SsNUrFM4BLyS2apj7B6x43iMF92+l148Dm1MVKUJ/785dfFr38/QUobZEooGm1Qh98kFYhxbGIlolTfvOUVzexPOuFOGx6TmPFWjIdqbpVLwSVbpoCLoZkA+zTFRiz1aURXTbPy23/z9Ze3DpsxhuLOvhWeN6T8mIxn2fxe6qycvntoWluWRCpfLf2WzZh7TunO8N7w3x/1rVbQA4Wnh7yzGlGgy008xngSsVIX8okvwf1aHZqx3FYRFc798f8nmfEkHA52DrQvfG0EQcAhW00jCCrjooB4RJJJt2YO9+RbeM4OwVPJ1tUXHAa0ZhiiOby4dlQSxuuppjI6RtrSEIzTynC8C/2lNSLVDI4p3kAP/TiOyDVL7d7m7j0FdfqMRQPIzh9L5syPBzBUh5BzEvBeGMBxaSgV3w5guDIyw1VkeA1B+TVKIwoAAA==";
    private static final Log log = LogFactory.getLog(EquationEditorPaneUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected EquationEditorPaneUI EquationEditorPane = this;
    protected JButton cancelButton;
    protected JTextArea checkWindow;
    protected JEditorPane doc;
    protected Editor editor;
    protected JButton okButton;
    protected Boolean resultOk;
    protected JSplitPane split;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    Class javaInterface;
    
    
    protected void $afterCompleteSetup() {
        split.setDividerLocation(0.8);
    }
    
    public void setEquation(String category, String name, Class javaInterface, String content) throws Exception {
        this.javaInterface = javaInterface;
        getDoc().setText(CompileHelper.extractDoc(category, name, javaInterface));
        getEditor().open(FileUtil.getTempFile(content, ".java"));
    }
    
    public void docEditorHyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e instanceof HTMLFrameHyperlinkEvent) {
                ((HTMLDocument)doc.getDocument()).processHTMLFrameHyperlinkEvent(
                    (HTMLFrameHyperlinkEvent)e);
            } else {
                try {
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    } else {
                        doc.setPage(e.getURL());
                    }
                } catch (Exception ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Error for : " + e.getURL(), ex);
                    }
                }
            }
        }
    }
    
    public void check() {
        try {
            String content = editor.getText();
            
            StringWriter result = new StringWriter();
            PrintWriter out = new PrintWriter(result);
            int compileResult = 0;
            try {
                compileResult = EvaluatorHelper.check(javaInterface, content, out);
            } catch (Exception eee) {
                compileResult = -1;
            }
            
            out.flush();
            if (compileResult != 0) {
               checkWindow.setText(result.toString());
               checkWindow.setBackground(Color.RED);
            } else {
               checkWindow.setText("Compilation Ok");
               checkWindow.setBackground(Color.WHITE);
            }
                        
        } catch(Exception e){
            log.error("Can't check script", e);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EquationEditorPaneUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI() {
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EquationEditorPaneUI(Window param0) {
        super(param0);
        $initialize();
    }

    public EquationEditorPaneUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        check();
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setVisible(false);
    }

    public void doActionPerformed__on__okButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setResultOk(true); setVisible(false);
    }

    public void doHyperlinkUpdate__on__doc(HyperlinkEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        docEditorHyperlinkUpdate(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCheckWindow() {
        return checkWindow;
    }

    public JEditorPane getDoc() {
        return doc;
    }

    public Editor getEditor() {
        return editor;
    }

    public JButton getOkButton() {
        return okButton;
    }

    public Boolean getResultOk() {
        return resultOk;
    }

    public JSplitPane getSplit() {
        return split;
    }

    public Boolean isResultOk() {
        return resultOk !=null && resultOk;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setResultOk(Boolean resultOk) {
        Boolean oldValue = this.resultOk;
        this.resultOk = resultOk;
        firePropertyChange(PROPERTY_RESULT_OK, oldValue, resultOk);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEquationEditorPane() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToSplit() {
        if (!allComponentsCreated) {
            return;
        }
        split.add(editor, JSplitPane.LEFT);
        split.add($JScrollPane1, JSplitPane.RIGHT);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("isisfish.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCheckWindow() {
        $objectMap.put("checkWindow", checkWindow = new JTextArea());
        
        checkWindow.setName("checkWindow");
        checkWindow.setColumns(15);
        checkWindow.setLineWrap(true);
        checkWindow.setWrapStyleWord(true);
        checkWindow.setEditable(false);
    }

    protected void createDoc() {
        $objectMap.put("doc", doc = new JEditorPane());
        
        doc.setName("doc");
        doc.setEditable(false);
        doc.addHyperlinkListener(JAXXUtil.getEventListener(HyperlinkListener.class, "hyperlinkUpdate", this, "doHyperlinkUpdate__on__doc"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new Editor());
        
        editor.setName("editor");
        editor.setAskIfNotSaved(false);
    }

    protected void createOkButton() {
        $objectMap.put("okButton", okButton = new JButton());
        
        okButton.setName("okButton");
        okButton.setText(t("isisfish.common.ok"));
        okButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__okButton"));
    }

    protected void createResultOk() {
        $objectMap.put("resultOk", resultOk = false);
    }

    protected void createSplit() {
        $objectMap.put("split", split = new JSplitPane());
        
        split.setName("split");
        split.setOneTouchExpandable(true);
        split.setOrientation(0);
        split.setResizeWeight(0.8);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEquationEditorPane();
        // inline complete setup of $Table0
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 0, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(split, new GridBagConstraints(0, 1, 3, 1, 1.0, 5.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(okButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancelButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(doc);
        addChildrenToSplit();
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(checkWindow);
        
        // apply 3 property setters
        setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        doc.setEditorKit(new HTMLEditorKit());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("EquationEditorPane", EquationEditorPane);
        createResultOk();
        javaInterface = null;
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createDoc();
        createSplit();
        createEditor();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createCheckWindow();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("isisfish.common.check"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createOkButton();
        createCancelButton();
        // inline creation of EquationEditorPane
        setName("EquationEditorPane");
        SwingUtil.setComponentHeight(EquationEditorPane,400);
        EquationEditorPane.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(t("isisfish.equation.editor.title"));
        SwingUtil.setComponentWidth(EquationEditorPane,400);
        
        $completeSetup();
    }

}