/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator.sensitivity;

/**
 * Sensitivity Exception throw if calculator,
 * fail to answer (ex : R) or something else.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 26 févr. 2009 $
 * By : $Author: chatellier $
 */
public class SensitivityException extends Exception {

    /** serialVersionUID. */
    private static final long serialVersionUID = -713095428835197215L;

    /**
     * Constructor with message.
     * 
     * @param message message
     */
    public SensitivityException(String message) {
        super(message);
    }

    /**
     * Constructor with message and cause.
     * 
     * @param message message
     * @param cause exception cause
     */
    public SensitivityException(String message, Throwable cause) {
        super(message, cause);
    }
}
