package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Mon Jan 26 10:18:17 CET 2015")
public abstract class MetierSeasonInfoAbstract extends SeasonImpl implements MetierSeasonInfo {

    /**
     * Nom de l'attribut en BD : seasonZoneComment
     */
    protected String seasonZoneComment;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : species
     */
    protected Collection<TargetSpecies> speciesTargetSpecies;

    /**
     * Nom de l'attribut en BD : metier
     */
    protected Metier metier;

    /**
     * Nom de l'attribut en BD : zone
     */
    protected Collection<Zone> zone;

    private static final long serialVersionUID = 4063482033020822118L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(MetierSeasonInfo.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(MetierSeasonInfo.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    @Override
    protected void accept0(EntityVisitor visitor) throws TopiaException {
        super.accept0(visitor);
        visitor.visit(this, PROPERTY_SEASON_ZONE_COMMENT, String.class, seasonZoneComment);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_SPECIES_TARGET_SPECIES, Collection.class, TargetSpecies.class, speciesTargetSpecies);
        visitor.visit(this, PROPERTY_METIER, Metier.class, metier);
        visitor.visit(this, PROPERTY_ZONE, Collection.class, Zone.class, zone);
    }

    @Override
    public void setSeasonZoneComment(String seasonZoneComment) {
        String oldValue = this.seasonZoneComment;
        fireOnPreWrite(PROPERTY_SEASON_ZONE_COMMENT, oldValue, seasonZoneComment);
        this.seasonZoneComment = seasonZoneComment;
        fireOnPostWrite(PROPERTY_SEASON_ZONE_COMMENT, oldValue, seasonZoneComment);
    }

    @Override
    public String getSeasonZoneComment() {
        String result = this.seasonZoneComment;

        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        String result = this.comment;

        return result;
    }

    @Override
    public void addSpeciesTargetSpecies(TargetSpecies speciesTargetSpecies) {
        fireOnPreWrite(PROPERTY_SPECIES_TARGET_SPECIES, null, speciesTargetSpecies);
        if (this.speciesTargetSpecies == null) {
            this.speciesTargetSpecies = new ArrayList<TargetSpecies>();
        }

        this.speciesTargetSpecies.add(speciesTargetSpecies);
        fireOnPostWrite(PROPERTY_SPECIES_TARGET_SPECIES, this.speciesTargetSpecies.size(), null, speciesTargetSpecies);
    }

    @Override
    public void addAllSpeciesTargetSpecies(Collection<TargetSpecies> speciesTargetSpecies) {
        if (speciesTargetSpecies == null) {
            return;
        }
        for (TargetSpecies item : speciesTargetSpecies) {
            addSpeciesTargetSpecies(item);
        }
    }

    @Override
    public void setSpeciesTargetSpecies(Collection<TargetSpecies> speciesTargetSpecies) {
        // Copy elements to keep data for fire with new reference
        Collection<TargetSpecies> oldValue = this.speciesTargetSpecies != null ? new ArrayList<TargetSpecies>(this.speciesTargetSpecies) : null;
        fireOnPreWrite(PROPERTY_SPECIES_TARGET_SPECIES, oldValue, speciesTargetSpecies);
        this.speciesTargetSpecies = speciesTargetSpecies;
        fireOnPostWrite(PROPERTY_SPECIES_TARGET_SPECIES, oldValue, speciesTargetSpecies);
    }

    @Override
    public void removeSpeciesTargetSpecies(TargetSpecies speciesTargetSpecies) {
        fireOnPreWrite(PROPERTY_SPECIES_TARGET_SPECIES, speciesTargetSpecies, null);
        if (this.speciesTargetSpecies == null || !this.speciesTargetSpecies.remove(speciesTargetSpecies)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_SPECIES_TARGET_SPECIES, this.speciesTargetSpecies.size() + 1, speciesTargetSpecies, null);
    }

    @Override
    public void clearSpeciesTargetSpecies() {
        if (this.speciesTargetSpecies == null) {
            return;
        }
        Collection<TargetSpecies> oldValue = new ArrayList<TargetSpecies>(this.speciesTargetSpecies);
        fireOnPreWrite(PROPERTY_SPECIES_TARGET_SPECIES, oldValue, this.speciesTargetSpecies);
        this.speciesTargetSpecies.clear();
        fireOnPostWrite(PROPERTY_SPECIES_TARGET_SPECIES, oldValue, this.speciesTargetSpecies);
    }

    @Override
    public Collection<TargetSpecies> getSpeciesTargetSpecies() {
        return speciesTargetSpecies;
    }

    @Override
    public TargetSpecies getSpeciesTargetSpeciesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(speciesTargetSpecies, topiaId);
    }

    @Override
    public TargetSpecies getSpeciesTargetSpecies(Species species) {
        if (species == null || this.speciesTargetSpecies == null) {
            return null;
        }
        for (TargetSpecies item : this.speciesTargetSpecies) {
            if (species.equals(item.getSpecies())) {
                return item;
            }
        }
        return null;
    }

    @Override
    public int sizeSpeciesTargetSpecies() {
        if (speciesTargetSpecies == null) {
            return 0;
        }
        return speciesTargetSpecies.size();
    }

    @Override
    public boolean isSpeciesTargetSpeciesEmpty() {
        int size = sizeSpeciesTargetSpecies();
        return size == 0;
    }

    @Override
    public void setMetier(Metier metier) {
        Metier oldValue = this.metier;
        fireOnPreWrite(PROPERTY_METIER, oldValue, metier);
        this.metier = metier;
        fireOnPostWrite(PROPERTY_METIER, oldValue, metier);
    }

    @Override
    public Metier getMetier() {
        Metier result = this.metier;

        return result;
    }

    @Override
    public void addZone(Zone zone) {
        fireOnPreWrite(PROPERTY_ZONE, null, zone);
        if (this.zone == null) {
            this.zone = new ArrayList<Zone>();
        }

        this.zone.add(zone);
        fireOnPostWrite(PROPERTY_ZONE, this.zone.size(), null, zone);
    }

    @Override
    public void addAllZone(Collection<Zone> zone) {
        if (zone == null) {
            return;
        }
        for (Zone item : zone) {
            addZone(item);
        }
    }

    @Override
    public void setZone(Collection<Zone> zone) {
        // Copy elements to keep data for fire with new reference
        Collection<Zone> oldValue = this.zone != null ? new ArrayList<Zone>(this.zone) : null;
        fireOnPreWrite(PROPERTY_ZONE, oldValue, zone);
        this.zone = zone;
        fireOnPostWrite(PROPERTY_ZONE, oldValue, zone);
    }

    @Override
    public void removeZone(Zone zone) {
        fireOnPreWrite(PROPERTY_ZONE, zone, null);
        if (this.zone == null || !this.zone.remove(zone)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_ZONE, this.zone.size() + 1, zone, null);
    }

    @Override
    public void clearZone() {
        if (this.zone == null) {
            return;
        }
        Collection<Zone> oldValue = new ArrayList<Zone>(this.zone);
        fireOnPreWrite(PROPERTY_ZONE, oldValue, this.zone);
        this.zone.clear();
        fireOnPostWrite(PROPERTY_ZONE, oldValue, this.zone);
    }

    @Override
    public Collection<Zone> getZone() {
        return zone;
    }

    @Override
    public Zone getZoneByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(zone, topiaId);
    }

    @Override
    public int sizeZone() {
        if (zone == null) {
            return 0;
        }
        return zone.size();
    }

    @Override
    public boolean isZoneEmpty() {
        int size = sizeZone();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<TargetSpecies> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(TargetSpecies.class);
            List<TargetSpecies> findAllByProperties = dao.findAllByProperties("metierSeasonInfo", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_SEASON_ZONE_COMMENT, this.seasonZoneComment).
            append(PROPERTY_COMMENT, this.comment).
            append(PROPERTY_ZONE, this.zone).
         toString();
        return result;
    }

} //MetierSeasonInfoAbstract
