/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.filter;

import fr.ifremer.isisfish.ui.widget.filter.AcceptorFactory;
import fr.ifremer.isisfish.ui.widget.filter.FilterAcceptor;
import fr.ifremer.isisfish.ui.widget.filter.ValueGetter;
import java.io.Serializable;

public class FilterParamModel<M, T>
implements Serializable {
    private static final long serialVersionUID = -1116890939014115356L;
    protected String paramKey;
    protected T val;
    protected State state = State.NONE;
    protected ResultState resultState = ResultState.NONE;
    protected int hits;
    protected transient FilterAcceptor<M, T> acceptor;

    public FilterParamModel(String paramKey, Class<T> type, ValueGetter<M, T> valueGetter) {
        this.paramKey = paramKey;
        this.acceptor = AcceptorFactory.createCompositeFilterAcceptor(type, valueGetter);
    }

    public void extractParam(Object ... val) {
        if (!this.acceptor.canUse(val)) {
            this.state = State.SKIP;
        } else {
            this.state = State.USE;
            this.val = val.length == 1 ? this.acceptor.extract(val[0]) : this.acceptor.extract(val);
        }
    }

    public boolean accept(M item) {
        boolean newValue = this.acceptor.acceptParam(item, this.val);
        if (newValue) {
            ++this.hits;
        }
        return newValue;
    }

    public void reset() {
        this.state = State.NONE;
        this.resetResult();
    }

    public void resetResult() {
        this.resultState = ResultState.NONE;
        this.hits = 0;
        this.val = null;
    }

    public boolean canUse(String ... val) {
        return this.acceptor.canUse(val);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" (key ").append(this.paramKey).append(')');
        sb.append(" (val ").append(this.val).append(')');
        sb.append(" (state ").append((Object)this.state).append(')');
        sb.append(" (resultState ").append((Object)this.resultState).append(')');
        sb.append(" (hits ").append(this.hits).append(')');
        return sb.toString();
    }

    public static enum State {
        NONE,
        SKIP,
        USE;

    }

    public static enum ResultState {
        NONE,
        OK,
        KO;

    }
}

