/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.EquationImpl;
import fr.ifremer.isisfish.entities.Variable;
import fr.ifremer.isisfish.equation.VariableEquation;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.EvaluatorHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class SimulationVariable {
    protected SimulationContext simulationContext;
    protected TopiaEntity topiaEntity;
    protected Map<String, Variable> variablesCache = new HashMap<String, Variable>();

    public SimulationVariable(SimulationContext simulationContext, TopiaEntity topiaEntity) {
        this.simulationContext = simulationContext;
        this.topiaEntity = topiaEntity;
    }

    protected Variable getVariableEntity(String name) throws TopiaException {
        Variable v = this.variablesCache.get(name);
        if (v == null) {
            TopiaContext topiaContext = this.simulationContext.getDB();
            List vindb = topiaContext.findAll("FROM " + Variable.class.getName() + " WHERE " + "entityId" + " = :id" + " AND " + "name" + " = :name", new Object[]{"id", this.topiaEntity.getTopiaId(), "name", name});
            if (!vindb.isEmpty()) {
                v = (Variable)vindb.get(0);
                this.variablesCache.put(name, v);
            }
        }
        return v;
    }

    public double getAsDouble(String name) throws TopiaException {
        Variable v = this.getVariableEntity(name);
        double result = v.getDoubleValue();
        return result;
    }

    public MatrixND getAsMatrix(String name) throws TopiaException {
        Variable v = this.getVariableEntity(name);
        MatrixND result = v.getMatrixValue();
        return result;
    }

    public void set(String name, Object value) throws TopiaException {
        Variable v = this.getVariableEntity(name);
        if (Double.TYPE.isAssignableFrom(value.getClass()) || Double.class.isAssignableFrom(value.getClass())) {
            v.setDoubleValue((Double)value);
        } else if (value instanceof MatrixND) {
            v.setMatrixValue((MatrixND)value);
        } else if (value instanceof String) {
            Equation eq = v.getEquationValue();
            if (eq == null) {
                eq = new EquationImpl();
                eq.setContent((String)value);
            }
            v.setEquationValue(eq);
        }
    }

    public double eval(String name) throws TopiaException {
        Variable v = this.getVariableEntity(name);
        return this.eval(v);
    }

    protected double eval(Variable v) {
        Equation eq = v.getEquationValue();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("context", this.simulationContext);
        args.put("entity", this.topiaEntity);
        args.put("step", this.simulationContext.getSimulationControl().getStep());
        Object val = EvaluatorHelper.evaluate("fr.ifremer.isisfish.equation", this.topiaEntity.getTopiaId() + "#" + v.getName(), VariableEquation.class, eq.getContent(), args);
        double result = 0.0;
        if (val instanceof Number) {
            result = ((Number)val).doubleValue();
        }
        return result;
    }
}

