/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Nocache;
import fr.ifremer.isisfish.util.Trace;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.nuiton.topia.persistence.TopiaEntity;

public class Cache {
    private static Log log = LogFactory.getLog(Cache.class);
    private static final int entityPackageLenght = "fr.ifremer.isisfish.entities.".length();
    private static final Object NULL = new Object();
    protected long totalCall = 0L;
    protected long cacheUsed = 0L;
    protected Map cache = new ReferenceMap(2, 0);

    protected Trace getTrace() {
        SimulationContext context = SimulationContext.get();
        Trace result = context.getTrace();
        return result;
    }

    public Object get(Method method, Object[] args, Object defaultValue) throws Throwable {
        ++this.totalCall;
        Object result = null;
        if (method.getAnnotation(Nocache.class) != null || method.getDeclaringClass().getAnnotation(Nocache.class) != null) {
            result = this.realCall(defaultValue);
        } else {
            String key;
            StringBuilder sbKey = new StringBuilder();
            TimeStep step = this.computeKey(sbKey, method, args);
            result = this.get(step, key = sbKey.toString().intern());
            if (result == null) {
                result = this.realCall(defaultValue);
                if (result != null) {
                    this.put(step, key, result);
                }
            } else {
                ++this.cacheUsed;
            }
        }
        return result;
    }

    protected TimeStep computeKey(StringBuilder sbKey, Method method, Object[] args) {
        TimeStep result = null;
        sbKey.append(method.getDeclaringClass().getSimpleName());
        sbKey.append(".");
        sbKey.append(method.getName());
        for (Object o : args) {
            sbKey.append(";");
            if (o == null) {
                sbKey.append("null");
                continue;
            }
            if (o instanceof Number || o instanceof String) {
                sbKey.append(o.toString());
                continue;
            }
            if (o instanceof TimeStep) {
                result = (TimeStep)o;
                sbKey.append(((TimeStep)o).getStep());
                continue;
            }
            if (o instanceof TopiaEntity) {
                sbKey.append(((TopiaEntity)o).getTopiaId().substring(entityPackageLenght));
                continue;
            }
            sbKey.append(o.getClass().getSimpleName());
            sbKey.append('@');
            sbKey.append(Integer.toHexString(System.identityHashCode(o)));
        }
        return result;
    }

    protected Map getCacheTimeStep(TimeStep step) {
        Map result;
        Object key = step;
        if (step == null) {
            key = NULL;
        }
        if ((result = (Map)this.cache.get(key)) == null) {
            result = new ReferenceMap(0, 1);
            this.cache.put(key, result);
        }
        return result;
    }

    protected Object get(TimeStep step, Object key) {
        Object result = null;
        Map cacheTimeStep = this.getCacheTimeStep(step);
        if (cacheTimeStep != null) {
            result = cacheTimeStep.get(key);
        }
        return result;
    }

    protected void put(TimeStep step, Object key, Object value) {
        this.getCacheTimeStep(step).put(key, value);
    }

    protected Object realCall(Object defaultValue) throws Throwable {
        Object result = defaultValue;
        if (defaultValue instanceof JoinPoint) {
            result = ((JoinPoint)defaultValue).proceed();
        }
        return result;
    }

    public void clear() {
        this.cache.clear();
    }

    public void clear(TimeStep step) {
        Object key = step;
        if (key == null) {
            key = NULL;
        }
        this.cache.remove(key);
    }

    public long getCacheUsed() {
        long result = this.cacheUsed;
        return result;
    }

    public long getTotalCall() {
        long result = this.totalCall;
        return result;
    }

    public String printStatistiqueAndClear() {
        StringBuilder result = new StringBuilder();
        result.append("--- Cache Statistiques ---\n");
        result.append("Total call: ").append(this.totalCall).append("\n");
        result.append("Cache used: ").append(this.cacheUsed).append("\n");
        long percent = 0L;
        if (this.totalCall != 0L) {
            percent = 100L * this.cacheUsed / this.totalCall;
        }
        result.append("Cache usage: ").append(percent).append("%\n");
        result.append("--------------------\n");
        this.cache.clear();
        System.out.println(result.toString());
        return result.toString();
    }
}

