/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.script;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.nuiton.i18n.I18n;

public class FileSelectionTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 6327223042377741126L;
    public static final String[] COLUMN_NAMES = new String[]{I18n._((String)"isisfish.common.ellipsis", (Object[])new Object[0]), I18n._((String)"isisfish.common.module", (Object[])new Object[0]), I18n._((String)"isisfish.common.file", (Object[])new Object[0])};
    protected List<String> availableFiles;
    protected List<String> selectedFiles;

    public FileSelectionTableModel(List<String> availableFiles) {
        this.availableFiles = availableFiles;
        this.selectedFiles = new ArrayList<String>(availableFiles);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class result = null;
        switch (columnIndex) {
            case 0: {
                result = Boolean.class;
                break;
            }
            default: {
                result = String.class;
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public int getRowCount() {
        return this.availableFiles.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        String rowFileName = this.availableFiles.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = this.selectedFiles.contains(rowFileName);
                break;
            }
            case 1: {
                if (rowFileName.contains(File.separator)) {
                    result = rowFileName.substring(0, rowFileName.lastIndexOf(File.separator));
                    break;
                }
                result = rowFileName;
                break;
            }
            case 2: {
                result = rowFileName.contains(File.separator) ? rowFileName.substring(rowFileName.lastIndexOf(File.separator) + 1) : "";
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        String rowFileName = this.availableFiles.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                Boolean booleanValue = (Boolean)value;
                if (booleanValue.booleanValue()) {
                    this.selectedFiles.add(rowFileName);
                    break;
                }
                this.selectedFiles.remove(rowFileName);
                break;
            }
            default: {
                throw new RuntimeException("Can't edit that column");
            }
        }
    }

    public void setAllChecked(boolean selection) {
        if (selection) {
            this.selectedFiles.addAll(this.availableFiles);
        } else {
            this.selectedFiles.clear();
        }
        this.fireTableDataChanged();
    }

    public List<String> getSelectedFiles() {
        return this.selectedFiles;
    }
}

