/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.equation.SelectivityEquation;
import fr.ifremer.isisfish.ui.input.ChangeModel;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputOneEquationUI;
import fr.ifremer.isisfish.ui.input.model.GearPopulationSelectivityModel;
import fr.ifremer.isisfish.ui.input.model.PopulationComboModel;
import fr.ifremer.isisfish.ui.widget.editor.EquationTableEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SelectivityUI
extends InputContentUI<Gear>
implements JAXXValidator {
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_POPULATION = "population";
    public static final String BINDING_ADD_SELECTIVITY_BUTTON_ENABLED = "addSelectivityButton.enabled";
    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_FIELD_SELECTIVITY_POPULATION_ENABLED = "fieldSelectivityPopulation.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_SELECTIVITY_EQUATION_ACTIVE = "selectivityEquation.active";
    public static final String BINDING_SELECTIVITY_EQUATION_BEAN = "selectivityEquation.bean";
    public static final String BINDING_SELECTIVITY_TABLE_ENABLED = "selectivityTable.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28TRxSemNjBSSkhCUkoP5SAJRBB63BBiCCaYhpiy5SoJijgC2PvOB403pnMzDobDqh/Qv+Ecu+lUm89VT303EMvVf+Fquqh16pvdu39kZhlhXPYdea975vvfW/m7fd/obySaPU19jxLuo6mPWLVvtjbe9p6Tdr6EVFtSYXmEgV/EzmUa6IZO1xXGl1r1g28PICXK7wnuEOcGHqjjqaVPmJEdQnRGl1OItpKlRtheMMTrhyyhqJGsX73z9+5b+1v3uUQ8gSom4NSVj6EiiqZrKMctTWag536uMywsw8yJHX2Qe8Zs1ZhWKmvcI8coLdoqo4KAksg0+hq9pJ9Dh/vCY1mS1VHuLrCHQ3pu9V1jW52pEU7kvQIvBVVHaq6lkstahKtBmHQCNqn+mi3KoTPVNBoskWwo9HqKCwQU02Jsh4TLCPItODCZVhT2BtdTwXuhJkRvNjHjNoYStNoLWFyGLDUIZhnNczz+XAxYphpd8Fi8oTbhGl0I7XsSpQaL5rbR9Av0xpvsFltBzvxnKnSM9xiBHxdTogMsv2YyVw+Drht/r1sHhfD0OlSrY5bhK0f39NfNUlXwtzPOpQwO9atnZjb5xNoOC0t/pB7SYJ5FWG/PHAHyHKqS/5ZeuqQYf5uNcm5gO24pIeu1oZ0PiEnWE0Cz5RqjbbkjBl3ofylBCIKJVGzsRJ8U4/7Ftp/K5JYqlOlByK543ccNrwSx53MiPq9BN7wPjlRpQmvJeVNKtwn4XrU5kIbO+2gn8OIRBcTpwcmlBVNqGiETDRRXrqwDMeteXKofQ2hYJwtHxtnhtCP/rc4//tPf/64NZxhC7D3+ZGpsREMs0VILog0t1Wjs8EAczVl5SdYbDRRMeiEP58vjRDWGIRBHOx3zsAtA7e2seoCRX7qj59/WXz12ymU20LTjGN7C5v8KirqrgQXOLM98fmmr+iTw9PwnDXa4DoFlxzG6qf34f7jlRZ1bGjiAw9cuDTChVBKq/jrv/ONHzaHTkyAsgvvTY/cyL9EBeow6hB/ng9G9cj5PSMUcW0ejeRRQ3rCvBfF4Iht+s9Ho0rN+4PPhB97rnlt+6rNr1pmkinimEuRRrOagWZSEw++S3P3AydWsIYPWcvV5MHHcprlRoqqUgZVBWzuJElhuZ6lNvOtG5Mj32b4zZsxSc52uOzBTaxgTfa5PDKJLz6Wzizvjc2Q1qGbY2vIxpCmYT2DrUXJD7cJ3e/qFCkfJgqlvIfhzth2ZGNIs+Pu2BqyMaRpuDe2BsPwPwTcvf46DAAA";
    private static final Log log = LogFactory.getLog(SelectivityUI.class);
    private static final long serialVersionUID = 1L;
    private boolean allComponentsCreated;
    protected JButton addSelectivityButton;
    protected Gear bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected JComboBox fieldSelectivityPopulation;
    protected Population population;
    protected JButton removeSelectivityButton;
    protected JButton save;
    protected InputOneEquationUI selectivityEquation;
    protected JTable selectivityTable;
    @Validator(validatorId="validator")
    protected SwingValidator<Gear> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    private SelectivityUI $InputContentUI0 = this;
    private Table $Table0;
    private Table $Table1;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;

    protected void $afterCompleteSetup() {
        this.addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    SelectivityUI.this.setPopulation(null);
                    SelectivityUI.this.selectivityTable.setModel(new GearPopulationSelectivityModel());
                }
                if (evt.getNewValue() != null) {
                    SelectivityUI.this.refresh();
                }
            }
        });
    }

    @Override
    public void resetChangeModel() {
        this.changeModel.setStayChanged(false);
    }

    public void refresh() {
        Gear gear = this.getSaveVerifier().getEntity(Gear.class);
        if (this.getBean() != null) {
            this.setSelectivityTableModel();
            this.fieldSelectivityPopulation.setModel(this.getSelectivityPopulationModel());
        }
    }

    protected void setSelectivityTableModel() {
        ArrayList<Selectivity> selectivitiesList = new ArrayList<Selectivity>();
        if (this.getBean().getPopulationSelectivity() != null) {
            for (Selectivity oneSelectivity : this.getBean().getPopulationSelectivity()) {
                this.getSaveVerifier().addCurrentEntity(oneSelectivity);
                selectivitiesList.add(oneSelectivity);
                oneSelectivity.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        SelectivityUI.this.changeModel.setStayChanged(true);
                    }
                });
            }
        }
        GearPopulationSelectivityModel model = new GearPopulationSelectivityModel(selectivitiesList);
        this.selectivityTable.setModel(model);
        this.selectivityTable.setDefaultRenderer(Equation.class, model);
        this.selectivityTable.setDefaultEditor(Equation.class, new EquationTableEditor());
    }

    protected void addSelectivity() {
        this.getAction().addSelectivity(this.getPopulation(), this.selectivityEquation.getEditor().getText(), this.getBean());
        this.setSelectivityTableModel();
    }

    protected void removeSelectivity() {
        GearPopulationSelectivityModel model = (GearPopulationSelectivityModel)this.selectivityTable.getModel();
        Selectivity selectedSelectivity = model.getSelectivities().get(this.selectivityTable.getSelectedRow());
        this.getAction().removeSelectivity(this.getBean(), selectedSelectivity);
        this.getSaveVerifier().removeCurrentEntity(selectedSelectivity.getTopiaId());
        this.setSelectivityTableModel();
        this.removeSelectivityButton.setEnabled(false);
    }

    protected DefaultComboBoxModel getSelectivityPopulationModel() {
        List<Species> species = this.getFisheryRegion().getSpecies();
        ArrayList<Population> populations = new ArrayList<Population>();
        if (species != null) {
            for (Species s : species) {
                if (s.getPopulation() == null) continue;
                populations.addAll(s.getPopulation());
            }
        }
        PopulationComboModel selectivityPopulationModel = new PopulationComboModel(populations);
        return selectivityPopulationModel;
    }

    protected void selectivityChanged() {
        this.setPopulation((Population)this.fieldSelectivityPopulation.getSelectedItem());
    }

    public SelectivityUI() {
        this.$initialize();
    }

    public SelectivityUI(JAXXContext param0) {
        super(param0);
        this.$initialize();
    }

    public SelectivityUI(boolean param0) {
        super(param0);
        this.$initialize();
    }

    public SelectivityUI(JAXXContext param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public SelectivityUI(LayoutManager param0) {
        super(param0);
        this.$initialize();
    }

    public SelectivityUI(JAXXContext param0, LayoutManager param1) {
        super(param0, param1);
        this.$initialize();
    }

    public SelectivityUI(LayoutManager param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public SelectivityUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0, param1, param2);
        this.$initialize();
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator)(this.validatorIds.contains(validatorId) ? this.getObjectById(validatorId) : null);
    }

    public List<String> getValidatorIds() {
        return this.validatorIds;
    }

    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields((JAXXValidator)this);
    }

    public void doActionPerformed__on__addSelectivityButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.addSelectivity();
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__removeSelectivityButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.removeSelectivity();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.getSaveVerifier().save();
        this.validator.setChanged(false);
        this.changeModel.setStayChanged(false);
    }

    public void doItemStateChanged__on__fieldSelectivityPopulation(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.selectivityChanged();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.removeSelectivityButton.setEnabled(this.isActive() != false && this.selectivityTable.getSelectedRow() != -1);
    }

    public JButton getAddSelectivityButton() {
        return this.addSelectivityButton;
    }

    @Override
    public Gear getBean() {
        return this.bean;
    }

    public JButton getCancel() {
        return this.cancel;
    }

    public ChangeModel getChangeModel() {
        return this.changeModel;
    }

    public JComboBox getFieldSelectivityPopulation() {
        return this.fieldSelectivityPopulation;
    }

    public Population getPopulation() {
        return this.population;
    }

    public JButton getRemoveSelectivityButton() {
        return this.removeSelectivityButton;
    }

    public JButton getSave() {
        return this.save;
    }

    public InputOneEquationUI getSelectivityEquation() {
        return this.selectivityEquation;
    }

    public JTable getSelectivityTable() {
        return this.selectivityTable;
    }

    public SwingValidator<Gear> getValidator() {
        return this.validator;
    }

    @Override
    public void setBean(Gear bean) {
        Gear oldValue = this.bean;
        this.bean = bean;
        this.firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPopulation(Population population) {
        Population oldValue = this.population;
        this.population = population;
        this.firePropertyChange(PROPERTY_POPULATION, oldValue, population);
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected Table get$Table1() {
        return this.$Table1;
    }

    protected JLabel get$JLabel0() {
        return this.$JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return this.$JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return this.$ListSelectionModel0;
    }

    protected void addChildrenToBody() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.body.add((Component)this.$Table0);
    }

    protected void addChildrenToValidator() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.validator.setUiClass(ImageValidationUI.class);
    }

    protected void createAddSelectivityButton() {
        this.addSelectivityButton = new JButton();
        this.$objectMap.put("addSelectivityButton", this.addSelectivityButton);
        this.addSelectivityButton.setName("addSelectivityButton");
        this.addSelectivityButton.setText(I18n._((String)"isisfish.common.add", (Object[])new Object[0]));
        this.addSelectivityButton.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__addSelectivityButton"));
    }

    protected void createBean() {
        this.bean = null;
        this.$objectMap.put(PROPERTY_BEAN, null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        this.body.setName("body");
    }

    protected void createCancel() {
        this.cancel = new JButton();
        this.$objectMap.put("cancel", this.cancel);
        this.cancel.setName("cancel");
        this.cancel.setText(I18n._((String)"isisfish.common.cancel", (Object[])new Object[0]));
        this.cancel.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        this.changeModel = new ChangeModel();
        this.$objectMap.put("changeModel", this.changeModel);
    }

    protected void createFieldSelectivityPopulation() {
        this.fieldSelectivityPopulation = new JComboBox();
        this.$objectMap.put("fieldSelectivityPopulation", this.fieldSelectivityPopulation);
        this.fieldSelectivityPopulation.setName("fieldSelectivityPopulation");
        this.fieldSelectivityPopulation.addItemListener((ItemListener)JAXXUtil.getEventListener(ItemListener.class, (String)"itemStateChanged", (Object)this, (String)"doItemStateChanged__on__fieldSelectivityPopulation"));
    }

    protected void createPopulation() {
        this.population = null;
        this.$objectMap.put(PROPERTY_POPULATION, null);
    }

    protected void createRemoveSelectivityButton() {
        this.removeSelectivityButton = new JButton();
        this.$objectMap.put("removeSelectivityButton", this.removeSelectivityButton);
        this.removeSelectivityButton.setName("removeSelectivityButton");
        this.removeSelectivityButton.setEnabled(false);
        this.removeSelectivityButton.setText(I18n._((String)"isisfish.common.remove", (Object[])new Object[0]));
        this.removeSelectivityButton.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__removeSelectivityButton"));
    }

    protected void createSave() {
        this.save = new JButton();
        this.$objectMap.put("save", this.save);
        this.save.setName("save");
        this.save.setText(I18n._((String)"isisfish.common.save", (Object[])new Object[0]));
        this.save.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__save"));
    }

    protected void createSelectivityEquation() {
        this.selectivityEquation = new InputOneEquationUI((JAXXContext)this);
        this.$objectMap.put("selectivityEquation", this.selectivityEquation);
        this.selectivityEquation.setName("selectivityEquation");
        this.selectivityEquation.setFormuleCategory("Selectivity");
        this.selectivityEquation.setText(I18n._((String)"isisfish.selectivity.equation", (Object[])new Object[0]));
    }

    protected void createSelectivityTable() {
        this.selectivityTable = new JTable();
        this.$objectMap.put("selectivityTable", this.selectivityTable);
        this.selectivityTable.setName("selectivityTable");
        this.selectivityTable.setRowHeight(24);
    }

    protected void createValidator() {
        this.validator = SwingValidatorUtil.newValidator(Gear.class, (String)"selectivity");
        this.$objectMap.put("validator", this.validator);
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.addChildrenToValidator();
        this.addChildrenToBody();
        this.$Table0.add((Component)this.$Table1, (Object)new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.save), (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.cancel), (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.$JLabel0), (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.fieldSelectivityPopulation), (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.selectivityEquation), (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.$Table1.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.addSelectivityButton), (Object)new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JScrollPane0, (Object)new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.removeSelectivityButton), (Object)new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$JScrollPane0.getViewport().add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.selectivityTable));
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.selectivityEquation.setClazz(SelectivityEquation.class);
        this.validatorIds = SwingValidatorUtil.detectValidators((JAXXValidator)this);
        SwingValidatorUtil.installUI((JAXXValidator)this);
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.$objectMap.put("$InputContentUI0", this.$InputContentUI0);
        this.createBean();
        this.createPopulation();
        this.createValidator();
        this.createChangeModel();
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.$Table1 = new Table();
        this.$objectMap.put("$Table1", this.$Table1);
        this.$Table1.setName("$Table1");
        this.$JLabel0 = new JLabel();
        this.$objectMap.put("$JLabel0", this.$JLabel0);
        this.$JLabel0.setName("$JLabel0");
        this.$JLabel0.setText(I18n._((String)"isisfish.selectivity.selectPopulation", (Object[])new Object[0]));
        this.createFieldSelectivityPopulation();
        this.createSelectivityEquation();
        this.createAddSelectivityButton();
        this.$JScrollPane0 = new JScrollPane();
        this.$objectMap.put("$JScrollPane0", this.$JScrollPane0);
        this.$JScrollPane0.setName("$JScrollPane0");
        this.createSelectivityTable();
        this.$ListSelectionModel0 = this.selectivityTable.getSelectionModel();
        this.$objectMap.put("$ListSelectionModel0", this.$ListSelectionModel0);
        this.$ListSelectionModel0.addListSelectionListener((ListSelectionListener)JAXXUtil.getEventListener(ListSelectionListener.class, (String)"valueChanged", (Object)this, (String)"doValueChanged__on__$ListSelectionModel0"));
        this.createRemoveSelectivityButton();
        this.createSave();
        this.createCancel();
        this.setName("$InputContentUI0");
        this.$registerDefaultBindings();
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                SelectivityUI.this.validator.setBean((Object)SelectivityUI.this.getBean());
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true){

            public void applyDataBinding() {
                if (SelectivityUI.this.validator != null) {
                    SelectivityUI.this.validator.addPropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SelectivityUI.this.validator != null) {
                    SelectivityUI.this.changeModel.setChanged(SelectivityUI.this.validator.isChanged());
                }
            }

            public void removeDataBinding() {
                if (SelectivityUI.this.validator != null) {
                    SelectivityUI.this.validator.removePropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true){

            public void applyDataBinding() {
                if (SelectivityUI.this.validator != null) {
                    SelectivityUI.this.validator.addPropertyChangeListener("valid", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SelectivityUI.this.validator != null) {
                    SelectivityUI.this.changeModel.setValid(SelectivityUI.this.validator.isValid());
                }
            }

            public void removeDataBinding() {
                if (SelectivityUI.this.validator != null) {
                    SelectivityUI.this.validator.removePropertyChangeListener("valid", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                SelectivityUI.this.$JLabel0.setEnabled(SelectivityUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FIELD_SELECTIVITY_POPULATION_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                SelectivityUI.this.fieldSelectivityPopulation.setEnabled(SelectivityUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_EQUATION_ACTIVE, true, new String[]{PROPERTY_POPULATION}){

            public void processDataBinding() {
                SelectivityUI.this.selectivityEquation.setActive(SelectivityUI.this.getPopulation() != null);
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_EQUATION_BEAN, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                SelectivityUI.this.selectivityEquation.setBean(SelectivityUI.this.getBean());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_ADD_SELECTIVITY_BUTTON_ENABLED, true, new String[]{PROPERTY_POPULATION}){

            public void processDataBinding() {
                SelectivityUI.this.addSelectivityButton.setEnabled(SelectivityUI.this.getPopulation() != null);
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_TABLE_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                SelectivityUI.this.selectivityTable.setEnabled(SelectivityUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true){

            public void applyDataBinding() {
                if (SelectivityUI.this.changeModel != null) {
                    SelectivityUI.this.changeModel.addPropertyChangeListener("valid", (PropertyChangeListener)((Object)this));
                }
                if (SelectivityUI.this.changeModel != null) {
                    SelectivityUI.this.changeModel.addPropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SelectivityUI.this.changeModel != null) {
                    SelectivityUI.this.save.setEnabled(SelectivityUI.this.changeModel.isValid() && SelectivityUI.this.changeModel.isChanged());
                }
            }

            public void removeDataBinding() {
                if (SelectivityUI.this.changeModel != null) {
                    SelectivityUI.this.changeModel.removePropertyChangeListener("valid", (PropertyChangeListener)((Object)this));
                }
                if (SelectivityUI.this.changeModel != null) {
                    SelectivityUI.this.changeModel.removePropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true){

            public void applyDataBinding() {
                if (SelectivityUI.this.changeModel != null) {
                    SelectivityUI.this.changeModel.addPropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SelectivityUI.this.changeModel != null) {
                    SelectivityUI.this.cancel.setEnabled(SelectivityUI.this.changeModel.isChanged());
                }
            }

            public void removeDataBinding() {
                if (SelectivityUI.this.changeModel != null) {
                    SelectivityUI.this.changeModel.removePropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
            }
        });
    }
}

