/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.formule.FormuleComboModel;
import fr.ifremer.isisfish.ui.input.formule.FormuleComboRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.util.FileUtil;
import org.nuiton.widget.editor.Editor;

public class InputOneEquationUI
extends InputContentUI<TopiaEntityContextable> {
    public static final String PROPERTY_AUTO_SAVE_MODIFICATION = "autoSaveModification";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_BEAN_PROPERTY = "beanProperty";
    public static final String PROPERTY_CLAZZ = "clazz";
    public static final String PROPERTY_FORMULE = "formule";
    public static final String PROPERTY_FORMULE_CATEGORY = "formuleCategory";
    public static final String PROPERTY_SELECTED_EQUATION = "selectedEquation";
    public static final String PROPERTY_TEXT = "text";
    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_FORMULE_COMBO_BOX_ENABLED = "formuleComboBox.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVzW8bRRSfuHW++pEU0yqIIkJxoULVOBUgDqlKSYhVW24b4Vaq8IVZ77MzZT2znXnbbHJA/An8CXDngsSNE+LAmQMXxL+AEAeuiDezttebmNQiPux65733e7/3sb/99g9Wtoa98VSkKTeJQjkA3vzoyZOHwVPo4sdgu0bGqA3LfnMlVuqwc+H43CJ7s9Ny4bVheG1bD2KtQE1Eb7bYssWDCOweACJ7rRjRtbbWHps30zgxI9QxqWmoX//1Z+mr8MtvSoylMbGrUCnrL4rKKznbYiUZInuJMj0XtUioPtEwUvWJ7wV3th0Jax+IATxjX7CFFpuPhSEwZNdmL9lj+Pg0RrZabag4wW2tkNwfNzaQ1XqGy56BAdDdStuTdo8nkkvnyL37QwU7zxKBUqvHjTj2cPPIziKkRGbVUeWOPs/oT3gEIBSyd7Xpc5VI1IqjjqXgMRhKRRy6wB+5kx2qBA88rxRFEEEOct6B7BpNMXjgzi7mtnI3EoeHyFZyDr7g3GOhp80giQBZdVqh4PJKsLyeueWBK8PAbYHQ1+Zo5lULEa0ohKPOILt+YoKRXw7xskhQt8VzuK9D2ZPdIcylvJYtrSMqPg+pVNt+wA1FoCKSh2BohG/5pevSFsiIcmc7wI95Ts5Fhwe0eS5Tyu0+DY03d4WCaKJx1UduDgS/VtjpzNvbnOf1ccBitdkSAUQbR4H9qXO6cby5ehDoLZ0iu1wIGZ0Xo4aUbrnHd4qmpWpzK0FaMMpeKUBlx87t1nFvD/V+0Uh1+FZsuOe3i7Z5CGmLDbLXJ1Z6X4Z9QJ6Z+I6/DdkZ9mqheSQ1PJeaXAvmOqxsqB+kZ2ud4+r0CZkyXVo7oksO0Fv/uVL59Yffv6+PxGiZcl+e6jqhpSQScfZiSZd6JVOiBGVUuy/izQ5byrbcC+3VKcTaQzORo3zZ5rpwfk/YPYIoL/z2409XPvvlDCvV2XKkRVgXzr/BlnDPUBd0FKbxh3c9o/P7i3Rdddxo1qDcrEkfL94OBYr1QKqQBnonpS5cndKFMZVg6ee/K+3v7o46MUfMXvlP97wb5U/ZvFSRVOCFeai5U4X4XGwhCXWurdPUds7db8bDN2rLX+vTSvU66qyNNHG3pift/rVmxHDH905AqM3AYpE+LSEYMKfCeRGT92ZC2CUJuZ3NYl0gfVSCBOHOaRBP4vTBbJzcJfi/CMguCPt5o/dAo1P88ASwzVMX5BD+BTp2mg9bCQAA";
    private static final Log log = LogFactory.getLog(InputOneEquationUI.class);
    private static final long serialVersionUID = 1L;
    private boolean allComponentsCreated;
    protected Boolean autoSaveModification;
    protected TopiaEntityContextable bean;
    protected String beanProperty;
    protected Class clazz;
    protected Editor editor;
    protected Formule formule;
    protected String formuleCategory;
    protected JComboBox formuleComboBox;
    protected Equation selectedEquation;
    protected String text;
    private InputOneEquationUI $InputContentUI0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private Table $Table1;
    private JButton $JButton0;
    private JButton $JButton1;
    private JPanel $JPanel0;
    protected DocumentListener listener;

    protected void $afterCompleteSetup() {
        this.addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                block4: {
                    if (evt.getNewValue() == null) {
                        InputOneEquationUI.this.formuleComboBox.setModel(new DefaultComboBoxModel());
                        try {
                            File nullFile = FileUtil.getTempFile((String)"", (String)".java");
                            InputOneEquationUI.this.editor.open(nullFile);
                            InputOneEquationUI.this.editor.setEnabled(false);
                        }
                        catch (IOException e) {
                            if (!log.isErrorEnabled()) break block4;
                            log.error((Object)"Error on property change", (Throwable)e);
                        }
                    }
                }
                if (evt.getNewValue() != null) {
                    InputOneEquationUI.this.refresh();
                }
            }
        });
        if (this.listener == null) {
            this.listener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    InputOneEquationUI.this.setEquation();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    InputOneEquationUI.this.setEquation();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
        }
        this.setComboModel();
    }

    protected Equation getEquation() {
        Equation result;
        block3: {
            result = null;
            try {
                if (this.bean != null && this.beanProperty != null) {
                    String localBeanProperty = StringUtils.capitalize((String)this.beanProperty);
                    Method m = this.bean.getClass().getMethod("get" + localBeanProperty, new Class[0]);
                    result = (Equation)m.invoke((Object)this.bean, new Object[0]);
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't get equation", (Throwable)e);
            }
        }
        return result;
    }

    protected void setEquation() {
        block6: {
            try {
                if (this.bean != null && this.beanProperty != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Saving equation content (" + this.bean.getClass().getSimpleName() + "#" + this.beanProperty + ")"));
                    }
                    String localBeanProperty = StringUtils.capitalize((String)this.beanProperty);
                    Method m = this.bean.getClass().getMethod("set" + localBeanProperty + "Content", String.class);
                    m.invoke((Object)this.bean, this.editor.getText());
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"No bean property defined, skipping content saving");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't set equation content", (Throwable)e);
            }
        }
    }

    public void refresh() {
        block5: {
            if (this.getText() == null) {
                this.setText(I18n._((String)"isisfish.common.equation", (Object[])new Object[0]));
            }
            this.editor.getCurrentEditor().removeDocumentListener(this.listener);
            try {
                File equationContentFile = FileUtil.getTempFile((String)"", (String)".java");
                this.editor.open(equationContentFile);
                this.editor.setEnabled(this.isActive().booleanValue());
            }
            catch (IOException ex) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Can't refresh editor", (Throwable)ex);
            }
        }
        if (this.formuleCategory != null) {
            this.selectedEquation = this.getEquation();
            this.setComboModel();
            this.setFormule((Formule)this.formuleComboBox.getSelectedItem());
            this.setEditorText();
        }
        if (this.autoSaveModification.booleanValue()) {
            this.editor.getCurrentEditor().addDocumentListener(this.listener);
        }
    }

    protected void setComboModel() {
        if (this.getBean() != null) {
            TopiaContext isisContext = ((TopiaEntityAbstract)this.getBean()).getTopiaContext();
            List<Formule> formules = null;
            if (this.formuleCategory != null) {
                formules = this.getAction().getFormules(isisContext, this.formuleCategory);
                FormuleComboModel formulesModel = new FormuleComboModel(formules);
                this.formuleComboBox.setModel(formulesModel);
                this.formuleComboBox.setSelectedItem(this.selectedEquation);
            }
        }
    }

    protected void saveModel() {
        this.getContextValue(InputAction.class).saveAsModel(this.formuleCategory, "Java", this.editor.getText());
        this.setComboModel();
        this.setInfoText(I18n._((String)"isisfish.message.saveModel.finished", (Object[])new Object[0]));
    }

    protected void openEditor() {
        Formule e = (Formule)this.formuleComboBox.getSelectedItem();
        if (e != null) {
            this.getContextValue(InputAction.class).openEditor(this, e.getCategory(), e.getName(), this.clazz, e.getContent(), this.editor);
        } else {
            this.getContextValue(InputAction.class).openEditor(this, this.formuleCategory, "new", this.clazz, this.editor.getText(), this.editor);
        }
    }

    protected void setEditorText() {
        block4: {
            if (this.getFormule() != null) {
                this.editor.setText(this.getFormule().getContent());
            } else {
                try {
                    File nullFile = FileUtil.getTempFile((String)"", (String)".java");
                    this.editor.open(nullFile);
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Open editor", (Throwable)e);
                }
            }
        }
    }

    protected void formuleChanged() {
        Formule selectedFormule = (Formule)this.formuleComboBox.getSelectedItem();
        this.setFormule(selectedFormule);
        this.setEditorText();
    }

    public InputOneEquationUI() {
        this.$initialize();
    }

    public InputOneEquationUI(JAXXContext param0) {
        super(param0);
        this.$initialize();
    }

    public InputOneEquationUI(boolean param0) {
        super(param0);
        this.$initialize();
    }

    public InputOneEquationUI(JAXXContext param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public InputOneEquationUI(LayoutManager param0) {
        super(param0);
        this.$initialize();
    }

    public InputOneEquationUI(JAXXContext param0, LayoutManager param1) {
        super(param0, param1);
        this.$initialize();
    }

    public InputOneEquationUI(LayoutManager param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public InputOneEquationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0, param1, param2);
        this.$initialize();
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.saveModel();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.openEditor();
    }

    public void doActionPerformed__on__formuleComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.formuleChanged();
    }

    public Boolean getAutoSaveModification() {
        return this.autoSaveModification;
    }

    @Override
    public TopiaEntityContextable getBean() {
        return this.bean;
    }

    public String getBeanProperty() {
        return this.beanProperty;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public Formule getFormule() {
        return this.formule;
    }

    public String getFormuleCategory() {
        return this.formuleCategory;
    }

    public JComboBox getFormuleComboBox() {
        return this.formuleComboBox;
    }

    public Equation getSelectedEquation() {
        return this.selectedEquation;
    }

    public String getText() {
        return this.text;
    }

    public Boolean isAutoSaveModification() {
        return this.autoSaveModification != null && this.autoSaveModification != false;
    }

    public void setAutoSaveModification(Boolean autoSaveModification) {
        Boolean oldValue = this.autoSaveModification;
        this.autoSaveModification = autoSaveModification;
        this.firePropertyChange(PROPERTY_AUTO_SAVE_MODIFICATION, oldValue, autoSaveModification);
    }

    @Override
    public void setBean(TopiaEntityContextable bean) {
        TopiaEntityContextable oldValue = this.bean;
        this.bean = bean;
        this.firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setBeanProperty(String beanProperty) {
        String oldValue = this.beanProperty;
        this.beanProperty = beanProperty;
        this.firePropertyChange(PROPERTY_BEAN_PROPERTY, oldValue, beanProperty);
    }

    public void setClazz(Class clazz) {
        Class oldValue = this.clazz;
        this.clazz = clazz;
        this.firePropertyChange(PROPERTY_CLAZZ, oldValue, clazz);
    }

    public void setFormule(Formule formule) {
        Formule oldValue = this.formule;
        this.formule = formule;
        this.firePropertyChange(PROPERTY_FORMULE, oldValue, formule);
    }

    public void setFormuleCategory(String formuleCategory) {
        String oldValue = this.formuleCategory;
        this.formuleCategory = formuleCategory;
        this.firePropertyChange(PROPERTY_FORMULE_CATEGORY, oldValue, formuleCategory);
    }

    public void setSelectedEquation(Equation selectedEquation) {
        Equation oldValue = this.selectedEquation;
        this.selectedEquation = selectedEquation;
        this.firePropertyChange(PROPERTY_SELECTED_EQUATION, oldValue, selectedEquation);
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        this.firePropertyChange(PROPERTY_TEXT, oldValue, text);
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected JLabel get$JLabel0() {
        return this.$JLabel0;
    }

    protected Table get$Table1() {
        return this.$Table1;
    }

    protected JButton get$JButton0() {
        return this.$JButton0;
    }

    protected JButton get$JButton1() {
        return this.$JButton1;
    }

    protected JPanel get$JPanel0() {
        return this.$JPanel0;
    }

    protected void addChildrenToBody() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.body.add((Component)this.$Table0);
    }

    protected void createAutoSaveModification() {
        this.autoSaveModification = true;
        this.$objectMap.put(PROPERTY_AUTO_SAVE_MODIFICATION, this.autoSaveModification);
    }

    protected void createBean() {
        this.bean = null;
        this.$objectMap.put(PROPERTY_BEAN, null);
    }

    protected void createBeanProperty() {
        this.beanProperty = null;
        this.$objectMap.put(PROPERTY_BEAN_PROPERTY, null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        this.body.setName("body");
    }

    protected void createClazz() {
        this.clazz = null;
        this.$objectMap.put(PROPERTY_CLAZZ, null);
    }

    protected void createEditor() {
        this.editor = new Editor();
        this.$objectMap.put("editor", this.editor);
        this.editor.setName("editor");
        this.editor.setAskIfNotSaved(false);
    }

    protected void createFormule() {
        this.formule = null;
        this.$objectMap.put(PROPERTY_FORMULE, null);
    }

    protected void createFormuleCategory() {
        this.formuleCategory = null;
        this.$objectMap.put(PROPERTY_FORMULE_CATEGORY, null);
    }

    protected void createFormuleComboBox() {
        this.formuleComboBox = new JComboBox();
        this.$objectMap.put("formuleComboBox", this.formuleComboBox);
        this.formuleComboBox.setName("formuleComboBox");
        this.formuleComboBox.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__formuleComboBox"));
    }

    protected void createSelectedEquation() {
        this.selectedEquation = null;
        this.$objectMap.put(PROPERTY_SELECTED_EQUATION, null);
    }

    protected void createText() {
        this.text = null;
        this.$objectMap.put(PROPERTY_TEXT, null);
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.addChildrenToBody();
        this.$Table0.add((Component)this.$JLabel0, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.formuleComboBox, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.$Table1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.editor, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JButton0, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JButton1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JPanel0, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.formuleComboBox.setRenderer(new FormuleComboRenderer());
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.$objectMap.put("$InputContentUI0", this.$InputContentUI0);
        this.createText();
        this.createBean();
        this.createBeanProperty();
        this.createClazz();
        this.createFormule();
        this.createFormuleCategory();
        this.createSelectedEquation();
        this.createAutoSaveModification();
        this.listener = null;
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.$JLabel0 = new JLabel();
        this.$objectMap.put("$JLabel0", this.$JLabel0);
        this.$JLabel0.setName("$JLabel0");
        this.createFormuleComboBox();
        this.$Table1 = new Table();
        this.$objectMap.put("$Table1", this.$Table1);
        this.$Table1.setName("$Table1");
        this.$JButton0 = new JButton();
        this.$objectMap.put("$JButton0", this.$JButton0);
        this.$JButton0.setName("$JButton0");
        this.$JButton0.setText(I18n._((String)"isisfish.common.saveModel", (Object[])new Object[0]));
        this.$JButton0.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__$JButton0"));
        this.$JButton1 = new JButton();
        this.$objectMap.put("$JButton1", this.$JButton1);
        this.$JButton1.setName("$JButton1");
        this.$JButton1.setText(I18n._((String)"isisfish.common.openEditor", (Object[])new Object[0]));
        this.$JButton1.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__$JButton1"));
        this.$JPanel0 = new JPanel();
        this.$objectMap.put("$JPanel0", this.$JPanel0);
        this.$JPanel0.setName("$JPanel0");
        this.createEditor();
        this.setName("$InputContentUI0");
        this.$registerDefaultBindings();
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                InputOneEquationUI.this.$JLabel0.setEnabled(InputOneEquationUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true, new String[]{PROPERTY_TEXT}){

            public void processDataBinding() {
                InputOneEquationUI.this.$JLabel0.setText(I18n._((String)InputOneEquationUI.this.getText(), (Object[])new Object[0]));
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FORMULE_COMBO_BOX_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                InputOneEquationUI.this.formuleComboBox.setEnabled(InputOneEquationUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                InputOneEquationUI.this.$JButton0.setEnabled(InputOneEquationUI.this.isActive() != false && InputOneEquationUI.this.formuleCategory != null);
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                InputOneEquationUI.this.$JButton1.setEnabled(InputOneEquationUI.this.isActive() != false && InputOneEquationUI.this.clazz != null && InputOneEquationUI.this.formuleCategory != null);
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                InputOneEquationUI.this.editor.setEnabled(InputOneEquationUI.this.isActive().booleanValue());
            }
        });
    }
}

