/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.MapMouseListener;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class CopyMapToClipboardListener
implements ActionListener,
MapMouseListener {
    private static Log log = LogFactory.getLog(CopyMapToClipboardListener.class);
    protected static final String COPY_TO_CLICBOARD_COMMAND = "copytoclipboard";
    public JPopupMenu menu;
    protected MapBean mapBean;

    public CopyMapToClipboardListener(MapBean mapBean) {
        this.mapBean = mapBean;
        this.menu = new JPopupMenu();
        JMenuItem copyClicboardItem = new JMenuItem();
        copyClicboardItem.setText(I18n._((String)"isisfish.input.map.copytoclicboard", (Object[])new Object[0]));
        copyClicboardItem.setActionCommand(COPY_TO_CLICBOARD_COMMAND);
        copyClicboardItem.addActionListener(this);
        this.menu.add(copyClicboardItem);
    }

    public MapBean getMapBean() {
        return this.mapBean;
    }

    protected void copyToClipBoard() {
        int width = this.getMapBean().getWidth();
        int height = this.getMapBean().getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Graphics2D g = ge.createGraphics(image);
        g.setClip(0, 0, width, height);
        this.getMapBean().paintAll((Graphics)g);
        ImageSelection imgSel = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imgSel, null);
        if (log.isInfoEnabled()) {
            log.info((Object)"Copy current image to system clipboard");
        }
    }

    public String[] getMouseModeServiceList() {
        return null;
    }

    public boolean mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            this.menu.show((Component)this.mapBean, e.getX(), e.getY());
        }
        return false;
    }

    public boolean mouseDragged(MouseEvent arg0) {
        return false;
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mouseMoved() {
    }

    public boolean mouseMoved(MouseEvent arg0) {
        return false;
    }

    public boolean mousePressed(MouseEvent arg0) {
        return false;
    }

    public boolean mouseReleased(MouseEvent arg0) {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(COPY_TO_CLICBOARD_COMMAND)) {
            this.copyToClipBoard();
        }
    }

    public static class ImageSelection
    implements Transferable {
        private Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

