/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.ActiveRule;
import fr.ifremer.isisfish.entities.ActiveRuleDAO;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationException;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.SimulationResultGetter;
import fr.ifremer.isisfish.simulator.SimulationResultListener;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.BitUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.DoubleBigMappedVector;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixSemanticsDecorator;
import org.nuiton.math.matrix.SemanticsDecorator;
import org.nuiton.math.matrix.Vector;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.ArrayUtil;
import org.nuiton.util.HashList;

public class ResultMappedStorage
implements SimulationResultListener,
SimulationResultGetter,
ResultStorage {
    private static Log log = LogFactory.getLog(ResultMappedStorage.class);
    protected static MatrixFactory matrixFactory = MatrixFactory.getInstance(DoubleBigMappedVector.class);
    protected SimulationStorage simulation = null;
    protected RandomAccessFile raf;
    protected long offset;
    protected Map<TimeStep, Map<String, ResultMapped>> stepNameResults = new TreeMap<TimeStep, Map<String, ResultMapped>>();
    protected Map<String, Map<TimeStep, ResultMapped>> nameStepResults = new TreeMap<String, Map<TimeStep, ResultMapped>>();
    protected transient Set<String> enabledResult = null;

    public ResultMappedStorage(SimulationStorage simulation) throws IOException {
        this.simulation = simulation;
        File file = SimulationStorage.getResultFile(simulation.getDirectory());
        this.raf = new RandomAccessFile(file, "rw");
        this.offset = 0L;
        while (this.offset < this.raf.length()) {
            ResultMapped r = new ResultMapped(this.raf, this.offset);
            this.storeResult(r);
            this.offset += r.size();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.raf.close();
    }

    @Override
    public void delete() {
        this.close();
        File file = SimulationStorage.getResultFile(this.simulation.getDirectory());
        file.delete();
    }

    @Override
    public void close() {
        if (this.raf != null) {
            IOUtils.closeQuietly((Closeable)this.raf);
            this.raf = null;
        }
    }

    protected void storeResult(ResultMapped r) {
        TimeStep step = r.getStep();
        String name = r.getName();
        this.getResult(step).put(name, r);
        Map<TimeStep, ResultMapped> stepResult = this.nameStepResults.get(name);
        if (stepResult == null) {
            stepResult = new TreeMap<TimeStep, ResultMapped>();
            this.nameStepResults.put(name, stepResult);
        }
        stepResult.put(step, r);
    }

    protected Map<String, ResultMapped> getResult(TimeStep step) {
        Map<String, ResultMapped> result = this.stepNameResults.get(step);
        if (result == null) {
            result = new TreeMap<String, ResultMapped>();
            this.stepNameResults.put(step, result);
        }
        return result;
    }

    protected ResultMapped getResult(TimeStep step, String name) {
        ResultMapped result = this.getResult(step).get(name);
        return result;
    }

    protected ResultMapped getResult(TimeStep step, String name, Population pop) {
        name = name + " " + pop;
        ResultMapped result = this.getResult(step, name);
        return result;
    }

    protected Map<TimeStep, ResultMapped> getResult(String name, Population pop) {
        name = name + " " + pop;
        Map<TimeStep, ResultMapped> result = this.getResult(name);
        return result;
    }

    protected Map<TimeStep, ResultMapped> getResult(String name) {
        Map result = this.nameStepResults.get(name);
        if (result == null) {
            result = Collections.EMPTY_MAP;
        }
        return result;
    }

    @Override
    public void addResult(TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), mat);
    }

    @Override
    public void addResult(TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), pop, mat);
    }

    @Override
    public void addResult(boolean force, TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), mat);
    }

    @Override
    public void addResult(boolean force, TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), pop, mat);
    }

    @Override
    public void addResult(TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, pop, mat);
    }

    @Override
    public void addResult(TimeStep step, String name, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, mat);
    }

    @Override
    public void addResult(boolean force, TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            this.doAddResult(step, name + " " + pop, mat);
        }
    }

    @Override
    public void addResult(boolean force, TimeStep step, String name, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            this.doAddResult(step, name, mat);
        }
    }

    protected void doAddResult(TimeStep step, String name, MatrixND mat) throws IsisFishException {
        for (int i = 0; i < mat.getDimCount(); ++i) {
            if (!mat.getSemantic(i).contains(null)) continue;
            throw new SimulationException("Erreur le r\u00e9sultat que vous souhaitez enregistrer n'a pas d'information convenable pour la dimension: " + i + " " + mat.getDimensionName(i));
        }
        try {
            ResultMapped r = new ResultMapped(this.raf, this.offset, step, name, mat);
            this.storeResult(r);
            this.offset += r.size();
        }
        catch (IOException eee) {
            log.warn((Object)("Can't add result '" + name + "' at step " + step), (Throwable)eee);
        }
    }

    @Override
    public boolean isEnabled(String name) {
        name = name.trim();
        if (this.enabledResult == null && this.simulation.getSimulationParametersFile().exists()) {
            List<SimulationPlan> plans;
            List<Rule> rules;
            List<SensitivityExport> sensitivityExports;
            this.enabledResult = new HashSet<String>();
            Collection<String> resultEnabled = this.simulation.getParameter().getResultEnabled();
            this.enabledResult.addAll(resultEnabled);
            List<String> exportNames = this.simulation.getParameter().getExportNames();
            if (exportNames != null) {
                for (String exportName : exportNames) {
                    ExportStorage storage = ExportStorage.getExport(exportName, new CodeSourceStorage.Location[0]);
                    try {
                        Export export = storage.getNewExportInstance();
                        for (String resultName : export.getNecessaryResult()) {
                            this.enabledResult.add(resultName);
                        }
                    }
                    catch (IsisFishException eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)I18n._((String)"isisfish.error.instanciate.export", (Object[])new Object[]{exportName}), (Throwable)eee);
                    }
                }
            }
            if ((sensitivityExports = this.simulation.getParameter().getSensitivityExport()) != null) {
                for (SensitivityExport sensitivityExport : sensitivityExports) {
                    for (String resultName : sensitivityExport.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            if ((rules = this.simulation.getParameter().getRules()) != null) {
                for (Rule rule : rules) {
                    for (String resultName : rule.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            if ((plans = this.simulation.getParameter().getSimulationPlans()) != null) {
                for (SimulationPlan plan : plans) {
                    for (String resultName : plan.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            log.info((Object)("Enabled result: " + this.enabledResult));
        }
        boolean result = true;
        if (this.enabledResult != null) {
            result = this.enabledResult.contains(name);
        }
        return result;
    }

    @Override
    public void addActiveRule(TimeStep step, Rule rule) throws IsisFishException {
        try {
            TopiaContext tx = null;
            boolean mustClose = false;
            if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                tx = SimulationContext.get().getDbResult();
            }
            if (tx == null) {
                tx = this.simulation.getStorage().beginTransaction();
                mustClose = true;
            }
            ActiveRuleDAO ps = IsisFishDAOHelper.getActiveRuleDAO(tx);
            ActiveRule result = (ActiveRule)ps.create(new Object[0]);
            result.setActiveRuleStep(step);
            result.setName(RuleStorage.getName(rule));
            result.setParam(RuleStorage.getParamAsString(rule));
            ps.update((TopiaEntity)result);
            if (mustClose) {
                tx.commitTransaction();
                tx.closeContext();
            }
        }
        catch (TopiaException eee) {
            throw new IsisFishException("Can't add result", eee);
        }
    }

    @Override
    public List<String> getResultName() {
        ArrayList<String> result = new ArrayList<String>(this.nameStepResults.keySet());
        return result;
    }

    @Override
    public MatrixND getMatrix(TimeStep step, Population pop, String name) {
        String newName = name + " " + pop;
        return this.getMatrix(step, newName, null);
    }

    public MatrixND getMatrix(TimeStep step, Population pop, String name, TopiaContext tx) {
        String newName = name + " " + pop;
        return this.getMatrix(step, newName, tx);
    }

    @Override
    public MatrixND getMatrix(TimeStep step, String name) {
        return this.getMatrix(step, name, null);
    }

    @Override
    public MatrixND getMatrix(TimeStep step, String name, TopiaContext tx) {
        ResultMapped r = this.getResult(step, name);
        MatrixND mat = null;
        if (r != null) {
            tx = this.getTx(tx);
            mat = r.getMatrix(tx);
        }
        return mat;
    }

    @Override
    public MatrixND getMatrix(Population pop, String name) {
        String newName = name + " " + pop;
        return this.getMatrix(newName, null);
    }

    @Override
    public MatrixND getMatrix(Population pop, String name, TopiaContext tx) {
        String newName = name + " " + pop;
        return this.getMatrix(newName, tx);
    }

    @Override
    public MatrixND getMatrix(String name) {
        return this.getMatrix(name, null);
    }

    @Override
    public MatrixND getMatrix(String name, TopiaContext tx) {
        log.debug((Object)("Get result: " + name));
        MatrixSemanticsDecorator resultMat = null;
        Map<TimeStep, ResultMapped> results = this.getResult(name);
        if (!results.isEmpty()) {
            TimeStep lastStep = this.getLastStep();
            ArrayList<TimeStep> steps = new ArrayList<TimeStep>();
            TimeStep step = new TimeStep(0);
            steps.add(step);
            while (step.before(lastStep)) {
                step = step.next();
                steps.add(step);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Steps list : " + steps));
            }
            MatrixND mat = results.values().iterator().next().getMatrix();
            String[] dimNames = new String[1 + mat.getDimCount()];
            dimNames[0] = I18n._((String)"isisfish.common.date", (Object[])new Object[0]);
            for (int i = 1; i < dimNames.length; ++i) {
                dimNames[i] = mat.getDimensionName(i - 1);
            }
            List[] sem = new List[1 + mat.getDimCount()];
            sem[0] = steps;
            for (int i = 1; i < sem.length; ++i) {
                sem[i] = new HashList();
            }
            for (ResultMapped result : results.values()) {
                MatrixND mattmp = result.getMatrix();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Ajout de la semantics: " + Arrays.asList(mattmp.getSemantics())));
                }
                for (int s = 0; s < mattmp.getDimCount(); ++s) {
                    sem[s + 1].addAll(mattmp.getSemantic(s));
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("La semantique final est: " + Arrays.asList(sem)));
            }
            resultMat = matrixFactory.create(name, sem, dimNames);
            for (ResultMapped result : results.values()) {
                TimeStep d = result.getStep();
                mat = result.getMatrix();
                if (mat == null) continue;
                MatrixND submat = resultMat.getSubMatrix(0, (Object)d, 1);
                MatrixIterator mi = mat.iterator();
                while (mi.next()) {
                    submat.setValue(ArrayUtil.concat((Object[][])new Object[][]{{d}, mi.getSemanticsCoordinates()}), mi.getValue());
                }
            }
        }
        if (resultMat != null) {
            tx = this.getTx(tx);
            resultMat = new MatrixSemanticsDecorator(resultMat, (SemanticsDecorator)new EntitySemanticsDecorator(tx));
        }
        return resultMat;
    }

    @Override
    public TimeStep getLastStep() {
        int monthNumber = this.simulation.getParameter().getNumberOfYear() * Month.NUMBER_OF_MONTH;
        TimeStep result = new TimeStep(monthNumber - 1);
        return result;
    }

    @Override
    public void addResult(SimulationContext context, TimeStep step, String name, MatrixND mat) throws IsisFishException {
        this.doAddResult(step, name, mat);
    }

    @Override
    public MatrixND getMatrix(SimulationContext context, TimeStep step, String name) {
        MatrixND result;
        block2: {
            result = null;
            try {
                result = this.getMatrix(step, name, context.getDB());
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)String.format("Can't get result: %1$s", name), (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public MatrixND getMatrix(SimulationContext context, String name) {
        MatrixND result;
        block2: {
            result = null;
            try {
                result = this.getMatrix(name, context.getDB());
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)String.format("Can't get result: %1$s", name), (Throwable)eee);
            }
        }
        return result;
    }

    protected TopiaContext getTx(TopiaContext tx) {
        TopiaContext result = tx;
        if (tx == null && this.simulation == SimulationContext.get().getSimulationStorage()) {
            try {
                result = SimulationContext.get().getDB();
            }
            catch (TopiaException eee) {
                throw new IsisFishRuntimeException("Can't get database from SimulationContext", eee);
            }
        }
        return result;
    }

    @Override
    public void afterSimulation(SimulationContext context) {
    }

    @Override
    public void beforeSimulation(SimulationContext context) {
    }

    protected static class ResultMapped {
        protected RandomAccessFile raf;
        protected long offset;
        protected long size;
        protected TimeStep step;
        protected String name;
        protected MatrixND matrix;

        public ResultMapped(RandomAccessFile raf, long offset) throws IOException {
            this.raf = raf;
            this.offset = offset;
            ResultHeaderMatrix header = ResultHeaderMatrix.read(raf, offset);
            if (header != null) {
                this.step = new TimeStep(header.stepValue);
                this.name = header.name;
                String[] dimNames = header.dimNames;
                List[] sems = header.sems;
                long dataOffset = raf.getFilePointer();
                long size = raf.getFilePointer() - offset;
                int dataSize = header.dataSize;
                DoubleBigMappedVector data = new DoubleBigMappedVector(raf, dataOffset, dataSize);
                this.matrix = matrixFactory.create(this.name, sems, dimNames, (Vector)data);
                this.size = size += (long)(dataSize * 8);
            }
        }

        public ResultMapped(RandomAccessFile raf, long offset, TimeStep step, String name, MatrixND matrix) throws IOException {
            this.raf = raf;
            this.offset = offset;
            this.step = step;
            this.name = name;
            String[] dimNames = matrix.getDimensionNames();
            int[] dims = matrix.getDim();
            List[] sems = matrix.getSemantics();
            int dataSize = MatrixHelper.getVectorSize((int[])dims);
            EntitySemanticsDecorator deco = new EntitySemanticsDecorator();
            for (int i = 0; i < sems.length; ++i) {
                ArrayList undecorate;
                List l = sems[i];
                sems[i] = undecorate = new ArrayList(l.size());
                for (Object o : l) {
                    o = deco.undecorate(o);
                    undecorate.add(o);
                }
            }
            ResultHeaderMatrix header = new ResultHeaderMatrix();
            header.set(step.getStep(), name, dims.length, dimNames, dims, sems, dataSize);
            header.write(raf, offset);
            long dataOffset = raf.getFilePointer();
            DoubleBigMappedVector data = new DoubleBigMappedVector(raf, dataOffset, dataSize);
            this.matrix = MatrixFactory.getInstance().create(name, sems, dimNames, (Vector)data);
            this.matrix.paste(matrix);
            this.size = dataOffset - offset + (long)(dataSize * 8);
        }

        public long size() {
            return this.size;
        }

        public TimeStep getStep() {
            return this.step;
        }

        public String getName() {
            return this.name;
        }

        public MatrixND getMatrix() {
            return this.matrix;
        }

        public MatrixND getMatrix(TopiaContext tx) {
            MatrixSemanticsDecorator result = new MatrixSemanticsDecorator(this.matrix, (SemanticsDecorator)new EntitySemanticsDecorator(tx));
            return result;
        }

        protected static class ResultHeaderMatrix {
            static final long RESULT_MATRIX = BitUtil.toMark("resmat01");
            int stepValue;
            String name;
            int dimSize;
            String[] dimNames;
            int[] dims;
            List[] sems;
            int dataSize;

            protected ResultHeaderMatrix() {
            }

            public void set(int stepValue, String name, int dimSize, String[] dimNames, int[] dims, List[] sems, int dataSize) {
                this.stepValue = stepValue;
                this.name = name;
                this.dimSize = dimSize;
                this.dimNames = dimNames;
                this.dims = dims;
                this.sems = sems;
                this.dataSize = dataSize;
            }

            public static ResultHeaderMatrix read(RandomAccessFile raf, long offset) throws IOException {
                raf.seek(offset);
                long mark = raf.readLong();
                ResultHeaderMatrix result = null;
                if (mark != RESULT_MATRIX) {
                    raf.seek(offset);
                } else {
                    int i;
                    result = new ResultHeaderMatrix();
                    result.stepValue = raf.readInt();
                    result.name = raf.readUTF().intern();
                    result.dimSize = raf.readInt();
                    result.dimNames = new String[result.dimSize];
                    for (i = 0; i < result.dimSize; ++i) {
                        result.dimNames[i] = raf.readUTF().intern();
                    }
                    result.dims = new int[result.dimSize];
                    for (i = 0; i < result.dimSize; ++i) {
                        result.dims[i] = raf.readInt();
                    }
                    result.sems = new List[result.dimSize];
                    for (i = 0; i < result.dimSize; ++i) {
                        result.sems[i] = new ArrayList();
                        for (int j = 0; j < result.dims[i]; ++j) {
                            String s = raf.readUTF().intern();
                            result.sems[i].add(s);
                        }
                    }
                    result.dataSize = raf.readInt();
                }
                return result;
            }

            public void write(RandomAccessFile raf, long offset) throws IOException {
                int i;
                raf.seek(offset);
                long mark = RESULT_MATRIX;
                raf.writeLong(mark);
                raf.writeInt(this.stepValue);
                raf.writeUTF(this.name);
                raf.writeInt(this.dimSize);
                for (i = 0; i < this.dimSize; ++i) {
                    raf.writeUTF(this.dimNames[i]);
                }
                for (i = 0; i < this.dimSize; ++i) {
                    raf.writeInt(this.dims[i]);
                }
                for (i = 0; i < this.sems.length; ++i) {
                    for (Object s : this.sems[i]) {
                        raf.writeUTF(String.valueOf(s));
                    }
                }
                raf.writeInt(this.dataSize);
            }
        }
    }

    protected static class EntitySemanticsDecorator
    implements SemanticsDecorator {
        private static final String SEP = ":";
        protected TopiaContext tx;
        protected BidiMap cache = new DualHashBidiMap();

        public EntitySemanticsDecorator() {
        }

        public EntitySemanticsDecorator(TopiaContext tx) {
            this.tx = tx;
        }

        public Object decorate(Object internalValue) {
            Object result = this.cache.get(internalValue);
            if (result == null && internalValue != null) {
                result = internalValue;
                if (internalValue instanceof String) {
                    result = internalValue = ((String)internalValue).intern();
                    if (StringUtils.startsWith((CharSequence)((String)internalValue), (CharSequence)Month.class.getName())) {
                        String val = StringUtils.substringAfter((String)((String)internalValue), (String)SEP);
                        int monthNumber = Integer.parseInt(val);
                        result = new Month(monthNumber);
                    } else if (StringUtils.startsWith((CharSequence)((String)internalValue), (CharSequence)TimeStep.class.getName())) {
                        String val = StringUtils.substringAfter((String)((String)internalValue), (String)SEP);
                        int stepNumber = Integer.parseInt(val);
                        result = new TimeStep(stepNumber);
                    } else if (StringUtils.startsWith((CharSequence)((String)internalValue), (CharSequence)"fr.ifremer.isisfish.entities.")) {
                        if (this.tx == null) {
                            result = StringUtils.substringAfter((String)((String)internalValue), (String)SEP);
                        } else {
                            try {
                                String id = StringUtils.substringBefore((String)((String)internalValue), (String)SEP);
                                result = this.tx.findByTopiaId(id);
                            }
                            catch (TopiaException eee) {
                                log.info((Object)("Fallback use string representation because i can't decorate (String->Entity): " + internalValue), (Throwable)eee);
                            }
                        }
                    }
                }
                this.cache.put(internalValue, result);
            }
            return result;
        }

        public Object undecorate(Object decoratedValue) {
            Object result = this.cache.getKey(decoratedValue);
            if (result == null && decoratedValue != null) {
                result = decoratedValue instanceof Month ? Month.class.getName() + SEP + ((Month)decoratedValue).getMonthNumber() : (decoratedValue instanceof TimeStep ? TimeStep.class.getName() + SEP + ((TimeStep)decoratedValue).getStep() : (decoratedValue instanceof TopiaEntity ? ((TopiaEntity)decoratedValue).getTopiaId() + SEP + decoratedValue : String.valueOf(decoratedValue)));
                this.cache.put((Object)((String)result).intern(), decoratedValue);
            }
            return result;
        }
    }
}

