/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Cache;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.aspectwerkz.annotation.Around;
import org.codehaus.aspectwerkz.annotation.Aspect;
import org.codehaus.aspectwerkz.annotation.Expression;
import org.codehaus.aspectwerkz.definition.Pointcut;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MethodRtti;
import org.codehaus.aspectwerkz.joinpoint.MethodSignature;

@Aspect(value="perJVM")
public class CacheAspect {
    private static Log log = LogFactory.getLog(CacheAspect.class);
    @Expression(value="execution(* scripts..*(..))")
    Pointcut scriptsMethod;

    protected Cache getCache() {
        SimulationContext context = SimulationContext.get();
        Cache result = context.getCache();
        return result;
    }

    @Around(value="scriptsMethod")
    public Object call(JoinPoint jp) throws Throwable {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        Object[] args = ((MethodRtti)jp.getRtti()).getParameterValues();
        Object result = this.getCache().get(method, args, jp);
        if (log.isTraceEnabled()) {
            log.trace((Object)(((MethodSignature)jp.getSignature()).getMethod() + " args " + Arrays.toString(((MethodRtti)jp.getRtti()).getParameterValues()) + " result = " + result));
        }
        return result;
    }
}

