/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.aspectwerkz.annotation.AspectAnnotationParser;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.DeploymentScope;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.hook.impl.ClassPreProcessorHelper;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfo;
import org.codehaus.aspectwerkz.transform.inlining.AspectModelManager;
import sun.misc.Resource;
import sun.misc.URLClassPath;

public class AspectClassLoader
extends URLClassLoader {
    public AspectClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        ClassPreProcessorHelper.initializePreProcessor();
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        URLClassPath ucp = new URLClassPath(this.getURLs());
        Resource res = ucp.getResource(path, false);
        if (res != null) {
            try {
                byte[] b = res.getBytes();
                byte[] transformed = ClassPreProcessorHelper.defineClass0Pre((ClassLoader)this, (String)name, (byte[])b, (int)0, (int)b.length, null);
                return this.defineClass(name, transformed, 0, transformed.length);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Can't build aspect for class", e);
            }
        }
        throw new ClassNotFoundException(name);
    }

    public void deploy(Class<?> aspectClass) {
        String className = aspectClass.getName();
        try {
            aspectClass = Class.forName(className, false, this);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not load class [" + className + "] in class loader [" + this + "]");
        }
        ClassInfo aspectClassInfo = JavaClassInfo.getClassInfo(aspectClass);
        SystemDefinition systemDef = SystemDefinitionContainer.getVirtualDefinitionAt((ClassLoader)this);
        AspectDefinition newAspectDef = new AspectDefinition(className, aspectClassInfo, systemDef);
        this.getNewExpressionsForAspect(aspectClass, newAspectDef, systemDef, DeploymentScope.MATCH_ALL);
    }

    private Set getNewExpressionsForAspect(Class aspectClass, AspectDefinition newAspectDef, SystemDefinition systemDef, DeploymentScope deploymentScope) {
        ClassLoader aspectLoader = aspectClass.getClassLoader();
        String aspectName = aspectClass.getName();
        ClassInfo classInfo = AsmClassInfo.getClassInfo((String)aspectName, (ClassLoader)aspectLoader);
        AspectModelManager.defineAspect((ClassInfo)classInfo, (AspectDefinition)newAspectDef, (ClassLoader)aspectLoader);
        AspectAnnotationParser.parse((ClassInfo)classInfo, (AspectDefinition)newAspectDef, (ClassLoader)aspectLoader);
        AspectDefinition aspectDef = systemDef.getAspectDefinition(aspectName);
        if (aspectDef != null) {
            newAspectDef.setContainerClassName(aspectDef.getContainerClassName());
            newAspectDef.setDeploymentModel(aspectDef.getDeploymentModel());
        }
        systemDef.addAspectOverwriteIfExists(newAspectDef);
        HashSet<ExpressionInfo> newExpressions = new HashSet<ExpressionInfo>();
        for (AdviceDefinition adviceDef : newAspectDef.getAdviceDefinitions()) {
            ExpressionInfo oldExpression = adviceDef.getExpressionInfo();
            if (oldExpression == null) continue;
            ExpressionInfo newExpression = deploymentScope.newExpressionInfo(oldExpression);
            adviceDef.setExpressionInfo(newExpression);
            newExpressions.add(newExpression);
        }
        return newExpressions;
    }
}

