package fr.ifremer.isisfish.ui.sensitivity;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.ui.models.common.StringComboModel;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import static org.nuiton.i18n.I18n._;

public class SensitivitySecondPassUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DISPLAY_SECOND_PASS_BUTTON_ENABLED = "displaySecondPassButton.enabled";
    public static final String BINDING_RUN_SECOND_PASS_BUTTON_ENABLED = "runSecondPassButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Uz08TQRR+rbSlIApWfhgxViEaD26N3oQgPwwRUpVQTIi9OO1O6ZDp7jjzFpaL8U/wT9C7FxNvnowHzx68GP8FYzx4Nb7Zlm4LFQl7mNm8me9733v7vX37A1JGw5VtFoaODjwUDe6sLmxuPq5s8yre56aqhUJfQ/NJJCFZhkG3HTcIU+WihRda8MKS31C+x70O9EwRBgzuSW7qnCPCpW5E1ZhCqX08E6pA77O2RfViff3rZ/KV+/JNEiBUpC5NpeT/h4or6StCUrgI5yjTDitI5m2RDC28LdI7ZGNLkhnziDX4c3gBmSKkFdNEhnD1+CVHHBE+VAiZ6Q1WkfwWwt2adkRN8wan3QhTE6buBMIx3DMCxY7APacUv5d41ffcNeJ6sqJURJhGyNcEl27nNdEIJEPheyUu6QsijNpCQsfsUl3OKimt+It+aPHZNk2OCokTLAaIvkfRLmQz2o0bd4VRku0dxNrjke6rQ9Orpar2pVxjni1/vIs8PupGTSEPcUFzdqgTipKtcxPIQyVutCCW4rwiS1zssgSZzYnNFrshUYaUDiiMMFE+7M91Omo6c+KAMy1hdPpnLPf1w/f3y512HO15tWOayCZK+4prFDb12aYXAxSy8JCpmTJkTfQho1Gb7CGs1DomcZRvxMIdC3ceMFMnilTm28dPY8++nILkMgxIn7nLzN5fgSzWNXXBl26o7s1Hik7v9tM6bLUhpBq+yyXCmVmXIctXhOdSg+dC6sFkjx60hVSyn3/nSu/m9/uQIF0X/nk97kXqKaSFJ4XHo8FszVzPQRxUhgeuH89Wr2lL2H1ItablcrRO9So0wz07lFHGa2Fgt+uRbvt2I6IZPgZNnzUr/U5mm0XkGdLPpBIgnzsppw3fPEJV7lgMt+1y56QMCP3cFWgbdATPBPH8BQJtKpdNBgAA";
    private static final Log log = LogFactory.getLog(SensitivitySecondPassUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton displaySecondPassButton;
    protected JComboBox fieldSensitivitySimulationSelect;
    protected JButton runSecondPassButton;
    protected JTextArea textAreaSensitivitySecondpassResult;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SensitivitySecondPassUI $Table0 = this;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    // declaration sépérée de la variable d'instance (jaxx)
        SimulationServiceListener simulationListener;
    
        
        protected void $afterCompleteSetup() {
            // permet de rafaichir la liste les simulations
            // des qu'une simulation se termine
            simulationListener = new SimulationServiceListener() {
                @Override
                public void simulationStart(SimulationService simService, SimulationJob job) {
                }
            
                @Override
                public void simulationStop(SimulationService simService, SimulationJob job) {
                    if (log.isDebugEnabled()) {
                        log.debug("Refresh second pass UI simulations list");
                    }
                    StringComboModel model = (StringComboModel)fieldSensitivitySimulationSelect.getModel();
                    String simulationName = job.getId();
                    if (simulationName.startsWith("as_")) {
                        String masterSensitivityName = simulationName.substring(0, simulationName.lastIndexOf("_"));
                        if (!model.containsString(masterSensitivityName)) {
                            model.addString(masterSensitivityName);
                        }
                    }
                }
            
                @Override
                public void clearJobDone(SimulationService simService) {
                }
            };
            SimulationService.getService().addSimulationServiceListener(simulationListener);
        }
    
        /**
         * Model de contenu de la liste des nom de simulations
         */
        public StringComboModel getSensitivitySimulationModel() {
            List<String> asNames = new ArrayList<String>();
            for (String simulationName : SimulationStorage.getSimulationNames()) {
                if (simulationName.startsWith("as_")) {
                    String masterSensitivityName = simulationName.substring(0, simulationName.lastIndexOf("_"));
                    if (!asNames.contains(masterSensitivityName)) {
                        asNames.add(masterSensitivityName);
                    }
                }
            }
            
            StringComboModel model = new StringComboModel(asNames);
            return model;
        }
    
        protected SimulAction getSimulAction() {
            return getContextValue(SimulAction.class);
        }
    
        protected void launchSecondPass(ActionEvent event) {
            if (fieldSensitivitySimulationSelect.getSelectedIndex() != -1) {
                getSimulAction().runSensitivitySecondPass((String)fieldSensitivitySimulationSelect.getSelectedItem());
                displaySensitivitySecondPass(event);
            }
        }
    
        protected void displaySensitivitySecondPass(ActionEvent event) {
            if (fieldSensitivitySimulationSelect.getSelectedIndex() != -1) {
            
                try {
                    String selectedSimulationName = (String)fieldSensitivitySimulationSelect.getSelectedItem();
                    java.util.List<File> files = getSimulAction().getSensitivitySecondPassResults(selectedSimulationName);
                    
                    String content = "";
                    for(File file : files) {
                        content += "Fichier " + file.getName() + "\n";
                        content += "------------------------------\n";
                        content += FileUtil.readAsString(file) + "\n";
                        content += "\n";
                    }
                    textAreaSensitivitySecondpassResult.setText(content);
                }
                catch(IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't run second pass", e);
                    }
                }
            }
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SensitivitySecondPassUI() {
        $initialize();
    }

    public SensitivitySecondPassUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__displaySecondPassButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        displaySensitivitySecondPass(event);
    }

    public void doActionPerformed__on__runSecondPassButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        launchSecondPass(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getDisplaySecondPassButton() {
        return displaySecondPassButton;
    }

    public JComboBox getFieldSensitivitySimulationSelect() {
        return fieldSensitivitySimulationSelect;
    }

    public JButton getRunSecondPassButton() {
        return runSecondPassButton;
    }

    public JTextArea getTextAreaSensitivitySecondpassResult() {
        return textAreaSensitivitySecondpassResult;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createDisplaySecondPassButton() {
        $objectMap.put("displaySecondPassButton", displaySecondPassButton = new JButton());
        
        displaySecondPassButton.setName("displaySecondPassButton");
        displaySecondPassButton.setText(_("isisfish.sensitivity.displaysecondpass"));
        displaySecondPassButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__displaySecondPassButton"));
    }

    protected void createFieldSensitivitySimulationSelect() {
        $objectMap.put("fieldSensitivitySimulationSelect", fieldSensitivitySimulationSelect = new JComboBox());
        
        fieldSensitivitySimulationSelect.setName("fieldSensitivitySimulationSelect");
    }

    protected void createRunSecondPassButton() {
        $objectMap.put("runSecondPassButton", runSecondPassButton = new JButton());
        
        runSecondPassButton.setName("runSecondPassButton");
        runSecondPassButton.setText(_("isisfish.sensitivity.secondpass"));
        runSecondPassButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__runSecondPassButton"));
    }

    protected void createTextAreaSensitivitySecondpassResult() {
        $objectMap.put("textAreaSensitivitySecondpassResult", textAreaSensitivitySecondpassResult = new JTextArea());
        
        textAreaSensitivitySecondpassResult.setName("textAreaSensitivitySecondpassResult");
        textAreaSensitivitySecondpassResult.setColumns(15);
        textAreaSensitivitySecondpassResult.setLineWrap(true);
        textAreaSensitivitySecondpassResult.setWrapStyleWord(true);
        textAreaSensitivitySecondpassResult.setEditable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(fieldSensitivitySimulationSelect, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(runSecondPassButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(displaySecondPassButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(textAreaSensitivitySecondpassResult);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        fieldSensitivitySimulationSelect.setModel(getSensitivitySimulationModel());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createFieldSensitivitySimulationSelect();
        createRunSecondPassButton();
        createDisplaySecondPassButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTextAreaSensitivitySecondpassResult();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RUN_SECOND_PASS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (fieldSensitivitySimulationSelect != null) {
                    $bindingSources.put("fieldSensitivitySimulationSelect", fieldSensitivitySimulationSelect);
                    fieldSensitivitySimulationSelect.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (fieldSensitivitySimulationSelect != null) {
                    runSecondPassButton.setEnabled(fieldSensitivitySimulationSelect.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (fieldSensitivitySimulationSelect != null) {
                    JComboBox $target = (JComboBox) $bindingSources.remove("fieldSensitivitySimulationSelect");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(ItemEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_SECOND_PASS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (fieldSensitivitySimulationSelect != null) {
                    $bindingSources.put("fieldSensitivitySimulationSelect", fieldSensitivitySimulationSelect);
                    fieldSensitivitySimulationSelect.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u1"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (fieldSensitivitySimulationSelect != null) {
                    displaySecondPassButton.setEnabled(fieldSensitivitySimulationSelect.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (fieldSensitivitySimulationSelect != null) {
                    JComboBox $target = (JComboBox) $bindingSources.remove("fieldSensitivitySimulationSelect");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u1"));
                    }
                }
            }
        
            public void $pr$u1(ItemEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}