package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n._;

public class PopulationSeasonSpacializedUI extends InputContentUI<fr.ifremer.isisfish.entities.Population> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AGE_GROUP_TYPE = "ageGroupType";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_POPULATION_SEASON_INFO = "populationSeasonInfo";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUTTON_POPULATION_SEASON_GROUP_CHANGE_LENGTH_BUTTON_SHOW_ENABLED = "buttonPopulationSeasonGroupChangeLengthButtonShow.enabled";
    public static final String BINDING_BUTTON_POPULATION_SEASON_GROUP_CHANGE_LENGTH_BUTTON_SHOW_VISIBLE = "buttonPopulationSeasonGroupChangeLengthButtonShow.visible";
    public static final String BINDING_MATRIX_PANEL_POPULATION_SEASON_LENGTH_CHANGE_ENABLED = "matrixPanelPopulationSeasonLengthChange.enabled";
    public static final String BINDING_MATRIX_PANEL_POPULATION_SEASON_LENGTH_CHANGE_MATRIX = "matrixPanelPopulationSeasonLengthChange.matrix";
    public static final String BINDING_MATRIX_PANEL_POPULATION_SEASON_LENGTH_CHANGE_VISIBLE = "matrixPanelPopulationSeasonLengthChange.visible";
    public static final String BINDING_RADIO_POPULATION_SEASON_GROUP_CHANGE_LENGTH_NO_SPACIALIZED_ENABLED = "radioPopulationSeasonGroupChangeLengthNoSpacialized.enabled";
    public static final String BINDING_RADIO_POPULATION_SEASON_GROUP_CHANGE_LENGTH_NO_SPACIALIZED_SELECTED = "radioPopulationSeasonGroupChangeLengthNoSpacialized.selected";
    public static final String BINDING_RADIO_POPULATION_SEASON_GROUP_CHANGE_LENGTH_NO_SPACIALIZED_VISIBLE = "radioPopulationSeasonGroupChangeLengthNoSpacialized.visible";
    public static final String BINDING_RADIO_POPULATION_SEASON_GROUP_CHANGE_LENGTH_SPACIALIZED_ENABLED = "radioPopulationSeasonGroupChangeLengthSpacialized.enabled";
    public static final String BINDING_RADIO_POPULATION_SEASON_GROUP_CHANGE_LENGTH_SPACIALIZED_SELECTED = "radioPopulationSeasonGroupChangeLengthSpacialized.selected";
    public static final String BINDING_RADIO_POPULATION_SEASON_GROUP_CHANGE_LENGTH_SPACIALIZED_VISIBLE = "radioPopulationSeasonGroupChangeLengthSpacialized.visible";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL0_VISIBLE = "$JLabel0.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28TRxSeuEmckJCkBKKgBjUFS6kQGjdCqqomIiGhoY4cfplUCF86zk7sQeuZ6cws2XBA/An8CXDvBYkbJ8ShZw5cEP8CQhx6rfpm1vF6w3azjX1Y2/Pe+973vZn59s+PaEgr9N0DEoZYBdywNsWbV+/du9l4QHfMNap3FJNGKBR9BgqoUEdjXnddG3ShXrXl5U55eV20peCU91QvVdEJbfZ9qluUGoPOJSt2tC7XuuGlUAbqALVLKg312edPhafek+cFhEIJ7CZByvxRVbGSwSoqMM+gU9DpISn7hDeBhmK8CXxP2rV1n2h9g7TpH+gxKlbRsCQKwAw6n1+yw3D1oTRoqlThMjDrghtI3678YNDPuwqzXUXbFL4107tMt3DAMLOJ+JaQgU8ME7xGiYanJDuM+OwR9bYrUjrkYYMGG5RwgxbSsKARM4zqHqy48LQ81KDCd4VBizmB4poYcpw06XUlAnl3X1KDvraTxHa6eE0IH3j20hbePuyATQmx3oPZ481bhFM/zimW7pKGT2FSs4m9jbJdzGae6SlwCFAw4VqTPRijXbHx2W7aZUU8Jg5LccTXW8CWVilvmtYN0TNyx6GH6h0LsRYYI3gSfDEfeA+0LZxPgoyUNquk4ZQkJ+RWk7mjpc2IByRPJ5JT6TXc4pH8otpaS+zZwu+TIJ05L9q/55KhhTaBixS6+OEmEXLUxaBLQjUxDxi0wVDUwlElbsIN2IpBfvEgQyWb/Pi/Z+xicHtTzpE1vUitS4Ljp9A3iTxwKRy7VGwjA3U0pAJYhsNR/9LY7kAosrTZQ5ZmAV30n5npd68+vNw48LEZ6H0mNbXHhsFfpBKSKnsjDZqMTCwwzC9vEblUR6Oa+uDhzqPnUojVOmEgB/2iW2rL8a9EtwBiqPj+9ZuZ399+hQob6IQviLdBbH4FjZqWgikI3wvlyqpjNL43As8py82gsUY8SDi6y4z7jNN5YmA7IUSvhDCNuZRpdCk1Rv/6e7r2YvVgIgPA8Ox/psdTGbqPhqNuzts7tp3q5WNS08ATsT2nGfaA/f5WdszoJ/dcTpNcpNwaERjExLJHDJlvMO7BuQKptmbVabC/1nJDjkT7FznD9ePjDBoaGhtdOT5G8SG8BDpGe2wqdvlKBpHzuRA2MjjkQ6j2jXC7bxW/9c0haw6lvlXkQ8hSkQ8hS8VC3yryIWSpyIeQpeJi3yryIWSpyIeQpQLnMInh6NXdF8pRSizCv+VwgDi1DAAA";
    private static final Log log = LogFactory.getLog(PopulationSeasonSpacializedUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean ageGroupType;
    protected Population bean;
    protected JButton buttonPopulationSeasonGroupChangeLengthButtonShow;
    protected MatrixPanelEditor matrixPanelPopulationSeasonLengthChange;
    protected PopulationSeasonInfo populationSeasonInfo;
    protected JRadioButton radioPopulationSeasonGroupChangeLengthNoSpacialized;
    protected JRadioButton radioPopulationSeasonGroupChangeLengthSpacialized;
    protected JAXXButtonGroup radioPopulationSeasonGroupChangeLengthSpacializedGroup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationSeasonSpacializedUI $InputContentUI0 = this;
    private Table $Table0;
    private Panel $Panel0;
    private JLabel $JLabel0;
    private JButton $JButton0;
    private Panel $Panel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void populationSeasonLengthMatrixChanged(MatrixPanelEvent event) {
        if (getPopulationSeasonInfo() != null && matrixPanelPopulationSeasonLengthChange.getMatrix() != null) {
            // must be a copy for fire event
            MatrixND lengthChangeMatrix = matrixPanelPopulationSeasonLengthChange.getMatrix().copy();
            getPopulationSeasonInfo().setLengthChangeMatrix(lengthChangeMatrix);
        }
    }
    
    /*public void refresh() {
        // TODO add only once
        //matrixPanelPopulationSeasonLengthChange.addMatrixListener(matrixPanelListener);
    }*/
    
    /**
     * Called on spacialized radio button change.
     */
    protected void spacializedActionPerformed() {
        PopulationSeasonInfo popInfo = getPopulationSeasonInfo();
        boolean spacializedSelection = radioPopulationSeasonGroupChangeLengthNoSpacialized.isSelected();
        popInfo.setSimpleLengthChangeMatrix(spacializedSelection);
        try {
            MatrixND lengthChangeMatrix = popInfo.getLengthChangeMatrix();
            if (lengthChangeMatrix != null) {
                if (popInfo.getSimpleLengthChangeMatrix()) {
                    lengthChangeMatrix = popInfo.unspacializeLengthChangeMatrix(lengthChangeMatrix);
                } else {
                    lengthChangeMatrix = popInfo.spacializeLengthChangeMatrix(lengthChangeMatrix);
                }
                popInfo.setLengthChangeMatrix(lengthChangeMatrix);
                matrixPanelPopulationSeasonLengthChange.setMatrix(lengthChangeMatrix);
            }
        } catch(Exception eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't (un)spacialize Matrix Change Of Group", eee);
            }
            ErrorHelper.showErrorDialog(_("isisfish.error.input.spacializematrix"), eee);
        }
    }
    
    protected void computeMatrixChangeOfGroup() {
        PopulationSeasonInfo popInfo = getPopulationSeasonInfo();
        MatrixND lengthChangeMatrix = popInfo.computeLengthChangeMatrix();
        if (!popInfo.getSimpleLengthChangeMatrix()){
            lengthChangeMatrix = popInfo.spacializeLengthChangeMatrix(lengthChangeMatrix);
        }
        popInfo.setLengthChangeMatrix(lengthChangeMatrix);
    }
    
    protected void showSpacializedMatrixChangeOfGroup() {
        PopulationSeasonInfo popInfo = getPopulationSeasonInfo();
        MatrixND lengthChangeMatrix = popInfo.getLengthChangeMatrix();
        if (popInfo.getSimpleLengthChangeMatrix()) {
            lengthChangeMatrix = popInfo.spacializeLengthChangeMatrix(lengthChangeMatrix);
        }
        MatrixPanelEditor panel = new MatrixPanelEditor(false, 800, 300);
        panel.setMatrix(lengthChangeMatrix);
        JOptionPane.showMessageDialog(this, panel, _("isisfish.populationSeasons.spacialized.visualisation"), JOptionPane.INFORMATION_MESSAGE);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationSeasonSpacializedUI() {
        $initialize();
    }

    public PopulationSeasonSpacializedUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationSeasonSpacializedUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationSeasonSpacializedUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationSeasonSpacializedUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationSeasonSpacializedUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationSeasonSpacializedUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationSeasonSpacializedUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        computeMatrixChangeOfGroup();
    }

    public void doActionPerformed__on__buttonPopulationSeasonGroupChangeLengthButtonShow(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showSpacializedMatrixChangeOfGroup();
    }

    public void doActionPerformed__on__radioPopulationSeasonGroupChangeLengthNoSpacialized(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        spacializedActionPerformed();
    }

    public void doActionPerformed__on__radioPopulationSeasonGroupChangeLengthSpacialized(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        spacializedActionPerformed();
    }

    public void doMatrixChanged__on__matrixPanelPopulationSeasonLengthChange(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        populationSeasonLengthMatrixChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAgeGroupType() {
        return ageGroupType;
    }

    public Population getBean() {
        return bean;
    }

    public JButton getButtonPopulationSeasonGroupChangeLengthButtonShow() {
        return buttonPopulationSeasonGroupChangeLengthButtonShow;
    }

    public MatrixPanelEditor getMatrixPanelPopulationSeasonLengthChange() {
        return matrixPanelPopulationSeasonLengthChange;
    }

    public PopulationSeasonInfo getPopulationSeasonInfo() {
        return populationSeasonInfo;
    }

    public JRadioButton getRadioPopulationSeasonGroupChangeLengthNoSpacialized() {
        return radioPopulationSeasonGroupChangeLengthNoSpacialized;
    }

    public JRadioButton getRadioPopulationSeasonGroupChangeLengthSpacialized() {
        return radioPopulationSeasonGroupChangeLengthSpacialized;
    }

    public JAXXButtonGroup getRadioPopulationSeasonGroupChangeLengthSpacializedGroup() {
        return radioPopulationSeasonGroupChangeLengthSpacializedGroup;
    }

    public Boolean isAgeGroupType() {
        return ageGroupType !=null && ageGroupType;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAgeGroupType(Boolean ageGroupType) {
        Boolean oldValue = this.ageGroupType;
        this.ageGroupType = ageGroupType;
        firePropertyChange(PROPERTY_AGE_GROUP_TYPE, oldValue, ageGroupType);
    }

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPopulationSeasonInfo(PopulationSeasonInfo populationSeasonInfo) {
        PopulationSeasonInfo oldValue = this.populationSeasonInfo;
        this.populationSeasonInfo = populationSeasonInfo;
        firePropertyChange(PROPERTY_POPULATION_SEASON_INFO, oldValue, populationSeasonInfo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected Panel get$Panel0() {
        return $Panel0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected Panel get$Panel1() {
        return $Panel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToRadioPopulationSeasonGroupChangeLengthNoSpacialized() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = radioPopulationSeasonGroupChangeLengthSpacializedGroup; radioPopulationSeasonGroupChangeLengthNoSpacialized.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(radioPopulationSeasonGroupChangeLengthNoSpacialized); }
    }

    protected void addChildrenToRadioPopulationSeasonGroupChangeLengthSpacialized() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = radioPopulationSeasonGroupChangeLengthSpacializedGroup; radioPopulationSeasonGroupChangeLengthSpacialized.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(radioPopulationSeasonGroupChangeLengthSpacialized); }
    }

    protected void createAgeGroupType() {
        $objectMap.put("ageGroupType", ageGroupType = false);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createButtonPopulationSeasonGroupChangeLengthButtonShow() {
        $objectMap.put("buttonPopulationSeasonGroupChangeLengthButtonShow", buttonPopulationSeasonGroupChangeLengthButtonShow = new JButton());
        
        buttonPopulationSeasonGroupChangeLengthButtonShow.setName("buttonPopulationSeasonGroupChangeLengthButtonShow");
        buttonPopulationSeasonGroupChangeLengthButtonShow.setText(_("isisfish.populationSeasons.showSpacialized"));
        buttonPopulationSeasonGroupChangeLengthButtonShow.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonPopulationSeasonGroupChangeLengthButtonShow"));
    }

    protected void createMatrixPanelPopulationSeasonLengthChange() {
        $objectMap.put("matrixPanelPopulationSeasonLengthChange", matrixPanelPopulationSeasonLengthChange = new MatrixPanelEditor());
        
        matrixPanelPopulationSeasonLengthChange.setName("matrixPanelPopulationSeasonLengthChange");
        matrixPanelPopulationSeasonLengthChange.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__matrixPanelPopulationSeasonLengthChange"));
        matrixPanelPopulationSeasonLengthChange.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        matrixPanelPopulationSeasonLengthChange.putClientProperty("sensitivityMethod", "LengthChangeMatrix");
    }

    protected void createPopulationSeasonInfo() {
        $objectMap.put("populationSeasonInfo", populationSeasonInfo = null);
    }

    protected void createRadioPopulationSeasonGroupChangeLengthNoSpacialized() {
        $objectMap.put("radioPopulationSeasonGroupChangeLengthNoSpacialized", radioPopulationSeasonGroupChangeLengthNoSpacialized = new JRadioButton());
        
        radioPopulationSeasonGroupChangeLengthNoSpacialized.setName("radioPopulationSeasonGroupChangeLengthNoSpacialized");
        radioPopulationSeasonGroupChangeLengthNoSpacialized.setText(_("isisfish.populationSeasons.noSpacialized"));
        radioPopulationSeasonGroupChangeLengthNoSpacialized.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__radioPopulationSeasonGroupChangeLengthNoSpacialized"));
    }

    protected void createRadioPopulationSeasonGroupChangeLengthSpacialized() {
        $objectMap.put("radioPopulationSeasonGroupChangeLengthSpacialized", radioPopulationSeasonGroupChangeLengthSpacialized = new JRadioButton());
        
        radioPopulationSeasonGroupChangeLengthSpacialized.setName("radioPopulationSeasonGroupChangeLengthSpacialized");
        radioPopulationSeasonGroupChangeLengthSpacialized.setText(_("isisfish.populationSeasons.spacialized"));
        radioPopulationSeasonGroupChangeLengthSpacialized.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__radioPopulationSeasonGroupChangeLengthSpacialized"));
    }

    protected void createRadioPopulationSeasonGroupChangeLengthSpacializedGroup() {
        $objectMap.put("radioPopulationSeasonGroupChangeLengthSpacializedGroup", radioPopulationSeasonGroupChangeLengthSpacializedGroup = new JAXXButtonGroup());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Panel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(radioPopulationSeasonGroupChangeLengthNoSpacialized), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(radioPopulationSeasonGroupChangeLengthSpacialized), new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer($JButton0), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(buttonPopulationSeasonGroupChangeLengthButtonShow), new GridBagConstraints(2, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Panel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(matrixPanelPopulationSeasonLengthChange), new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToRadioPopulationSeasonGroupChangeLengthNoSpacialized();
        addChildrenToRadioPopulationSeasonGroupChangeLengthSpacialized();
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopulationSeasonInfo();
        createAgeGroupType();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Panel0
        $objectMap.put("$Panel0", $Panel0 = new Panel());
        
        $Panel0.setName("$Panel0");
        createRadioPopulationSeasonGroupChangeLengthNoSpacialized();
        createRadioPopulationSeasonGroupChangeLengthSpacialized();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.populationSeasons.changeGroup"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("isisfish.populationSeasons.computeCoefficient"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createButtonPopulationSeasonGroupChangeLengthButtonShow();
        // inline creation of $Panel1
        $objectMap.put("$Panel1", $Panel1 = new Panel());
        
        $Panel1.setName("$Panel1");
        createMatrixPanelPopulationSeasonLengthChange();
        createRadioPopulationSeasonGroupChangeLengthSpacializedGroup();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RADIO_POPULATION_SEASON_GROUP_CHANGE_LENGTH_NO_SPACIALIZED_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                radioPopulationSeasonGroupChangeLengthNoSpacialized.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RADIO_POPULATION_SEASON_GROUP_CHANGE_LENGTH_NO_SPACIALIZED_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("simpleLengthChangeMatrix", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null) {
                    radioPopulationSeasonGroupChangeLengthNoSpacialized.setSelected(getPopulationSeasonInfo().getSimpleLengthChangeMatrix());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("simpleLengthChangeMatrix", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RADIO_POPULATION_SEASON_GROUP_CHANGE_LENGTH_NO_SPACIALIZED_VISIBLE, true ,"ageGroupType") {
        
            @Override
            public void processDataBinding() {
                radioPopulationSeasonGroupChangeLengthNoSpacialized.setVisible(isAgeGroupType());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RADIO_POPULATION_SEASON_GROUP_CHANGE_LENGTH_SPACIALIZED_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                radioPopulationSeasonGroupChangeLengthSpacialized.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RADIO_POPULATION_SEASON_GROUP_CHANGE_LENGTH_SPACIALIZED_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("simpleLengthChangeMatrix", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null) {
                    radioPopulationSeasonGroupChangeLengthSpacialized.setSelected(!getPopulationSeasonInfo().getSimpleLengthChangeMatrix());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("simpleLengthChangeMatrix", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RADIO_POPULATION_SEASON_GROUP_CHANGE_LENGTH_SPACIALIZED_VISIBLE, true ,"ageGroupType") {
        
            @Override
            public void processDataBinding() {
                radioPopulationSeasonGroupChangeLengthSpacialized.setVisible(isAgeGroupType());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_VISIBLE, true ,"ageGroupType") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setVisible(isAgeGroupType());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"ageGroupType") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(isAgeGroupType());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUTTON_POPULATION_SEASON_GROUP_CHANGE_LENGTH_BUTTON_SHOW_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (radioPopulationSeasonGroupChangeLengthNoSpacialized != null) {
                    $bindingSources.put("radioPopulationSeasonGroupChangeLengthNoSpacialized.getModel()", radioPopulationSeasonGroupChangeLengthNoSpacialized.getModel());
                    radioPopulationSeasonGroupChangeLengthNoSpacialized.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    radioPopulationSeasonGroupChangeLengthNoSpacialized.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.input.PopulationSeasonSpacializedUI.this, BINDING_BUTTON_POPULATION_SEASON_GROUP_CHANGE_LENGTH_BUTTON_SHOW_ENABLED));
                }
                addPropertyChangeListener("populationSeasonInfo", this);
            }
        
            @Override
            public void processDataBinding() {
                if (radioPopulationSeasonGroupChangeLengthNoSpacialized != null) {
                    buttonPopulationSeasonGroupChangeLengthButtonShow.setEnabled(radioPopulationSeasonGroupChangeLengthNoSpacialized.isSelected() && getPopulationSeasonInfo() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (radioPopulationSeasonGroupChangeLengthNoSpacialized != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("radioPopulationSeasonGroupChangeLengthNoSpacialized.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    radioPopulationSeasonGroupChangeLengthNoSpacialized.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.input.PopulationSeasonSpacializedUI.this, BINDING_BUTTON_POPULATION_SEASON_GROUP_CHANGE_LENGTH_BUTTON_SHOW_ENABLED));
                }
                removePropertyChangeListener("populationSeasonInfo", this);
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_POPULATION_SEASON_GROUP_CHANGE_LENGTH_BUTTON_SHOW_VISIBLE, true ,"ageGroupType") {
        
            @Override
            public void processDataBinding() {
                buttonPopulationSeasonGroupChangeLengthButtonShow.setVisible(isAgeGroupType());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MATRIX_PANEL_POPULATION_SEASON_LENGTH_CHANGE_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                matrixPanelPopulationSeasonLengthChange.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MATRIX_PANEL_POPULATION_SEASON_LENGTH_CHANGE_MATRIX, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("lengthChangeMatrix", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null && getPopulationSeasonInfo().getLengthChangeMatrix() != null) {
                    matrixPanelPopulationSeasonLengthChange.setMatrix(getPopulationSeasonInfo() == null ? null : getPopulationSeasonInfo().getLengthChangeMatrix().copy());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("lengthChangeMatrix", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MATRIX_PANEL_POPULATION_SEASON_LENGTH_CHANGE_VISIBLE, true ,"ageGroupType") {
        
            @Override
            public void processDataBinding() {
                matrixPanelPopulationSeasonLengthChange.setVisible(isAgeGroupType());
            }
        });
    }

}