package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.JAXXComboBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import static org.nuiton.i18n.I18n._;

public class PopulationGroupUI extends InputContentUI<Population> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_POPULATION_GROUP = "populationGroup";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_FIELD_POPULATION_GROUP_AGE_TEXT = "fieldPopulationGroupAge.text";
    public static final String BINDING_FIELD_POPULATION_GROUP_COMMENT_ENABLED = "fieldPopulationGroupComment.enabled";
    public static final String BINDING_FIELD_POPULATION_GROUP_COMMENT_TEXT = "fieldPopulationGroupComment.text";
    public static final String BINDING_FIELD_POPULATION_GROUP_MATURITY_OGIVE_TEXT = "fieldPopulationGroupMaturityOgive.text";
    public static final String BINDING_FIELD_POPULATION_GROUP_MAX_LENGTH_TEXT = "fieldPopulationGroupMaxLength.text";
    public static final String BINDING_FIELD_POPULATION_GROUP_MEAN_WEIGHT_TEXT = "fieldPopulationGroupMeanWeight.text";
    public static final String BINDING_FIELD_POPULATION_GROUP_MIN_LENGTH_TEXT = "fieldPopulationGroupMinLength.text";
    public static final String BINDING_FIELD_POPULATION_GROUP_PRICE_TEXT = "fieldPopulationGroupPrice.text";
    public static final String BINDING_FIELD_POPULATION_GROUP_REPRODUCTION_RATE_TEXT = "fieldPopulationGroupReproductionRate.text";
    public static final String BINDING_POPULATION_GROUP_POPULATION_GROUP_COMBO_BOX_ENABLED = "populationGroupPopulationGroupComboBox.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_VALIDATOR_GROUP_BEAN = "validatorGroup.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";
    private static final String BINDING_$JLABEL5_ENABLED = "$JLabel5.enabled";
    private static final String BINDING_$JLABEL6_ENABLED = "$JLabel6.enabled";
    private static final String BINDING_$JLABEL7_ENABLED = "$JLabel7.enabled";
    private static final String BINDING_$JLABEL8_ENABLED = "$JLabel8.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWz28bRRTHJyZOmob+gNA0pQ1JikVBROuWUgpKaZu6TZvISUOcQlVLiLF3Yk+13llmZ9PNBfEn8CfAnQsSN06IA2cOXFCPXBHiwBX1zfjHet3JdMT4sGvPvPd5733nx/P3f6FizNHSY5ymHk9CQTvE21h9+PB+4zFpitskbnIaCcZR9zNWQIU6mvYH47FAb9ar0r3ccy9XWCdiIQmHvFeq6GgsDgIStwkRAs3nPZpxXK4NplfSKOF96iApHfXbf/4ufON//V0BoTSC7BaglMUXeWWVjFdRgfoCvQqR9nE5wGEL0uA0bEG+x+RYJcBxvIU75Ev0FZqsookIc4AJdN6+ZMVQ/mkk0MnSehglosJCAeYP1i8K5O1xj+5x0iHwjmm8R+O2l1CPSkNvm0VJgAVl4V3OkujBehQp2oRA4w2CQ4Eu6PwBTgUl8ZB/5ngiykMFWrZkKPMMNLWPA+pjKFegd3PCDya8+AkI6tXk89P+YEY4PjBUaDn6WjY73WzDopBN5pNAoLeNQlUy02GJmH8AKywXM+2lsrGNw2GbydIubgQEVmIuV0LXWs1Jy9cHDkdKG1XcIMHFUbAalUbzA9u3RqQekRI2ToPdYqlAC5rY8iD2LfLYfgqX5O/z+bnSHiWBPxJoC4uE4+A2waK9gwWBJWe85YUJFSz0OjAqH5ymXgsU3VRflU53fLDg+ujvaaK/oYu+CRv1M0JbbTg6sznJdkkq1qSHPsJlTYQlbQRZHxUH91t0Xy1XWQ9831awHRJx5idNOSAFMzCvaJhndMxtTpsm0Aca0GkdaLVlwlzVYOa1otGwSsKWaGtgegecHurQj/6hJvqx0katyVkQyC0Fx+Z0bg9kU3mvs7oU4Dx01BV86rl9tMoJlq73Ro+2OiULefh4jPfhFMzkKLcSAcdBWmwNDCeaOGx2j/VOb4ajs7nTCv3Ly/pX1mDG6qjIExiGq6X+fMvbgalus5sbaXYSqGb/m535/aenP671O9wyxD6lNR1q0NB5YO9GhMvLG277bntLBA3KmzhaqaOpmATQ3VX3PqdJrNabhuQg3ivS3ZPu3j0ctwFRnPzj519mv/jtJVRYQ0cDhv01LO3X0ZRoc1CBBX4a3bipMnr5yRF4npS5wYJ0L3Rousevwa2PFxs09EH66ymocE6jwiCVxtSv/87UfrjZV2IMMjtzqHmmRvERmqBhQEOiun2vkWu7+3QUk8RnWcPWtfAx+Z7r98BH6vm5rtSi6mxyGqeJfDVU1vKbbw2ZJKHcwCbMkgVmXMDxgG51ravEIhZwvzcSQa7/X6Yc7hiyKjkTLlgRVGeKXQgdA+Ed5yqWnauwI5iq8OxzOKQKO4JJh0vOOtgRTDpcdtbBjmDS4YqzDnYEkw5XnXWwI5h0+MhZBzuCSYcVZx3sCCYdPnbWwY5g0uGGsw52BJMOq8462BFMOlQsOum0YCzYpZH8v+mEepGkdgRTOXesCH86E0xV2BFMG+Ou88awI5hyqDrrYEcw5fCJsw52BFMOu845SMIzPEakr3QUAAA=";
    private static final Log log = LogFactory.getLog(PopulationGroupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected JTextField fieldPopulationGroupAge;
    protected JTextArea fieldPopulationGroupComment;
    protected JTextField fieldPopulationGroupMaturityOgive;
    protected JTextField fieldPopulationGroupMaxLength;
    protected JTextField fieldPopulationGroupMeanWeight;
    protected JTextField fieldPopulationGroupMinLength;
    protected MatrixPanelEditor fieldPopulationGroupNaturalDeathRate;
    protected JTextField fieldPopulationGroupPrice;
    protected JTextField fieldPopulationGroupReproductionRate;
    protected PopulationGroup populationGroup;
    protected JAXXComboBox populationGroupPopulationGroupComboBox;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Population> validator;
    @Validator( validatorId = "validatorGroup")
    protected SwingValidator<PopulationGroup> validatorGroup;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationGroupUI $InputContentUI0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JLabel $JLabel8;
    private JScrollPane $JScrollPane0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    setPopulationGroup(null);
                }
                if (evt.getNewValue() != null) {
                    if (getBean().getPopulationGroup() != null) {
                        jaxx.runtime.SwingUtil.fillComboBox(populationGroupPopulationGroupComboBox, getBean().getPopulationGroup(), getPopulationGroup(), true);
                    }
                }
            }
        });
    
        addPropertyChangeListener(PROPERTY_POPULATION_GROUP, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    fieldPopulationGroupMeanWeight.setText("");
                    fieldPopulationGroupPrice.setText("");
                    fieldPopulationGroupReproductionRate.setText("");
                    fieldPopulationGroupAge.setText("");
                    fieldPopulationGroupMinLength.setText("");
                    fieldPopulationGroupMaxLength.setText("");
                    fieldPopulationGroupComment.setText("");
                    fieldPopulationGroupNaturalDeathRate.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    
                }
            }
        });
    }
    
    @Override
    public void resetChangeModel() {
        changeModel.setStayChanged(false);
    }
    
    /*public void refresh() {
        //if (!isActive()) {
            setPopGroupNotNull(false);
        //}
        Population population = getSaveVerifier().getEntity(Population.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean(population);
    }*/
    
    protected void setNaturalDeathRateMatrix() {
        try {
            Population population = getBean();
            MatrixND naturalDeathRateMatrix = population.getNaturalDeathRateMatrix();
    
            // extract only line for this population group
            MatrixND naturalDeathRateMatrix2 = naturalDeathRateMatrix.getSubMatrix(0, getPopulationGroup());
            fieldPopulationGroupNaturalDeathRate.setMatrix(naturalDeathRateMatrix2.copy());
        } catch (Exception e) {
            // can happen if population has no zone yet
            // TODO maybe display a message
            if (log.isWarnEnabled()) {
                log.warn("No zone defined for this population group", e);
            }
        }
    }
    
    /**
     * Called on PopulationGroup combo box selection.
     */
    protected void populationGroupChanged() {
        PopulationGroup selectedPopulationGroup = (PopulationGroup)populationGroupPopulationGroupComboBox.getSelectedItem();
        setPopulationGroup(selectedPopulationGroup);
        if (selectedPopulationGroup != null) {
            getSaveVerifier().addCurrentEntity(selectedPopulationGroup);
            setNaturalDeathRateMatrix();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationGroupUI() {
        $initialize();
    }

    public PopulationGroupUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationGroupUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationGroupUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationGroupUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationGroupUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationGroupUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationGroupUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__populationGroupPopulationGroupComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        populationGroupChanged();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);validatorGroup.setChanged(false);
    }

    public void doKeyReleased__on__fieldPopulationGroupComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getPopulationGroup().setComment(fieldPopulationGroupComment.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public ChangeModel getChangeModel() {
        return changeModel;
    }

    public JTextField getFieldPopulationGroupAge() {
        return fieldPopulationGroupAge;
    }

    public JTextArea getFieldPopulationGroupComment() {
        return fieldPopulationGroupComment;
    }

    public JTextField getFieldPopulationGroupMaturityOgive() {
        return fieldPopulationGroupMaturityOgive;
    }

    public JTextField getFieldPopulationGroupMaxLength() {
        return fieldPopulationGroupMaxLength;
    }

    public JTextField getFieldPopulationGroupMeanWeight() {
        return fieldPopulationGroupMeanWeight;
    }

    public JTextField getFieldPopulationGroupMinLength() {
        return fieldPopulationGroupMinLength;
    }

    public MatrixPanelEditor getFieldPopulationGroupNaturalDeathRate() {
        return fieldPopulationGroupNaturalDeathRate;
    }

    public JTextField getFieldPopulationGroupPrice() {
        return fieldPopulationGroupPrice;
    }

    public JTextField getFieldPopulationGroupReproductionRate() {
        return fieldPopulationGroupReproductionRate;
    }

    public PopulationGroup getPopulationGroup() {
        return populationGroup;
    }

    public JAXXComboBox getPopulationGroupPopulationGroupComboBox() {
        return populationGroupPopulationGroupComboBox;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Population> getValidator() {
        return validator;
    }

    public SwingValidator<PopulationGroup> getValidatorGroup() {
        return validatorGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPopulationGroup(PopulationGroup populationGroup) {
        PopulationGroup oldValue = this.populationGroup;
        this.populationGroup = populationGroup;
        firePropertyChange(PROPERTY_POPULATION_GROUP, oldValue, populationGroup);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidatorGroup() {
        if (!allComponentsCreated) {
            return;
        }
        validatorGroup.setUiClass(ImageValidationUI.class);
        validatorGroup.setParentValidator(getValidator());
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        $objectMap.put("changeModel", changeModel = new ChangeModel());
    }

    protected void createFieldPopulationGroupAge() {
        $objectMap.put("fieldPopulationGroupAge", fieldPopulationGroupAge = new JTextField());
        
        fieldPopulationGroupAge.setName("fieldPopulationGroupAge");
        fieldPopulationGroupAge.setColumns(15);
        fieldPopulationGroupAge.setEnabled(false);
    }

    protected void createFieldPopulationGroupComment() {
        $objectMap.put("fieldPopulationGroupComment", fieldPopulationGroupComment = new JTextArea());
        
        fieldPopulationGroupComment.setName("fieldPopulationGroupComment");
        fieldPopulationGroupComment.setColumns(15);
        fieldPopulationGroupComment.setLineWrap(true);
        fieldPopulationGroupComment.setWrapStyleWord(true);
        fieldPopulationGroupComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationGroupComment"));
    }

    protected void createFieldPopulationGroupMaturityOgive() {
        $objectMap.put("fieldPopulationGroupMaturityOgive", fieldPopulationGroupMaturityOgive = new JTextField());
        
        fieldPopulationGroupMaturityOgive.setName("fieldPopulationGroupMaturityOgive");
        fieldPopulationGroupMaturityOgive.setColumns(15);
        fieldPopulationGroupMaturityOgive.setEnabled(false);
    }

    protected void createFieldPopulationGroupMaxLength() {
        $objectMap.put("fieldPopulationGroupMaxLength", fieldPopulationGroupMaxLength = new JTextField());
        
        fieldPopulationGroupMaxLength.setName("fieldPopulationGroupMaxLength");
        fieldPopulationGroupMaxLength.setColumns(15);
        fieldPopulationGroupMaxLength.setEnabled(false);
        fieldPopulationGroupMaxLength.setToolTipText(_("isisfish.populationGroup.maximumLength"));
    }

    protected void createFieldPopulationGroupMeanWeight() {
        $objectMap.put("fieldPopulationGroupMeanWeight", fieldPopulationGroupMeanWeight = new JTextField());
        
        fieldPopulationGroupMeanWeight.setName("fieldPopulationGroupMeanWeight");
        fieldPopulationGroupMeanWeight.setColumns(15);
        fieldPopulationGroupMeanWeight.setEnabled(false);
    }

    protected void createFieldPopulationGroupMinLength() {
        $objectMap.put("fieldPopulationGroupMinLength", fieldPopulationGroupMinLength = new JTextField());
        
        fieldPopulationGroupMinLength.setName("fieldPopulationGroupMinLength");
        fieldPopulationGroupMinLength.setColumns(15);
        fieldPopulationGroupMinLength.setEnabled(false);
        fieldPopulationGroupMinLength.setToolTipText(_("isisfish.populationGroup.minimumLength"));
    }

    protected void createFieldPopulationGroupNaturalDeathRate() {
        $objectMap.put("fieldPopulationGroupNaturalDeathRate", fieldPopulationGroupNaturalDeathRate = new MatrixPanelEditor());
        
        fieldPopulationGroupNaturalDeathRate.setName("fieldPopulationGroupNaturalDeathRate");
        fieldPopulationGroupNaturalDeathRate.setEnabled(false);
    }

    protected void createFieldPopulationGroupPrice() {
        $objectMap.put("fieldPopulationGroupPrice", fieldPopulationGroupPrice = new JTextField());
        
        fieldPopulationGroupPrice.setName("fieldPopulationGroupPrice");
        fieldPopulationGroupPrice.setColumns(15);
        fieldPopulationGroupPrice.setEnabled(false);
    }

    protected void createFieldPopulationGroupReproductionRate() {
        $objectMap.put("fieldPopulationGroupReproductionRate", fieldPopulationGroupReproductionRate = new JTextField());
        
        fieldPopulationGroupReproductionRate.setName("fieldPopulationGroupReproductionRate");
        fieldPopulationGroupReproductionRate.setColumns(15);
        fieldPopulationGroupReproductionRate.setEnabled(false);
    }

    protected void createPopulationGroup() {
        $objectMap.put("populationGroup", populationGroup = null);
    }

    protected void createPopulationGroupPopulationGroupComboBox() {
        $objectMap.put("populationGroupPopulationGroupComboBox", populationGroupPopulationGroupComboBox = new JAXXComboBox());
        
        populationGroupPopulationGroupComboBox.setName("populationGroupPopulationGroupComboBox");
        populationGroupPopulationGroupComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__populationGroupPopulationGroupComboBox"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(_("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(Population.class, "group"));
    }

    protected void createValidatorGroup() {
        $objectMap.put("validatorGroup", validatorGroup = SwingValidatorUtil.newValidator(PopulationGroup.class, "population"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToValidatorGroup();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(populationGroupPopulationGroupComboBox, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupNaturalDeathRate), new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupMeanWeight), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupMaturityOgive), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupReproductionRate), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel5, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupPrice), new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel6, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupAge), new GridBagConstraints(1, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel7, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupMinLength), new GridBagConstraints(1, 7, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupMaxLength), new GridBagConstraints(2, 7, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel8, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(1, 8, 2, 1, 1.0, 3.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 9, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupComment));
        // inline complete setup of $Table1
        $Table1.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 25 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // late initializer
        // register 2 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopulationGroup();
        createValidator();
        createValidatorGroup();
        createChangeModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.common.populationGroup"));
        createPopulationGroupPopulationGroupComboBox();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.populationGroup.naturalDeathRate"));
        createFieldPopulationGroupNaturalDeathRate();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.populationGroup.meanWeigth"));
        createFieldPopulationGroupMeanWeight();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.populationGroup.maturityOgive"));
        createFieldPopulationGroupMaturityOgive();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.populationGroup.reproductionRate"));
        createFieldPopulationGroupReproductionRate();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.populationGroup.price"));
        createFieldPopulationGroupPrice();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("isisfish.populationGroup.age"));
        createFieldPopulationGroupAge();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("isisfish.populationGroup.length"));
        createFieldPopulationGroupMinLength();
        createFieldPopulationGroupMaxLength();
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("isisfish.populationGroup.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldPopulationGroupComment();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 25 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 25 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_GROUP_BEAN, true ,"populationGroup") {
        
            @Override
            public void processDataBinding() {
                validatorGroup.setBean(getPopulationGroup());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                if (validatorGroup != null) {
                    validatorGroup.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorGroup != null) {
                    changeModel.setChanged(validator.isChanged() || validatorGroup.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                if (validatorGroup != null) {
                    validatorGroup.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validatorGroup != null) {
                    validatorGroup.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorGroup != null) {
                    changeModel.setValid(validator.isValid() && validatorGroup.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validatorGroup != null) {
                    validatorGroup.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_GROUP_POPULATION_GROUP_COMBO_BOX_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationGroupPopulationGroupComboBox.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"populationGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(getPopulationGroup() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"populationGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(getPopulationGroup() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_GROUP_MEAN_WEIGHT_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().addPropertyChangeListener("meanWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationGroup() != null) {
                    SwingUtil.setText(fieldPopulationGroupMeanWeight, String.valueOf(getPopulationGroup().getMeanWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().removePropertyChangeListener("meanWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"populationGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(getPopulationGroup() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_GROUP_MATURITY_OGIVE_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().addPropertyChangeListener("maturityOgive", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationGroup() != null) {
                    SwingUtil.setText(fieldPopulationGroupMaturityOgive, String.valueOf(getPopulationGroup().getMaturityOgive()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().removePropertyChangeListener("maturityOgive", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"populationGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(getPopulationGroup() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_GROUP_REPRODUCTION_RATE_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().addPropertyChangeListener("reproductionRate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationGroup() != null) {
                    SwingUtil.setText(fieldPopulationGroupReproductionRate, String.valueOf(getPopulationGroup().getReproductionRate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().removePropertyChangeListener("reproductionRate", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL5_ENABLED, true ,"populationGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel5.setEnabled(getPopulationGroup() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_GROUP_PRICE_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().addPropertyChangeListener("price", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationGroup() != null) {
                    SwingUtil.setText(fieldPopulationGroupPrice, String.valueOf(getPopulationGroup().getPrice()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().removePropertyChangeListener("price", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL6_ENABLED, true ,"populationGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel6.setEnabled(getPopulationGroup() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_GROUP_AGE_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().addPropertyChangeListener("age", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationGroup() != null) {
                    SwingUtil.setText(fieldPopulationGroupAge, String.valueOf(getPopulationGroup().getAge()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().removePropertyChangeListener("age", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL7_ENABLED, true ,"populationGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel7.setEnabled(getPopulationGroup() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_GROUP_MIN_LENGTH_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().addPropertyChangeListener("minLength", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationGroup() != null) {
                    SwingUtil.setText(fieldPopulationGroupMinLength, String.valueOf(getPopulationGroup().getMinLength()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().removePropertyChangeListener("minLength", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_GROUP_MAX_LENGTH_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().addPropertyChangeListener("maxLength", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationGroup() != null) {
                    SwingUtil.setText(fieldPopulationGroupMaxLength, String.valueOf(getPopulationGroup().getMaxLength()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().removePropertyChangeListener("maxLength", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL8_ENABLED, true ,"populationGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel8.setEnabled(getPopulationGroup() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_GROUP_COMMENT_ENABLED, true ,"populationGroup") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationGroupComment.setEnabled(getPopulationGroup() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_GROUP_COMMENT_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationGroup() != null) {
                    SwingUtil.setText(fieldPopulationGroupComment, jaxx.runtime.SwingUtil.getStringValue(getPopulationGroup().getComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationGroup", this);
                if (getPopulationGroup() != null) {
                    getPopulationGroup().removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    save.setEnabled(changeModel.isValid() && changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    cancel.setEnabled(changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}