package fr.ifremer.isisfish.entities;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class TargetSpeciesAbstract extends TopiaEntityAbstract implements TargetSpecies {

    /**
     * Nom de l'attribut en BD : targetFactorEquation
     */
    protected Equation targetFactorEquation;

    /**
     * <p>Vrai si la MetaPopulation est une esp&egrave;ce vis&eacute;e prioritairement</p>
     * 
     * Nom de l'attribut en BD : primaryCatch
     */
    protected boolean primaryCatch;

    /**
     * Nom de l'attribut en BD : species
     */
    protected Species species;

    /**
     * Nom de l'attribut en BD : metierSeasonInfo
     */
    protected MetierSeasonInfo metierSeasonInfo;

    private static final long serialVersionUID = 3978423611512152932L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TargetSpecies.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TargetSpecies.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_TARGET_FACTOR_EQUATION, Equation.class, targetFactorEquation);
        visitor.visit(this, PROPERTY_PRIMARY_CATCH, boolean.class, primaryCatch);
        visitor.visit(this, PROPERTY_SPECIES, Species.class, species);
        visitor.visit(this, PROPERTY_METIER_SEASON_INFO, MetierSeasonInfo.class, metierSeasonInfo);
        visitor.end(this);
    }

    @Override
    public void setTargetFactorEquation(Equation targetFactorEquation) {
        Equation oldValue = this.targetFactorEquation;
        fireOnPreWrite(PROPERTY_TARGET_FACTOR_EQUATION, oldValue, targetFactorEquation);
        this.targetFactorEquation = targetFactorEquation;
        fireOnPostWrite(PROPERTY_TARGET_FACTOR_EQUATION, oldValue, targetFactorEquation);
    }

    @Override
    public Equation getTargetFactorEquation() {
        fireOnPreRead(PROPERTY_TARGET_FACTOR_EQUATION, targetFactorEquation);
        Equation result = this.targetFactorEquation;
        fireOnPostRead(PROPERTY_TARGET_FACTOR_EQUATION, targetFactorEquation);
        return result;
    }

    @Override
    public void setPrimaryCatch(boolean primaryCatch) {
        boolean oldValue = this.primaryCatch;
        fireOnPreWrite(PROPERTY_PRIMARY_CATCH, oldValue, primaryCatch);
        this.primaryCatch = primaryCatch;
        fireOnPostWrite(PROPERTY_PRIMARY_CATCH, oldValue, primaryCatch);
    }

    @Override
    public boolean isPrimaryCatch() {
        fireOnPreRead(PROPERTY_PRIMARY_CATCH, primaryCatch);
        boolean result = this.primaryCatch;
        fireOnPostRead(PROPERTY_PRIMARY_CATCH, primaryCatch);
        return result;
    }

    @Override
    public boolean getPrimaryCatch() {
        fireOnPreRead(PROPERTY_PRIMARY_CATCH, primaryCatch);
        boolean result = this.primaryCatch;
        fireOnPostRead(PROPERTY_PRIMARY_CATCH, primaryCatch);
        return result;
    }

    @Override
    public void setSpecies(Species species) {
        Species oldValue = this.species;
        fireOnPreWrite(PROPERTY_SPECIES, oldValue, species);
        this.species = species;
        fireOnPostWrite(PROPERTY_SPECIES, oldValue, species);
    }

    @Override
    public Species getSpecies() {
        fireOnPreRead(PROPERTY_SPECIES, species);
        Species result = this.species;
        fireOnPostRead(PROPERTY_SPECIES, species);
        return result;
    }

    @Override
    public void setMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo) {
        MetierSeasonInfo oldValue = this.metierSeasonInfo;
        fireOnPreWrite(PROPERTY_METIER_SEASON_INFO, oldValue, metierSeasonInfo);
        this.metierSeasonInfo = metierSeasonInfo;
        fireOnPostWrite(PROPERTY_METIER_SEASON_INFO, oldValue, metierSeasonInfo);
    }

    @Override
    public MetierSeasonInfo getMetierSeasonInfo() {
        fireOnPreRead(PROPERTY_METIER_SEASON_INFO, metierSeasonInfo);
        MetierSeasonInfo result = this.metierSeasonInfo;
        fireOnPostRead(PROPERTY_METIER_SEASON_INFO, metierSeasonInfo);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getTargetFactorEquation());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_TARGET_FACTOR_EQUATION, this.targetFactorEquation).
            append(PROPERTY_PRIMARY_CATCH, this.primaryCatch).
         toString();
        return result;
    }

} //TargetSpeciesAbstract
