package fr.ifremer.isisfish.entities;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class StrategyAbstract extends TopiaEntityAbstract implements Strategy {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : proportionSetOfVessels
     */
    protected double proportionSetOfVessels;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : inactivityEquationUsed
     */
    protected boolean inactivityEquationUsed;

    /**
     * Nom de l'attribut en BD : inactivityEquation
     */
    protected Equation inactivityEquation;

    /**
     * Nom de l'attribut en BD : setOfVessels
     */
    protected SetOfVessels setOfVessels;

    /**
     * Nom de l'attribut en BD : strategyMonthInfo
     */
    protected List<StrategyMonthInfo> strategyMonthInfo;

    private static final long serialVersionUID = 3762817297718786101L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Strategy.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Strategy.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_PROPORTION_SET_OF_VESSELS, double.class, proportionSetOfVessels);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_INACTIVITY_EQUATION_USED, boolean.class, inactivityEquationUsed);
        visitor.visit(this, PROPERTY_INACTIVITY_EQUATION, Equation.class, inactivityEquation);
        visitor.visit(this, PROPERTY_SET_OF_VESSELS, SetOfVessels.class, setOfVessels);
        visitor.visit(this, PROPERTY_STRATEGY_MONTH_INFO, List.class, StrategyMonthInfo.class, strategyMonthInfo);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setProportionSetOfVessels(double proportionSetOfVessels) {
        double oldValue = this.proportionSetOfVessels;
        fireOnPreWrite(PROPERTY_PROPORTION_SET_OF_VESSELS, oldValue, proportionSetOfVessels);
        this.proportionSetOfVessels = proportionSetOfVessels;
        fireOnPostWrite(PROPERTY_PROPORTION_SET_OF_VESSELS, oldValue, proportionSetOfVessels);
    }

    @Override
    public double getProportionSetOfVessels() {
        fireOnPreRead(PROPERTY_PROPORTION_SET_OF_VESSELS, proportionSetOfVessels);
        double result = this.proportionSetOfVessels;
        fireOnPostRead(PROPERTY_PROPORTION_SET_OF_VESSELS, proportionSetOfVessels);
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        fireOnPreRead(PROPERTY_COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(PROPERTY_COMMENT, comment);
        return result;
    }

    @Override
    public void setInactivityEquationUsed(boolean inactivityEquationUsed) {
        boolean oldValue = this.inactivityEquationUsed;
        fireOnPreWrite(PROPERTY_INACTIVITY_EQUATION_USED, oldValue, inactivityEquationUsed);
        this.inactivityEquationUsed = inactivityEquationUsed;
        fireOnPostWrite(PROPERTY_INACTIVITY_EQUATION_USED, oldValue, inactivityEquationUsed);
    }

    @Override
    public boolean isInactivityEquationUsed() {
        fireOnPreRead(PROPERTY_INACTIVITY_EQUATION_USED, inactivityEquationUsed);
        boolean result = this.inactivityEquationUsed;
        fireOnPostRead(PROPERTY_INACTIVITY_EQUATION_USED, inactivityEquationUsed);
        return result;
    }

    @Override
    public boolean getInactivityEquationUsed() {
        fireOnPreRead(PROPERTY_INACTIVITY_EQUATION_USED, inactivityEquationUsed);
        boolean result = this.inactivityEquationUsed;
        fireOnPostRead(PROPERTY_INACTIVITY_EQUATION_USED, inactivityEquationUsed);
        return result;
    }

    @Override
    public void setInactivityEquation(Equation inactivityEquation) {
        Equation oldValue = this.inactivityEquation;
        fireOnPreWrite(PROPERTY_INACTIVITY_EQUATION, oldValue, inactivityEquation);
        this.inactivityEquation = inactivityEquation;
        fireOnPostWrite(PROPERTY_INACTIVITY_EQUATION, oldValue, inactivityEquation);
    }

    @Override
    public Equation getInactivityEquation() {
        fireOnPreRead(PROPERTY_INACTIVITY_EQUATION, inactivityEquation);
        Equation result = this.inactivityEquation;
        fireOnPostRead(PROPERTY_INACTIVITY_EQUATION, inactivityEquation);
        return result;
    }

    @Override
    public void setSetOfVessels(SetOfVessels setOfVessels) {
        SetOfVessels oldValue = this.setOfVessels;
        fireOnPreWrite(PROPERTY_SET_OF_VESSELS, oldValue, setOfVessels);
        this.setOfVessels = setOfVessels;
        fireOnPostWrite(PROPERTY_SET_OF_VESSELS, oldValue, setOfVessels);
    }

    @Override
    public SetOfVessels getSetOfVessels() {
        fireOnPreRead(PROPERTY_SET_OF_VESSELS, setOfVessels);
        SetOfVessels result = this.setOfVessels;
        fireOnPostRead(PROPERTY_SET_OF_VESSELS, setOfVessels);
        return result;
    }

    @Override
    public void addStrategyMonthInfo(StrategyMonthInfo strategyMonthInfo) {
        fireOnPreWrite(PROPERTY_STRATEGY_MONTH_INFO, null, strategyMonthInfo);
        if (this.strategyMonthInfo == null) {
            this.strategyMonthInfo = new ArrayList<StrategyMonthInfo>();
        }

        strategyMonthInfo.setStrategy(this);

        this.strategyMonthInfo.add(strategyMonthInfo);
        fireOnPostWrite(PROPERTY_STRATEGY_MONTH_INFO, this.strategyMonthInfo.size(), null, strategyMonthInfo);
    }

    @Override
    public void addAllStrategyMonthInfo(List<StrategyMonthInfo> strategyMonthInfo) {
        if (strategyMonthInfo == null) {
            return;
        }
        for (StrategyMonthInfo item : strategyMonthInfo) {
            addStrategyMonthInfo(item);
        }
    }

    @Override
    public void setStrategyMonthInfo(List<StrategyMonthInfo> strategyMonthInfo) {
        // Copy elements to keep data for fire with new reference
        List<StrategyMonthInfo> oldValue = this.strategyMonthInfo != null ? new ArrayList<StrategyMonthInfo>(this.strategyMonthInfo) : null;
        fireOnPreWrite(PROPERTY_STRATEGY_MONTH_INFO, oldValue, strategyMonthInfo);
        this.strategyMonthInfo = strategyMonthInfo;
        fireOnPostWrite(PROPERTY_STRATEGY_MONTH_INFO, oldValue, strategyMonthInfo);
    }

    @Override
    public void removeStrategyMonthInfo(StrategyMonthInfo strategyMonthInfo) {
        fireOnPreWrite(PROPERTY_STRATEGY_MONTH_INFO, strategyMonthInfo, null);
        if (this.strategyMonthInfo == null || !this.strategyMonthInfo.remove(strategyMonthInfo)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        strategyMonthInfo.setStrategy(null);

        fireOnPostWrite(PROPERTY_STRATEGY_MONTH_INFO, this.strategyMonthInfo.size() + 1, strategyMonthInfo, null);
    }

    @Override
    public void clearStrategyMonthInfo() {
        if (this.strategyMonthInfo == null) {
            return;
        }
        for (StrategyMonthInfo item : this.strategyMonthInfo) {
            item.setStrategy(null);
        }
        List<StrategyMonthInfo> oldValue = new ArrayList<StrategyMonthInfo>(this.strategyMonthInfo);
        fireOnPreWrite(PROPERTY_STRATEGY_MONTH_INFO, oldValue, this.strategyMonthInfo);
        this.strategyMonthInfo.clear();
        fireOnPostWrite(PROPERTY_STRATEGY_MONTH_INFO, oldValue, this.strategyMonthInfo);
    }

    @Override
    public List<StrategyMonthInfo> getStrategyMonthInfo() {
        return strategyMonthInfo;
    }

    @Override
    public StrategyMonthInfo getStrategyMonthInfoByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(strategyMonthInfo, topiaId);
    }

    @Override
    public int sizeStrategyMonthInfo() {
        if (strategyMonthInfo == null) {
            return 0;
        }
        return strategyMonthInfo.size();
    }

    @Override
    public boolean isStrategyMonthInfoEmpty() {
        int size = sizeStrategyMonthInfo();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getInactivityEquation());
        if (getStrategyMonthInfo() != null) {
              tmp.addAll(getStrategyMonthInfo());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_PROPORTION_SET_OF_VESSELS, this.proportionSetOfVessels).
            append(PROPERTY_COMMENT, this.comment).
            append(PROPERTY_INACTIVITY_EQUATION_USED, this.inactivityEquationUsed).
            append(PROPERTY_INACTIVITY_EQUATION, this.inactivityEquation).
            append(PROPERTY_SET_OF_VESSELS, this.setOfVessels).
         toString();
        return result;
    }

} //StrategyAbstract
