/*
 * #%L
 * IsisFish
 * 
 * $Id: CacheAspect.java 3736 2012-08-27 17:21:00Z bpoussin $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Cache;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.aspectwerkz.annotation.Around;
import org.codehaus.aspectwerkz.annotation.Aspect;
import org.codehaus.aspectwerkz.annotation.Expression;
import org.codehaus.aspectwerkz.definition.Pointcut;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MethodRtti;
import org.codehaus.aspectwerkz.joinpoint.MethodSignature;

/**
 * CacheAspect aspect.
 * 
 * Created: 25 août 06 22:42:47
 *
 * @author poussin
 * @version $Revision: 3736 $
 *
 * Last update: $Date: 2012-08-27 19:21:00 +0200 (Mon, 27 Aug 2012) $
 * by : $Author: bpoussin $
 */
@Aspect("perJVM")
public class CacheAspect {
    
    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(CacheAspect.class);

    @Expression("execution(* scripts..*(..))")
    Pointcut scriptsMethod;

    public CacheAspect() {
    }

    /**
     * Return trace object from context.
     *
     * @return trace object from context
     */
    protected Cache getCache() {
        SimulationContext context = SimulationContext.get();
        Cache result = context.getCache();
        return result;
    }
    
    @Around("scriptsMethod")
    public Object call(final JoinPoint jp) throws Throwable {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        Object[] args = ((MethodRtti)jp.getRtti()).getParameterValues();
        Object result = getCache().get(method, args, jp);
        
        if (log.isTraceEnabled()) {
            log.trace(((MethodSignature)jp.getSignature()).getMethod()
                    + " args " + Arrays.toString(((MethodRtti)jp.getRtti()).getParameterValues())
                    + " result = " + result);
        }
        return result;
    }
    
}


