package fr.ifremer.isisfish;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.ActiveRule;
import fr.ifremer.isisfish.entities.ActiveRuleDAO;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.CellDAO;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.EffortDescriptionDAO;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.EquationDAO;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.FisheryRegionDAO;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.GearDAO;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierDAO;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.MetierSeasonInfoDAO;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationGroupDAO;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoDAO;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.PortDAO;
import fr.ifremer.isisfish.entities.Result;
import fr.ifremer.isisfish.entities.ResultDAO;
import fr.ifremer.isisfish.entities.Season;
import fr.ifremer.isisfish.entities.SeasonDAO;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.SelectivityDAO;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.SetOfVesselsDAO;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.SpeciesDAO;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyDAO;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.StrategyMonthInfoDAO;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.entities.TargetSpeciesDAO;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.TripTypeDAO;
import fr.ifremer.isisfish.entities.Variable;
import fr.ifremer.isisfish.entities.VariableDAO;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.VesselTypeDAO;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.entities.ZoneDAO;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperatorStore;

public class IsisFishDAOHelper {

    public enum IsisFishEntityEnum implements TopiaEntityEnum {
        ActiveRule(ActiveRule.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Cell(Cell.class, ArrayUtils.EMPTY_STRING_ARRAY),
        EffortDescription(EffortDescription.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Equation(Equation.class, ArrayUtils.EMPTY_STRING_ARRAY),
        FisheryRegion(FisheryRegion.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Gear(Gear.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Metier(Metier.class, ArrayUtils.EMPTY_STRING_ARRAY),
        MetierSeasonInfo(MetierSeasonInfo.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Population(Population.class, ArrayUtils.EMPTY_STRING_ARRAY),
        PopulationGroup(PopulationGroup.class, ArrayUtils.EMPTY_STRING_ARRAY),
        PopulationSeasonInfo(PopulationSeasonInfo.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Port(Port.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Result(Result.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Season(Season.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Selectivity(Selectivity.class, ArrayUtils.EMPTY_STRING_ARRAY),
        SetOfVessels(SetOfVessels.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Species(Species.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Strategy(Strategy.class, ArrayUtils.EMPTY_STRING_ARRAY),
        StrategyMonthInfo(StrategyMonthInfo.class, ArrayUtils.EMPTY_STRING_ARRAY),
        TargetSpecies(TargetSpecies.class, ArrayUtils.EMPTY_STRING_ARRAY),
        TripType(TripType.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Variable(Variable.class, new String[]{ "entityId" }),
        VesselType(VesselType.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Zone(Zone.class, ArrayUtils.EMPTY_STRING_ARRAY);

        /**
         * The contract of the entity.
         */
        protected Class<? extends TopiaEntity> contract;

        /**
         * The fully qualified name of the implementation of the entity.
         */
        protected String implementationFQN;

        /**
         * The implementation class of the entity (will be lazy computed at runtime).
         */
        protected Class<? extends TopiaEntity> implementation;

        /**
         * The array of property involved in the natural key of the entity.
         */
        protected String[] naturalIds;

        /**
         * The array of not null properties of the entity.
         */
        protected String[] notNulls;

        IsisFishEntityEnum(Class<? extends TopiaEntity > contract, String[] notNulls, String... naturalIds)     {
        this.contract = contract;
        this.notNulls = notNulls;
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract()     {
        return contract;
        }

        @Override
        public String[] getNaturalIds()     {
        return naturalIds;
        }

        @Override
        public boolean isUseNaturalIds()     {
        return naturalIds.length > 0;
        }

        @Override
        public String[] getNotNulls()     {
        return notNulls;
        }

        @Override
        public boolean isUseNotNulls()     {
        return notNulls.length > 0;
        }

        @Override
        public String getImplementationFQN()     {
        return implementationFQN;
        }

        @Override
        public void setImplementationFQN(String implementationFQN)     {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass)     {
        return IsisFishDAOHelper.getContractClass(klass) == contract;
        }

        @Override
        public Class<? extends TopiaEntity> getImplementation()     {
        if (implementation == null) {
        try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaRuntimeException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
        }

        public static IsisFishEntityEnum valueOf(TopiaEntity entity)     {
        return valueOf(entity.getClass());
        }

        public static IsisFishEntityEnum valueOf(Class<?> klass)     {
        if (klass.isInterface()) {
           return valueOf(klass.getSimpleName());
        }
        for (IsisFishEntityEnum entityEnum : IsisFishEntityEnum.values()) {
            if (entityEnum.getContract().isAssignableFrom(klass)) {
                //todo check it works for inheritance
                return entityEnum;
            }
        }
        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(IsisFishEntityEnum.values()));
        }

    } //IsisFishEntityEnum

    protected IsisFishDAOHelper() { }

    public static String getModelVersion() {
        return "4.1";
    }

    public static String getModelName() {
        return "IsisFish";
    }

    public static ActiveRuleDAO getActiveRuleDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ActiveRuleDAO result = ci.getDAO(ActiveRule.class, ActiveRuleDAO.class);
        return result;
    }

    public static CellDAO getCellDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CellDAO result = ci.getDAO(Cell.class, CellDAO.class);
        return result;
    }

    public static EffortDescriptionDAO getEffortDescriptionDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        EffortDescriptionDAO result = ci.getDAO(EffortDescription.class, EffortDescriptionDAO.class);
        return result;
    }

    public static EquationDAO getEquationDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        EquationDAO result = ci.getDAO(Equation.class, EquationDAO.class);
        return result;
    }

    public static FisheryRegionDAO getFisheryRegionDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        FisheryRegionDAO result = ci.getDAO(FisheryRegion.class, FisheryRegionDAO.class);
        return result;
    }

    public static GearDAO getGearDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        GearDAO result = ci.getDAO(Gear.class, GearDAO.class);
        return result;
    }

    public static MetierDAO getMetierDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        MetierDAO result = ci.getDAO(Metier.class, MetierDAO.class);
        return result;
    }

    public static MetierSeasonInfoDAO getMetierSeasonInfoDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        MetierSeasonInfoDAO result = ci.getDAO(MetierSeasonInfo.class, MetierSeasonInfoDAO.class);
        return result;
    }

    public static PopulationDAO getPopulationDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PopulationDAO result = ci.getDAO(Population.class, PopulationDAO.class);
        return result;
    }

    public static PopulationGroupDAO getPopulationGroupDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PopulationGroupDAO result = ci.getDAO(PopulationGroup.class, PopulationGroupDAO.class);
        return result;
    }

    public static PopulationSeasonInfoDAO getPopulationSeasonInfoDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PopulationSeasonInfoDAO result = ci.getDAO(PopulationSeasonInfo.class, PopulationSeasonInfoDAO.class);
        return result;
    }

    public static PortDAO getPortDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PortDAO result = ci.getDAO(Port.class, PortDAO.class);
        return result;
    }

    public static ResultDAO getResultDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ResultDAO result = ci.getDAO(Result.class, ResultDAO.class);
        return result;
    }

    public static SeasonDAO getSeasonDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SeasonDAO result = ci.getDAO(Season.class, SeasonDAO.class);
        return result;
    }

    public static SelectivityDAO getSelectivityDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SelectivityDAO result = ci.getDAO(Selectivity.class, SelectivityDAO.class);
        return result;
    }

    public static SetOfVesselsDAO getSetOfVesselsDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SetOfVesselsDAO result = ci.getDAO(SetOfVessels.class, SetOfVesselsDAO.class);
        return result;
    }

    public static SpeciesDAO getSpeciesDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SpeciesDAO result = ci.getDAO(Species.class, SpeciesDAO.class);
        return result;
    }

    public static StrategyDAO getStrategyDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        StrategyDAO result = ci.getDAO(Strategy.class, StrategyDAO.class);
        return result;
    }

    public static StrategyMonthInfoDAO getStrategyMonthInfoDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        StrategyMonthInfoDAO result = ci.getDAO(StrategyMonthInfo.class, StrategyMonthInfoDAO.class);
        return result;
    }

    public static TargetSpeciesDAO getTargetSpeciesDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TargetSpeciesDAO result = ci.getDAO(TargetSpecies.class, TargetSpeciesDAO.class);
        return result;
    }

    public static TripTypeDAO getTripTypeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TripTypeDAO result = ci.getDAO(TripType.class, TripTypeDAO.class);
        return result;
    }

    public static VariableDAO getVariableDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        VariableDAO result = ci.getDAO(Variable.class, VariableDAO.class);
        return result;
    }

    public static VesselTypeDAO getVesselTypeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        VesselTypeDAO result = ci.getDAO(VesselType.class, VesselTypeDAO.class);
        return result;
    }

    public static ZoneDAO getZoneDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ZoneDAO result = ci.getDAO(Zone.class, ZoneDAO.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        IsisFishEntityEnum constant = IsisFishEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        IsisFishEntityEnum constant = IsisFishEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        IsisFishEntityEnum constant = IsisFishEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        IsisFishEntityEnum constant = IsisFishEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        IsisFishEntityEnum[] values = IsisFishEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        IsisFishEntityEnum[] values = IsisFishEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static IsisFishEntityEnum[] getContracts() {
        return IsisFishEntityEnum.values();
    }

} //IsisFishDAOHelper
