/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.script.action;

import fr.ifremer.isisfish.ui.script.FileSelectionTableModel;
import fr.ifremer.isisfish.ui.util.IsisActionWithBackup;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ZipUtil;

public class ImportAction
extends IsisActionWithBackup {
    private static final long serialVersionUID = 2459027106690418279L;
    private static Log log = LogFactory.getLog(ImportAction.class);
    protected FileSelectionTableModel model;
    protected FileSelectionTableModel modelWithBackup;
    protected File source;
    private List<String> toImport;

    public ImportAction(JDialog dialog, File source, File root, FileSelectionTableModel modelNewItems, FileSelectionTableModel modelItems) {
        super(dialog, root);
        this.source = source;
        this.model = modelNewItems;
        this.modelWithBackup = modelItems;
    }

    @Override
    protected boolean prepare() {
        if (this.source == null || this.model == null && this.modelWithBackup == null || "".equals(this.source.getAbsolutePath())) {
            return false;
        }
        this.toImport = new ArrayList<String>();
        if (this.model != null) {
            this.toImport.addAll(this.model.getSelectedFiles());
        }
        if (this.modelWithBackup != null) {
            this.toImport.addAll(this.modelWithBackup.getSelectedFiles());
        }
        return !this.toImport.isEmpty();
    }

    @Override
    protected void perform(ActionEvent e) {
        super.perform(e);
        try {
            if (log.isInfoEnabled()) {
                for (String newFile : this.toImport) {
                    log.info((Object)("unzip " + newFile));
                }
            }
            ZipUtil.uncompress((File)this.source, (File)this.root, this.toImport, null, null);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("unzip " + this.toImport.size() + " entry(ies) from '" + this.source + "'"));
        }
        this.toImport.clear();
    }

    @Override
    protected List<String> getFilesToBackup() {
        ArrayList<String> toBackup = new ArrayList<String>();
        if (this.modelWithBackup != null) {
            toBackup.addAll(this.modelWithBackup.getSelectedFiles());
        }
        return toBackup;
    }
}

