/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.datastore.update.ImportFromV2;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.SpeciesDAO;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.mexico.export.RegionExplorer;
import fr.ifremer.isisfish.mexico.export.RegionExportFactorXML;
import fr.ifremer.isisfish.ui.CommonHandler;
import fr.ifremer.isisfish.ui.NavigationUI;
import fr.ifremer.isisfish.ui.input.CellUI;
import fr.ifremer.isisfish.ui.input.FisheryRegionUI;
import fr.ifremer.isisfish.ui.input.GearUI;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.input.MetierUI;
import fr.ifremer.isisfish.ui.input.PopulationUI;
import fr.ifremer.isisfish.ui.input.PortUI;
import fr.ifremer.isisfish.ui.input.SetOfVesselsUI;
import fr.ifremer.isisfish.ui.input.SpeciesUI;
import fr.ifremer.isisfish.ui.input.StrategyUI;
import fr.ifremer.isisfish.ui.input.TripTypeUI;
import fr.ifremer.isisfish.ui.input.VesselTypeUI;
import fr.ifremer.isisfish.ui.input.ZoneUI;
import fr.ifremer.isisfish.ui.input.tree.FisheryDataProvider;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeHelper;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeNode;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeRenderer;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeSelectionModel;
import fr.ifremer.isisfish.ui.input.tree.loadors.PopulationsNodeLoador;
import fr.ifremer.isisfish.ui.models.common.StringComboModel;
import fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityInputHandler;
import fr.ifremer.isisfish.ui.simulator.filter.SimulationFilterUtil;
import fr.ifremer.isisfish.vcs.VCSException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.util.FileUtil;

public class InputHandler
extends CommonHandler {
    private static Log log = LogFactory.getLog(InputHandler.class);
    protected Map<Class<?>, InputContentUI<?>> uiInstanceCache = new HashMap();

    protected void loadRegion(InputUI inputUI, String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load region " + name));
        }
        if (name == null) {
            inputUI.getCardlayoutPrincipal().show(inputUI.getInputPanePrincipal(), "none");
            DefaultTreeModel model = new DefaultTreeModel(null);
            inputUI.getFisheryRegionTree().setModel(model);
        } else {
            FisheryRegion fisheryRegion = null;
            RegionStorage regionStorage = null;
            TopiaContext topiaContext = null;
            try {
                regionStorage = RegionStorage.getRegion(name);
                topiaContext = regionStorage.getStorage().beginTransaction();
                fisheryRegion = RegionStorage.getFisheryRegion(topiaContext);
            }
            catch (TopiaException ex) {
                throw new IsisFishRuntimeException("Can't load region", ex);
            }
            catch (StorageException ex) {
                throw new IsisFishRuntimeException("Can't load region", ex);
            }
            inputUI.setRegionLoaded(fisheryRegion != null);
            FisheryTreeHelper fisheryTreeHelper = new FisheryTreeHelper();
            FisheryDataProvider dataProvider = new FisheryDataProvider(fisheryRegion);
            fisheryTreeHelper.setDataProvider(dataProvider);
            TreeModel fisheryTreeModel = fisheryTreeHelper.createTreeModel(fisheryRegion);
            inputUI.getFisheryRegionTree().setCellRenderer(null);
            inputUI.getFisheryRegionTree().setModel(fisheryTreeModel);
            inputUI.getFisheryRegionTree().setCellRenderer(new FisheryTreeRenderer(dataProvider));
            inputUI.getFisheryRegionTree().setSelectionModel(new FisheryTreeSelectionModel(inputUI));
            fisheryTreeHelper.setUI(inputUI.getFisheryRegionTree(), true, false, null);
            inputUI.setContextValue(fisheryRegion);
            inputUI.setContextValue(regionStorage);
            inputUI.setContextValue(fisheryTreeHelper);
            inputUI.setContextValue(fisheryTreeModel);
            inputUI.setContextValue(topiaContext);
            inputUI.getCardlayoutPrincipal().show(inputUI.getInputPanePrincipal(), "normale");
            fisheryTreeHelper.selectNode((NavNode)((FisheryTreeNode)((Object)fisheryTreeModel.getRoot())));
        }
    }

    public void reloadFisheryTree(InputUI inputUI) {
        FisheryTreeHelper fisheryTreeHelper = inputUI.getContextValue(FisheryTreeHelper.class);
        TreeModel fisheryTreeModel = inputUI.getContextValue(TreeModel.class);
        fisheryTreeHelper.refreshNode((NavNode)((FisheryTreeNode)((Object)fisheryTreeModel.getRoot())), true);
    }

    public void regionChange(final InputUI inputUI, ItemEvent e) {
        if (e.getStateChange() == 1) {
            final String name = (String)inputUI.getFieldCurrentRegion().getSelectedItem();
            if (log.isDebugEnabled()) {
                log.debug((Object)("New region selected " + name));
            }
            this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.loading.region", (Object[])new Object[]{name}), true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InputHandler.this.loadRegion(inputUI, name);
                    InputHandler.this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.load.finished", (Object[])new Object[0]));
                }
            });
        }
    }

    public void createNewRegion(InputUI inputUI) {
        String name = inputUI.getFieldNewRegion().getText();
        this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.creating.region", (Object[])new Object[]{name}), true);
        if (RegionStorage.getRegionNames().contains(name)) {
            JOptionPane.showMessageDialog(inputUI, I18n._((String)"isisfish.error.region.already.exists", (Object[])new Object[0]));
        } else {
            try {
                RegionStorage.create(name);
            }
            catch (StorageException ex) {
                throw new IsisFishRuntimeException("Can't create region", ex);
            }
            inputUI.getFieldNewRegion().setText("");
            this.refreshRegionList(inputUI, name);
        }
        this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.creation.finished", (Object[])new Object[0]));
    }

    protected void refreshRegionList(InputUI inputUI, String selectedItem) {
        StringComboModel regionsModel = new StringComboModel(RegionStorage.getRegionNames());
        inputUI.getFieldCurrentRegion().setModel(regionsModel);
        if (selectedItem != null) {
            inputUI.getFieldCurrentRegion().setSelectedItem(selectedItem);
        } else {
            this.loadRegion(inputUI, null);
        }
    }

    public void importRegion(InputUI inputUI) {
        this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.import.zip", (Object[])new Object[0]), true);
        try {
            File file = FileUtil.getFile((String[])new String[]{".*.zip$", I18n._((String)"isisfish.message.import.region.zipped", (Object[])new Object[0])});
            if (file != null) {
                RegionStorage.importZip(file);
                this.refreshRegionList(inputUI, null);
            }
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.region.import", (Object[])new Object[0]), eee);
        }
        this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.import.finished", (Object[])new Object[0]));
    }

    public void importRegionAndRename(InputUI inputUI) {
        this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.import.zip", (Object[])new Object[0]), true);
        try {
            File file = FileUtil.getFile((String[])new String[]{".*.zip$", I18n._((String)"isisfish.message.import.region.zipped", (Object[])new Object[0])});
            if (file != null) {
                String newName = JOptionPane.showInputDialog(I18n._((String)"isisfish.message.name.imported.region", (Object[])new Object[0]));
                RegionStorage.importAndRenameZip(file, newName);
                this.refreshRegionList(inputUI, null);
            }
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.region.import", (Object[])new Object[0]), eee);
        }
        this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.import.finished", (Object[])new Object[0]));
    }

    public void importV2Region(InputUI inputUI) {
        this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.import.xml.v2.file", (Object[])new Object[0]), true);
        try {
            File file = FileUtil.getFile((String[])new String[]{".*.xml$", I18n._((String)"isisfish.message.import.region.xml", (Object[])new Object[0])});
            if (file != null) {
                new ImportFromV2(true).importXML(file);
                this.refreshRegionList(inputUI, null);
            }
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.region.import", (Object[])new Object[0]), eee);
        }
        this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.import.finished", (Object[])new Object[0]));
    }

    public void importRegionFromSimulation(InputUI inputUI) {
        this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.import", (Object[])new Object[0]), true);
        try {
            List<String> simulationNames = SimulationStorage.getSimulationNames();
            String simulationName = SimulationFilterUtil.selectSimulation(simulationNames);
            if (simulationName != null) {
                String regionName;
                if (log.isInfoEnabled()) {
                    log.info((Object)("simulation used " + simulationName));
                }
                if (StringUtils.isNotBlank((CharSequence)(regionName = JOptionPane.showInputDialog(I18n._((String)"isisfish.message.import.region.name", (Object[])new Object[0]), (Object)("region from " + simulationName))))) {
                    if (RegionStorage.getRegionNames().contains(regionName)) {
                        JOptionPane.showMessageDialog(inputUI, I18n._((String)"isisfish.error.region.already.exists", (Object[])new Object[0]));
                    } else {
                        SimulationStorage.getSimulation(simulationName).extractRegion(regionName);
                    }
                }
            }
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.no.select.simulation", (Object[])new Object[0]), eee);
        }
        this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.export.done", (Object[])new Object[0]));
    }

    public void exportRegion(InputUI inputUI) {
        try {
            File file = FileUtil.getFile((String[])new String[]{".*.zip$", I18n._((String)"isisfish.message.import.region.zipped", (Object[])new Object[0])});
            if (file != null) {
                if (!file.getAbsolutePath().endsWith(".zip")) {
                    file = new File(file.getAbsolutePath() + ".zip");
                }
                int resp = 0;
                if (file.exists()) {
                    resp = JOptionPane.showConfirmDialog(inputUI, I18n._((String)"isisfish.message.file.overwrite", (Object[])new Object[0]));
                }
                if (resp == 0) {
                    RegionStorage regionStorage = inputUI.getContextValue(RegionStorage.class);
                    regionStorage.createZip(file);
                }
            }
        }
        catch (IOException eee) {
            throw new IsisFishRuntimeException("Can't export region", eee);
        }
    }

    public void removeRegion(InputUI inputUI, boolean vcsDelete) {
        try {
            RegionStorage regionStorage = inputUI.getContextValue(RegionStorage.class);
            int resp = JOptionPane.showConfirmDialog(inputUI, I18n._((String)"isisfish.message.confirm.remove.region", (Object[])new Object[]{regionStorage.getName()}));
            if (resp == 0) {
                regionStorage.delete(vcsDelete);
                this.refreshRegionList(inputUI, null);
            }
        }
        catch (StorageException eee) {
            throw new IsisFishRuntimeException("Can't delete region", eee);
        }
    }

    public void copyRegion(InputUI inputUI) {
        try {
            String newName = JOptionPane.showInputDialog(I18n._((String)"isisfish.message.new.region.name", (Object[])new Object[0]));
            if (StringUtils.isNotEmpty((CharSequence)newName)) {
                RegionStorage regionStorage = inputUI.getContextValue(RegionStorage.class);
                File zip = regionStorage.createZip();
                RegionStorage.importAndRenameZip(zip, newName);
            }
        }
        catch (IOException eee) {
            throw new IsisFishRuntimeException("Can't copy region", eee);
        }
        catch (StorageException eee) {
            throw new IsisFishRuntimeException("Can't copy region", eee);
        }
    }

    public void commitRegionInCVS(InputUI inputUI) {
        try {
            RegionStorage regionStorage = inputUI.getContextValue(RegionStorage.class);
            this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.commiting.region", (Object[])new Object[]{regionStorage.getName()}), true);
            String msg = regionStorage.getCommentForNextCommit();
            JTextArea text = new JTextArea(msg);
            int resp = JOptionPane.showOptionDialog(null, new JScrollPane(text), I18n._((String)"isisfish.commit.message", (Object[])new Object[0]), 2, 3, null, null, null);
            if (resp == 0) {
                regionStorage.commit(text.getText());
                regionStorage.clearCommentForNextCommit();
                this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.region.commited", (Object[])new Object[0]));
            } else {
                this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.commit.region.canceled", (Object[])new Object[0]));
            }
        }
        catch (VCSException eee) {
            throw new IsisFishRuntimeException("Can't commit region", eee);
        }
        catch (IOException eee) {
            throw new IsisFishRuntimeException("Can't commit region", eee);
        }
        this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.message.export.done", (Object[])new Object[0]));
    }

    public void exportRegionSensitivityFactors(InputUI inputUI) {
        try {
            File exportFile = FileUtil.getFile((String)I18n._((String)"isisfish.input.sensitivity.export.title", (Object[])new Object[0]), (String)I18n._((String)"isisfish.common.ok", (Object[])new Object[0]), (Component)inputUI, (String[])new String[]{".*\\.xml", "XML Files"});
            if (exportFile != null) {
                if (!exportFile.getAbsolutePath().endsWith(".xml")) {
                    exportFile = new File(exportFile.getAbsolutePath() + ".xml");
                }
                FisheryRegion fisheryRegion = inputUI.getContextValue(FisheryRegion.class);
                this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.input.sensitivity.export.running", (Object[])new Object[0]), true);
                RegionExplorer explorer = new RegionExplorer();
                RegionExportFactorXML exportXML = new RegionExportFactorXML(exportFile);
                explorer.explore(fisheryRegion, exportXML);
                this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.input.sensitivity.export.complete", (Object[])new Object[0]), true);
            } else {
                this.setStatusMessage((JAXXContext)inputUI, I18n._((String)"isisfish.input.sensitivity.export.cancel", (Object[])new Object[0]), true);
            }
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't export sensitivity factors", eee);
        }
    }

    public void nodeSelectionChanged(InputUI inputUI, TreeSelectionEvent event) {
        Object lastTreePath;
        TreePath newTreePath = event.getNewLeadSelectionPath();
        if (newTreePath != null && (lastTreePath = newTreePath.getLastPathComponent()) instanceof FisheryTreeNode) {
            FisheryTreeNode isisTreeNode = (FisheryTreeNode)((Object)lastTreePath);
            Class internalClass = isisTreeNode.getInternalClass();
            TopiaEntityContextable topiaEntity = null;
            String topiaId = isisTreeNode.getId();
            try {
                if (isisTreeNode.isStaticNode()) {
                    FisheryRegion fisheryRegion = inputUI.getContextValue(FisheryRegion.class);
                    TopiaContext topiaContext = fisheryRegion.getTopiaContext();
                    topiaEntity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                }
                InputContentUI<?> inputContentUI = this.getUIInstanceForBeanClass(internalClass, inputUI);
                inputContentUI.getSaveVerifier().setInputContentUI(inputContentUI);
                inputContentUI.getSaveVerifier().reset();
                if (topiaEntity != null) {
                    inputContentUI.getSaveVerifier().addCurrentEntity(topiaEntity);
                }
                inputContentUI.setBean(topiaEntity);
                inputContentUI.setActive(topiaEntity != null);
                inputUI.getCardlayoutPrincipal().show(inputUI.getInputPanePrincipal(), "normale");
                inputUI.getInputPane().removeAll();
                inputUI.getInputPane().add(inputContentUI, "Center");
                inputUI.getInputPane().repaint();
                inputUI.getInputPane().validate();
            }
            catch (Exception ex) {
                throw new IsisFishRuntimeException("Can't display bean " + topiaId, ex);
            }
        }
    }

    protected InputContentUI<?> getUIInstanceForBeanClass(Class<?> internalClass, NavigationUI navigationUI) throws Exception {
        Class uiClass = null;
        if (FisheryRegion.class.isAssignableFrom(internalClass)) {
            uiClass = FisheryRegionUI.class;
        } else if (Cell.class.isAssignableFrom(internalClass)) {
            uiClass = CellUI.class;
        } else if (Gear.class.isAssignableFrom(internalClass)) {
            uiClass = GearUI.class;
        } else if (Metier.class.isAssignableFrom(internalClass)) {
            uiClass = MetierUI.class;
        } else if (Population.class.isAssignableFrom(internalClass)) {
            uiClass = PopulationUI.class;
        } else if (Port.class.isAssignableFrom(internalClass)) {
            uiClass = PortUI.class;
        } else if (SetOfVessels.class.isAssignableFrom(internalClass)) {
            uiClass = SetOfVesselsUI.class;
        } else if (Species.class.isAssignableFrom(internalClass)) {
            uiClass = SpeciesUI.class;
        } else if (Strategy.class.isAssignableFrom(internalClass)) {
            uiClass = StrategyUI.class;
        } else if (TripType.class.isAssignableFrom(internalClass)) {
            uiClass = TripTypeUI.class;
        } else if (VesselType.class.isAssignableFrom(internalClass)) {
            uiClass = VesselTypeUI.class;
        } else if (Zone.class.isAssignableFrom(internalClass)) {
            uiClass = ZoneUI.class;
        }
        InputContentUI result = this.uiInstanceCache.get(uiClass);
        if (result == null) {
            Constructor constructor = uiClass.getConstructor(JAXXContext.class);
            result = (InputContentUI)constructor.newInstance(navigationUI);
            this.uiInstanceCache.put(uiClass, result);
        }
        return result;
    }

    public void setTreeSelection(InputContentUI<?> inputUI, String nodeId) {
        this.setTreeSelection(inputUI, null, nodeId);
    }

    public void setTreeSelection(InputContentUI<?> inputUI, String parentNodeId, String nodeId) {
        FisheryTreeNode newSelectNode;
        FisheryTreeHelper fisheryTreeHelper = inputUI.getContextValue(FisheryTreeHelper.class);
        TreeModel fisheryTreeModel = inputUI.getContextValue(TreeModel.class);
        FisheryTreeNode fromNode = (FisheryTreeNode)((Object)fisheryTreeModel.getRoot());
        if (parentNodeId != null) {
            fromNode = (FisheryTreeNode)fisheryTreeHelper.findNode((NavNode)fromNode, new String[]{parentNodeId});
        }
        if ((newSelectNode = (FisheryTreeNode)fisheryTreeHelper.findNode((NavNode)fromNode, new String[]{nodeId})) != null) {
            fisheryTreeHelper.selectNode((NavNode)newSelectNode);
        }
    }

    public void deleteTreeNode(InputUI inputUI, String topiaId) {
        FisheryTreeHelper fisheryTreeHelper = inputUI.getContextValue(FisheryTreeHelper.class);
        TreeModel fisheryTreeModel = inputUI.getContextValue(TreeModel.class);
        FisheryTreeNode newSelectNode = (FisheryTreeNode)fisheryTreeHelper.findNode((NavNode)((FisheryTreeNode)((Object)fisheryTreeModel.getRoot())), new String[]{topiaId});
        FisheryTreeNode parentNode = (FisheryTreeNode)newSelectNode.getParent();
        fisheryTreeHelper.selectNode((NavNode)parentNode);
        fisheryTreeHelper.removeNode((NavNode)newSelectNode);
    }

    public void insertTreeNode(InputUI inputUI, Class nodeClass, TopiaEntityContextable topiaEntity) {
        FisheryTreeHelper fisheryTreeHelper = inputUI.getContextValue(FisheryTreeHelper.class);
        FisheryTreeNode selectedNode = (FisheryTreeNode)fisheryTreeHelper.getSelectedNode();
        if (selectedNode.isStaticNode()) {
            selectedNode = (FisheryTreeNode)selectedNode.getParent();
        }
        FisheryTreeNode newNode = new FisheryTreeNode(nodeClass, topiaEntity.getTopiaId(), null, null);
        fisheryTreeHelper.insertNode((NavNode)selectedNode, (NavNode)newNode);
        if (nodeClass.equals(Species.class)) {
            FisheryTreeNode newPopNode = new FisheryTreeNode(Population.class, I18n.n_((String)"isisfish.input.tree.populations", (Object[])new Object[0]), null, new PopulationsNodeLoador((Species)topiaEntity));
            fisheryTreeHelper.insertNode((NavNode)newNode, (NavNode)newPopNode);
        }
        fisheryTreeHelper.selectNode((NavNode)newNode);
    }

    public void updateTreeNode(InputUI inputUI, String topiaId) {
        FisheryTreeHelper fisheryTreeHelper = inputUI.getContextValue(FisheryTreeHelper.class);
        TreeModel fisheryTreeModel = inputUI.getContextValue(TreeModel.class);
        FisheryTreeNode newSelectNode = (FisheryTreeNode)fisheryTreeHelper.findNode((NavNode)((FisheryTreeNode)((Object)fisheryTreeModel.getRoot())), new String[]{topiaId});
        fisheryTreeHelper.refreshNode((NavNode)newSelectNode, false);
    }

    public void accept(InputContentUI<?> inputContentUI, ActionEvent e) {
        JComponent source = (JComponent)e.getSource();
        Class sensitivityBeanClass = (Class)source.getClientProperty("sensitivityBean");
        String sensitivityBeanID = (String)source.getClientProperty("sensitivityBeanID");
        String sensitivityMethod = (String)source.getClientProperty("sensitivityMethod");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event intercepted " + source));
            log.debug((Object)(" client property (bean) : " + sensitivityBeanClass));
            log.debug((Object)(" client property (beanID) : " + sensitivityBeanID));
            log.debug((Object)(" client property (method) : " + sensitivityMethod));
        }
        this.displayFactorWizard(inputContentUI, sensitivityBeanClass, sensitivityBeanID, sensitivityMethod);
    }

    public void displayFactorWizard(InputContentUI<?> inputContentUI, Class<? extends TopiaEntityContextable> sensitivityBeanClass, String sensitivityBeanID, String sensitivityMethod) {
        TopiaEntityContextable bean = null;
        bean = sensitivityBeanID == null ? inputContentUI.getSaveVerifier().getEntity(sensitivityBeanClass) : inputContentUI.getSaveVerifier().getEntity(sensitivityBeanClass, sensitivityBeanID);
        if (bean != null) {
            FactorWizardUI factorWizardUI = new FactorWizardUI((JAXXContext)inputContentUI);
            SensitivityInputHandler handler = factorWizardUI.getHandler();
            handler.initNewFactor(factorWizardUI, bean, sensitivityMethod);
            factorWizardUI.pack();
            factorWizardUI.setLocationRelativeTo(inputContentUI);
            factorWizardUI.setVisible(true);
        } else if (log.isErrorEnabled()) {
            log.error((Object)("Can't find bean in current verifier (sensitivityBeanClass = " + sensitivityBeanClass + ", sensitivityBeanID = " + sensitivityBeanID + ")"));
        }
    }

    public Species findSpecies(InputUI inputUI) {
        FisheryTreeHelper treeHelper = inputUI.getContextValue(FisheryTreeHelper.class);
        FisheryTreeNode selectedNode = (FisheryTreeNode)treeHelper.getSelectedNode();
        if (selectedNode == null) {
            throw new IsisFishRuntimeException("Not selected tree node");
        }
        String speciesId = null;
        FisheryTreeNode parentNode = (FisheryTreeNode)selectedNode.getParent();
        if (parentNode.getInternalClass().equals(Species.class)) {
            speciesId = parentNode.getId();
        } else if (((FisheryTreeNode)parentNode.getParent()).getInternalClass().equals(Species.class)) {
            speciesId = ((FisheryTreeNode)parentNode.getParent()).getId();
        } else {
            throw new IsisFishRuntimeException("Not selected tree node");
        }
        TopiaContext topiaContext = inputUI.getContextValue(TopiaContext.class);
        Species result = null;
        try {
            SpeciesDAO dao = IsisFishDAOHelper.getSpeciesDAO(topiaContext);
            result = (Species)dao.findByTopiaId(speciesId);
        }
        catch (TopiaException e) {
            throw new IsisFishRuntimeException("Can't find ");
        }
        return result;
    }
}

