/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.IsisMapBean;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputHandler;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.input.InputTabbedPaneListener;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUtils;
import fr.ifremer.isisfish.ui.sensitivity.TableBlockingLayerUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.BlockingLayerUI2;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public abstract class InputContentUI<B extends TopiaEntityContextable>
extends JPanel
implements JAXXObject {
    public static final String PROPERTY_ACTIVE = "active";
    public static final String PROPERTY_BUTTON_TITLE = "buttonTitle";
    public static final String PROPERTY_NEXT_PATH = "nextPath";
    public static final String PROPERTY_SENSITIVITY = "sensitivity";
    public static final String BINDING_NEXT_TEXT = "next.text";
    public static final String BINDING_NEXT_VISIBLE = "next.visible";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVkp/gYJEggoJijExxq2ihgNGgRpCSVUikBB7cbo70MHp7DgzC9uL8U/wT9C7FxNvnowHzx68GP8FYzx4Nb7Z3XZbbWkTepjdznzfN997+957+wOllEQX9rHvW9LjmtaJtb68s/Oouk9sfZ8oW1KhXYnCXyKJkhWUd1r7SqO5StnQCxG9UHTrwuWEt7EXyyindIMRVSNEazTTybCVKmy2jhd94cmmastUN9XXv34mXzkv3yQR8gW4y0Mos/1YcSRDZZSkjkan4aYDXGCY74ENSfke+B01e0WGlXqI6+Q5eoHSZTQssAQxjS4OHnKgEfB9oVHm0voG5oRd1+jqrrToriR1Ak9F1S5VNcujFuXC01bJrEWXa1DdLgkRSAxrlK5h7jAiNbrSn78WYmP2MLY1PSAajZvwLBOyteK6jGAeg/KKcEUBR3XDbI23HVU9rV2+RTUDkbFYJMxbDMxw4usNrGvm/2SbfYYbRG6XIIUdH0odUmOFufYzeCmHoDa5iDYP5dafNx8TRzSuMlJuXrrQI2dtEVtbhtHTyVDVdRpQMyZ0P7o+/KQGkI1xJgEaTXTgVoLsRUCJzneEAl1gxV0Ql2miglLSg22Npir/N85jOApbZuqfljGCwemfyYmvH76/X232SQbuPtMV2tbmUL9CugIqjZqrT4VN4mnKCg+wWKygrCIMZkQwA6a7GNuMjsEc3BcWnKFba1jVQCKV/vbx0+TTLydQchXlmIudVWzwJZTVNQlZcJnji3tLgaORwwysY8YbVDFUgwupRCfvOFjj2SrlDuT3rg9JmO6ShJaTavbz74nNd0vNRCTA2Nme8DgZqSdomHJGOQlGRjQNuo6IvFDEc9y467vNgYR55kRUVdeC9Ua3SEerUR0WXeZKA7vle+ZxO3Bv3hYCsXMDiI1g2yZCL8MICIuwh9bMAFq5UKtkH1spG4R4bCGzffMIhbkBrAxp6NkjNC4PoJE+gLkCA6SPzF+Rqg4beQcAAA==";
    private static final Log log = LogFactory.getLog(InputContentUI.class);
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected Boolean active;
    protected JPanel body;
    protected String buttonTitle;
    protected InputHandler handler;
    protected BlockingLayerUI layerUI;
    protected BlockingLayerUI2 layerUI2;
    protected JButton next;
    protected String nextPath;
    protected Boolean sensitivity;
    protected TableBlockingLayerUI tableLayerUI;
    private InputContentUI<B> $JPanel0 = this;

    public abstract void setBean(B var1);

    public abstract B getBean();

    public void resetChangeModel() {
    }

    public InputAction getAction() {
        return this.getContextValue(InputAction.class);
    }

    public InputSaveVerifier getSaveVerifier() {
        return this.getContextValue(InputSaveVerifier.class);
    }

    public FisheryRegion getFisheryRegion() {
        return this.getContextValue(FisheryRegion.class);
    }

    public TopiaContext getTopiaContext() {
        return this.getContextValue(TopiaContext.class);
    }

    public void setInfoText(String msg) {
        WelcomePanelUI root = this.getParentContainer(WelcomePanelUI.class);
        if (root != null) {
            root.setStatusMessage(msg);
        }
    }

    protected void goTo() {
        InputUI inputUI = this.getParentContainer(InputUI.class);
        if (inputUI != null) {
            inputUI.getHandler().setTreeSelection(this, this.nextPath);
        }
    }

    protected void refreshRegionInMap(IsisMapBean map) {
        FisheryRegion fisheryRegion = map.getFisheryRegion();
        FisheryRegion regionFromContext = this.getFisheryRegion();
        if (fisheryRegion == null || !fisheryRegion.equals(regionFromContext)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Use now " + regionFromContext + " in map " + (Object)((Object)map)));
            }
            map.setFisheryRegion(regionFromContext);
        }
    }

    public void setLayer(boolean active) {
        if (this.get$objectMap() != null) {
            for (JComponent boxed : SwingUtil.getLayeredComponents((JAXXObject)this)) {
                BlockingLayerUI2 ui;
                Class sensitivityBeanClass = (Class)boxed.getClientProperty("sensitivityBean");
                String method = (String)boxed.getClientProperty("sensitivityMethod");
                boolean isSensitivityFactorEnabled = false;
                if (sensitivityBeanClass != null) {
                    String className = sensitivityBeanClass.getSimpleName().replace("Impl", "");
                    method = StringUtils.uncapitalize((String)method);
                    String sensitivityFactorName = className + "." + method;
                    isSensitivityFactorEnabled = SensitivityUtils.isSensitivityFactorEnabled(sensitivityFactorName);
                }
                if (isSensitivityFactorEnabled) {
                    ui = this.getLayerUI2().clone();
                    SwingUtil.getLayer((JComponent)boxed).setUI((LayerUI)ui);
                    continue;
                }
                if (boxed instanceof JTable) {
                    SwingUtil.getLayer((JComponent)boxed).setUI((LayerUI)this.getTableLayerUI());
                    continue;
                }
                ui = this.getLayerUI().clone();
                ui.setBlock(true);
                ui.setUseIcon(this.isActive().booleanValue());
                SwingUtil.getLayer((JComponent)boxed).setUI((LayerUI)ui);
            }
        }
    }

    protected void installChangeListener(JTabbedPane tabbedPane) {
        if (!this.isSensitivity().booleanValue()) {
            InputTabbedPaneListener tabbedPaneChangeListener = new InputTabbedPaneListener();
            tabbedPane.addChangeListener(tabbedPaneChangeListener);
        }
    }

    public InputContentUI(LayoutManager param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public InputContentUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1, param2);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public InputContentUI(LayoutManager param0) {
        super(param0);
        this.$initialize();
    }

    public InputContentUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public InputContentUI(boolean param0) {
        super(param0);
        this.$initialize();
    }

    public InputContentUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public InputContentUI() {
        this.$initialize();
    }

    public InputContentUI(JAXXContext parentContext) {
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public void applyDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.getDataBinding($binding).applyDataBinding();
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public JAXXBinding getDataBinding(String bindingId) {
        return this.$bindings.get(bindingId);
    }

    public JAXXBinding[] getDataBindings() {
        return this.$bindings.values().toArray(new JAXXBinding[this.$bindings.size()]);
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && this.$activeBindings.contains($binding)) {
            return;
        }
        this.$activeBindings.add($binding);
        try {
            if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
                this.getDataBinding($binding).processDataBinding();
            }
        }
        finally {
            this.$activeBindings.remove($binding);
        }
    }

    public void processDataBinding(String $binding) {
        this.processDataBinding($binding, false);
    }

    public void registerDataBinding(JAXXBinding binding) {
        this.$bindings.put(binding.getId(), binding);
    }

    public void removeDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.getDataBinding($binding).removeDataBinding();
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)this, clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.goTo();
    }

    public Boolean getActive() {
        return this.active;
    }

    public JPanel getBody() {
        return this.body;
    }

    public String getButtonTitle() {
        return this.buttonTitle;
    }

    public InputHandler getHandler() {
        return this.handler;
    }

    public BlockingLayerUI getLayerUI() {
        return this.layerUI;
    }

    public BlockingLayerUI2 getLayerUI2() {
        return this.layerUI2;
    }

    public JButton getNext() {
        return this.next;
    }

    public String getNextPath() {
        return this.nextPath;
    }

    public Boolean getSensitivity() {
        return this.sensitivity;
    }

    public TableBlockingLayerUI getTableLayerUI() {
        return this.tableLayerUI;
    }

    public Boolean isActive() {
        return this.active != null && this.active != false;
    }

    public Boolean isSensitivity() {
        return this.sensitivity != null && this.sensitivity != false;
    }

    public void setActive(Boolean active) {
        Boolean oldValue = this.active;
        this.active = active;
        this.firePropertyChange(PROPERTY_ACTIVE, oldValue, active);
    }

    public void setButtonTitle(String buttonTitle) {
        String oldValue = this.buttonTitle;
        this.buttonTitle = buttonTitle;
        this.firePropertyChange(PROPERTY_BUTTON_TITLE, oldValue, buttonTitle);
    }

    public void setNextPath(String nextPath) {
        String oldValue = this.nextPath;
        this.nextPath = nextPath;
        this.firePropertyChange(PROPERTY_NEXT_PATH, oldValue, nextPath);
    }

    public void setSensitivity(Boolean sensitivity) {
        Boolean oldValue = this.sensitivity;
        this.sensitivity = sensitivity;
        this.firePropertyChange(PROPERTY_SENSITIVITY, oldValue, sensitivity);
    }

    protected void createActive() {
        this.active = false;
        this.$objectMap.put(PROPERTY_ACTIVE, this.active);
    }

    protected void createBody() {
        this.body = new JPanel();
        this.$objectMap.put("body", this.body);
        this.body.setName("body");
        this.body.setLayout(new BorderLayout());
    }

    protected void createButtonTitle() {
        this.buttonTitle = null;
        this.$objectMap.put(PROPERTY_BUTTON_TITLE, null);
    }

    protected void createHandler() {
        this.handler = new InputHandler();
        this.$objectMap.put("handler", this.handler);
    }

    protected void createLayerUI() {
        this.layerUI = new BlockingLayerUI();
        this.$objectMap.put("layerUI", this.layerUI);
    }

    protected void createLayerUI2() {
        this.layerUI2 = new BlockingLayerUI2();
        this.$objectMap.put("layerUI2", this.layerUI2);
    }

    protected void createNext() {
        this.next = new JButton();
        this.$objectMap.put("next", this.next);
        this.next.setName("next");
        this.next.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__next"));
    }

    protected void createNextPath() {
        this.nextPath = null;
        this.$objectMap.put(PROPERTY_NEXT_PATH, null);
    }

    protected void createSensitivity() {
        this.sensitivity = false;
        this.$objectMap.put(PROPERTY_SENSITIVITY, this.sensitivity);
    }

    protected void createTableLayerUI() {
        this.tableLayerUI = new TableBlockingLayerUI(this);
        this.$objectMap.put("tableLayerUI", (Object)this.tableLayerUI);
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.add((Component)this.body, "Center");
        this.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.next), "South");
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.layerUI.setBlockingColor(new Color(25, 25, 25));
        this.layerUI2.setAcceptAction((Action)new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                InputContentUI.this.getHandler().accept(InputContentUI.this, e);
            }
        });
        this.layerUI2.setAcceptIcon(SwingUtil.createImageIcon((String)"building_add.png"));
        this.layerUI2.setBlockIcon(SwingUtil.createImageIcon((String)"building.png"));
    }

    private void $initialize() {
        if (this.allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.$objectMap.put("$JPanel0", this.$JPanel0);
        this.createHandler();
        this.createActive();
        this.createSensitivity();
        this.createButtonTitle();
        this.createNextPath();
        this.createLayerUI();
        this.createLayerUI2();
        this.createTableLayerUI();
        this.createBody();
        this.createNext();
        this.setName("$JPanel0");
        this.setLayout(new BorderLayout());
        this.$registerDefaultBindings();
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_NEXT_TEXT, true, new String[]{PROPERTY_BUTTON_TITLE}){

            public void processDataBinding() {
                InputContentUI.this.next.setText(I18n._((String)InputContentUI.this.getButtonTitle(), (Object[])new Object[0]));
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_NEXT_VISIBLE, true, new String[]{PROPERTY_BUTTON_TITLE}){

            public void processDataBinding() {
                InputContentUI.this.next.setVisible(InputContentUI.this.getButtonTitle() != null);
            }
        });
    }
}

