/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity.domain;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.DomainVisitor;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class DiscreteDomain
implements Domain {
    private static final long serialVersionUID = -192647757737396585L;
    protected SortedMap<Object, Object> values = new TreeMap<Object, Object>();

    public SortedMap<Object, Object> getValues() {
        return this.values;
    }

    public void setValues(SortedMap<Object, Object> values) {
        this.values = values;
    }

    @Override
    public Object getValueForIdentifier(Object identifier) throws IllegalArgumentException {
        if (this.values == null || !this.values.containsKey(identifier)) {
            throw new IllegalArgumentException("Can't get value for identifier " + identifier);
        }
        return this.values.get(identifier);
    }

    @Override
    public void accept(DomainVisitor visitor) {
        visitor.start(this);
        for (Map.Entry<Object, Object> value : this.values.entrySet()) {
            visitor.visit(this, value.getKey(), value.getValue());
        }
        visitor.end(this);
    }

    @Override
    public DiscreteDomain clone() {
        DiscreteDomain cloned = null;
        try {
            cloned = (DiscreteDomain)super.clone();
            cloned.setValues(new TreeMap<Object, Object>(this.values));
        }
        catch (CloneNotSupportedException e) {
            throw new IsisFishRuntimeException("Can't clone domain", e);
        }
        return cloned;
    }
}

