/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import fr.ifremer.isisfish.map.Scale;

public class DefaultScale
implements Scale {
    private static final long serialVersionUID = -3348731042237607596L;
    public double min;
    public double max;

    public DefaultScale(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public DefaultScale(double max) {
        this(0.0, max);
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double v) {
        this.min = v;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double v) {
        this.max = v;
    }

    @Override
    public double getValueAsScale(double value) {
        return value / (this.max - this.min);
    }

    @Override
    public int getValueAsRGB(double value) {
        return (int)(value / (this.getMax() / 255.0));
    }

    @Override
    public double getValueAsSqrtScale(double value) {
        double scale = this.getValueAsScale(value);
        if (scale < 0.0) {
            return 0.0;
        }
        return Math.sqrt(scale);
    }
}

