/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Trace;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.aspectwerkz.annotation.Around;
import org.codehaus.aspectwerkz.annotation.Aspect;
import org.codehaus.aspectwerkz.annotation.Expression;
import org.codehaus.aspectwerkz.definition.Pointcut;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MethodRtti;
import org.codehaus.aspectwerkz.joinpoint.MethodSignature;

@Aspect(value="perJVM")
public class Cache {
    private static Log log = LogFactory.getLog(Cache.class);
    private static List<Cache> instances = new ArrayList<Cache>();
    protected long totalCall = 0L;
    protected long cacheUsed = 0L;
    protected Map cache = new ReferenceMap(0, 1);
    @Expression(value="execution(* scripts..*(..))")
    Pointcut scriptsMethod;

    public Cache() {
        instances.add(this);
    }

    protected Trace getTrace() {
        SimulationContext context = SimulationContext.get();
        Trace result = (Trace)context.getValue(Trace.class.getName());
        if (result == null) {
            throw new IsisFishRuntimeException("No trace object found in context");
        }
        return result;
    }

    @Around(value="scriptsMethod")
    public Object call(JoinPoint jp) throws Throwable {
        ++this.totalCall;
        Object key = this.computeKey(jp);
        Object result = this.cache.get(key);
        if (result == null) {
            result = this.realCall(jp);
            if (result != null) {
                this.cache.put(key, result);
            }
        } else {
            ++this.cacheUsed;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(((MethodSignature)jp.getSignature()).getMethod() + " args " + Arrays.toString(((MethodRtti)jp.getRtti()).getParameterValues()) + " result = " + result));
        }
        return result;
    }

    protected Object realCall(JoinPoint jp) throws Throwable {
        Object result = jp.proceed();
        return result;
    }

    protected Object computeKey(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        Object[] args = ((MethodRtti)jp.getRtti()).getParameterValues();
        String result = method.toString();
        for (Object o : args) {
            result = result + ";";
            result = o instanceof Number || o instanceof String ? result + o.toString() : result + ObjectUtils.identityToString((Object)o);
        }
        return result;
    }

    public static long getCacheUsed() {
        long result = 0L;
        for (Cache cache : instances) {
            result += cache.cacheUsed;
        }
        return result;
    }

    public static long getTotalCall() {
        long result = 0L;
        for (Cache cache : instances) {
            result += cache.totalCall;
        }
        return result;
    }

    public static String printStatistiqueAndClear() {
        StringBuffer result = new StringBuffer();
        for (Cache cache : instances) {
            result.append("--- Cache Statistiques ---\n");
            result.append("Total call: " + cache.totalCall + "\n");
            result.append("Cache used: " + cache.cacheUsed + "\n");
            result.append("Cache usage: " + 100L * cache.cacheUsed / cache.totalCall + "%" + "\n");
            result.append("--------------------\n");
            cache.cache.clear();
        }
        System.out.println(result.toString());
        instances.clear();
        return result.toString();
    }

    class AdaptaptativeCache
    extends LinkedHashMap<String, Object> {
        protected int maxMemory;

        public AdaptaptativeCache(int capacity, int maxMemory) {
            super(capacity, 0.75f, true);
            this.maxMemory = 95;
            this.maxMemory = maxMemory;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
            double free = 100.0 * (double)Runtime.getRuntime().freeMemory() / (double)Runtime.getRuntime().maxMemory();
            boolean result = 100.0 - free > (double)this.maxMemory;
            return result;
        }
    }
}

