<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<!--
  #%L
  IsisFish
  
  $Id: isis-fish-0_1.3.1.xsl 3124 2010-11-29 18:14:09Z chatellier $
  $HeadURL$
  %%
  Copyright (C) 1999 - 2010 CodeLutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 2 of the 
  License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public 
  License along with this program.  If not, see
  <http://www.gnu.org/licenses/gpl-2.0.html>.
  #L%
  -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

  <!-- Carbon copy as default -->
  <xsl:template match="child::node()|attribute::*" priority="-10">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>

  <!-- modification de la version du fichier -->
  <xsl:template match="/dbobjects">
    <xsl:copy>
      <xsl:attribute name="version">1.3.1</xsl:attribute>
      <xsl:apply-templates select="child::node()"/>
   </xsl:copy>
  </xsl:template>

  <!-- modification de l'element list en dbobjects -->
  <xsl:template match="/list">
    <dbobjects>
      <xsl:attribute name="version">1.2.3</xsl:attribute>
      <xsl:apply-templates select="child::node()"/>
   </dbobjects>
  </xsl:template>





  <!-- Rename attribute equationConversion to croissance in Population object -->
  <xsl:template match="attribute::name[(.='equationConversion') and (../../@type='Population')]">
    <xsl:attribute name="name">croissance</xsl:attribute>
        <xsl:apply-templates select="child::node()"/>
  </xsl:template>

  <!-- Add attribute inverseCroissance in Population object and value it to the content of equationConversion -->
  <xsl:template match="dbobject[@type='Population']">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:element name="attribute">
            <xsl:attribute name="name">inverseCroissance</xsl:attribute>
            <xsl:value-of select="attribute[@name='equationConversion']"/>
        </xsl:element>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>

  <!-- Rename attribute longueur to longueurMin in ClassePopulation object -->
  <xsl:template match="attribute::name[(.='longueur') and (../../@type='ClassePopulation')]">
    <xsl:attribute name="name">longueurMin</xsl:attribute>
        <xsl:apply-templates select="child::node()"/>
  </xsl:template>

  <!-- Add attribute longueurMax in ClassePopulation object and value it to the content of longueur -->
  <xsl:template match="dbobject[@type='ClassePopulation']">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:element name="attribute">
            <xsl:attribute name="name">longueurMax</xsl:attribute>
            <xsl:value-of select="attribute[@name='longueur']"/>
        </xsl:element>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>

    <!-- Remove attribute parametreContinue in Engin object -->
  <xsl:template match="attribute[(@name='parametreContinue') and (../@type='Engin')]">
  </xsl:template>

  <!-- Remove attribute parametreQuantifiable in Engin object -->
  <xsl:template match="attribute[(@name='parametreQuantifiable') and (../@type='Engin')]">
  </xsl:template>

  <!-- On met les equations en xml dans les formules -->
  <xsl:template match="attribute[(@name='equation') and (../@type='Formule')]">
    <xsl:copy>
      <xsl:apply-templates select="attribute::*"/>

      <xsl:variable name="id">
        <xsl:value-of select="text()"/>
      </xsl:variable>
      <xsl:text>&lt;equation name="</xsl:text>
      <xsl:value-of select="../attribute[(@name='nom')]/text()"/>
      <xsl:text>"&gt;&lt;![CDATA[</xsl:text>
      <xsl:value-of select="text()"/>
      <xsl:text>]]&gt;&lt;/equation&gt;</xsl:text>
    </xsl:copy>
  </xsl:template>


  <!-- Add attribute matriceChangementLongueurSimple in InfoSaisonPop object and value it to false -->
  <xsl:template match="dbobject[@type='InfoSaisonPop']">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:element name="attribute">
            <xsl:attribute name="name">matriceChangementLongueurSimple</xsl:attribute>
            <xsl:text>false</xsl:text>
        </xsl:element>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>


</xsl:stylesheet>
