/*
 * #%L
 * IsisFish
 * 
 * $Id: IDialog.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.util;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import java.awt.Dimension;

public interface IDialog {
    /**
     * @return the ok button (jaxx generated)
     */
    JButton getOk();

    /**
     * @return the cancel button (jaxx generated)
     */
    JButton getCancel();

    /**
     * to doRefresh dialog (use processDataBinding)
     */
    void doRefresh();

    /**
     * @return <code>true</code> if ok button is enabled, <code>false</code>
     *         otherwise
     */
    boolean isOkEnabled();

    /**
     * @return <code>true</code> if dialog has no data, <code>false</code>
     *         otherwise
     */
    boolean isEmpty();

    int computeWidth();

    int computeHeight();

    // ------------------ JDialog methods
    void setVisible(boolean b);

    void setSize(int width, int height);

    void setMaximumSize(Dimension dimension);

    void setOkAction(AbstractAction okAction);

    void setCancelAction(AbstractAction cancelAction);

    void setMaxWidth(int maxWidth);

    void setMinHeight(int minHeight);

    void setMaxHeight(int maxHeight);

    void repaint();

    void setTitle(String s);
}
