/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableModel;
import fr.ifremer.isisfish.ui.models.simulationplan.SimulationPlanComboModel;
import fr.ifremer.isisfish.ui.models.simulationplan.SimulationPlanComboRenderer;
import fr.ifremer.isisfish.ui.models.simulationplan.SimulationPlanListModel;
import fr.ifremer.isisfish.ui.models.simulationplan.SimulationPlanListRenderer;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SensUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SIMUL_ACTION = "simulAction";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Vz08TQRTHp5VSSkGRCoJC5Kd6MFswakwgyA9DkBQlVBOkB512p3TI7A9nZmH1YPwT/BP07sXEmyfjwbMHL8Z/wRgPXo1vpmXL6tI2qT10m3nz/bwf+97rm+8oITga38O+b3DPltQixvrS9va94h4pydtElDh1pcNR9ROLo3gBpc3gXEg0WcgpebYmz644luvYxD6insuhbiGfMiIqhEiJRsOKkhDZfGCe812PH1KDoKKor37+iL80X7yOI+S7EF0PpDLWTFXPpCOH4tSUqB887eMsw/YuhMGpvQvx9qqzFYaFuIst8gQ9R8kc6nQxB5hEE62nrBla77sSJafu4yIjMxJdKnODljmxCDwFFWUqKoZHDUEtj2EgGHliiwd3XFerOyVKa9NSSVLHluhKc339eh0yXaaEmdq0iTm2RL56Hy5tQgVEnjB48RINqPx9QxxAOYx1SLDoLDu+gqQCVu/Uer7EHQYkW6V0NqSpm8KqCUaFPD6AHFglOh1CqTOl7g8gtTrOSjQUeuFVgbaFvU4WPSkd+3i/Sya0QibkdllLFGAo4FxsxtkilrOvnY+GldPNlCuMYB4hDJV5Vh2eCed2ThzLhO4OpRRUZiJQp6Zqic4EvgHN0flQYWFGjfqM1ocoVkAJ7sExvInCv2O9BabqQA/9NdAKqK2/BzNf3n97t3o4xX3geyDy6pElBNPlcsclXFLl+lR1hD1JWXYDu3MFlBK6kfWGGokILF8zQ3DgT7eboeTGGhYVQCSSXz98HHz8+QSKr6Ju5mBzFav7d1BKVjhUwWGm795a1BH1HHSpwFVsEiUsxyRMopPzJpZ4rEhtE0q/4EMNRiJqEARSTH36lcm/XTysQwziGj72er0WiR3USW1GbaL3WW1VRe6vtCuIZzr1lRS1pGLq2efWVoahv69GJdoFu9AknOieve576nFDB65+3WyZk7aoDV1r5ekz0gCVaQHV63JSJpwT8z/AekqEsa3mOQ42Zanja20RILVqQ8Ngb0B/tQnrsKEpYDfMVxtnDEv434P9RBaimcOtMCXx9ZbeiWaMtMBIElstKLMB5kJL1X7UNqFRDONtx9Aa4WEDwnQL5Uxx52CN0N1Ko/fSHNQsmctA+AMGYFoISgoAAA==";
    private static final Log log = LogFactory.getLog(SensUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton buttonSimulParamsSimulationPlansAdd;
    protected JButton buttonSimulParamsSimulationPlansClear;
    protected JButton buttonSimulParamsSimulationPlansRemove;
    protected JComboBox fieldSimulParamsSimulationPlansSelect;
    protected JList listSimulParamsSimulationPlansList;
    protected SimulAction simulAction;
    protected JTable simulParamsSimulationPlans;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SensUI $Table0 = this;
    private JScrollPane $JScrollPane0;
    private Table $Table1;
    private JScrollPane $JScrollPane1;
    private JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    // to be notified of storage change event
        StorageChangeListener simulationPlanStorageListener;
    
        
        protected void $afterCompleteSetup() {
            simulationPlanStorageListener = new StorageChangeListener() {
                @Override
                public void versionDataChanged(StorageChangeEvent e) {
                    refresh();
                }
            };
            SimulationPlanStorage.addStorageChangeListener(simulationPlanStorageListener);
        }
    
        public void refresh() {
            // simulation plans names list
            fieldSimulParamsSimulationPlansSelect.setModel(getSimulationPlansComboModel());
            // simulation simulation plans instance
            listSimulParamsSimulationPlansList.setModel(getSimulationSimulationPlansListModel());
        }
    
        /**
         * Refresh simulation plan names list.
         */
        protected SimulationPlanComboModel getSimulationPlansComboModel() {
            List<String> simulationPlanNames = simulAction.getSimulationPlanNames();
            SimulationPlanComboModel model = new SimulationPlanComboModel(simulationPlanNames);
            return model;
        }
        
        /**
         * Refresh simulation simulation plan list.
         */
        protected SimulationPlanListModel getSimulationSimulationPlansListModel() {
            List<SimulationPlan> simulationPlans = simulAction.getParamSimulationPlans();
            SimulationPlanListModel model = new SimulationPlanListModel(simulationPlans);
            return model;
        }
    
        protected void addSimulationPlan() {
            String selectedSimulationPlanName = (String)fieldSimulParamsSimulationPlansSelect.getSelectedItem();
            simulAction.addSimulationPlan(this, selectedSimulationPlanName);
            listSimulParamsSimulationPlansList.setModel(getSimulationSimulationPlansListModel());
            setSimulationPlanButtons();
        }
        
        protected void removeSimulationPlan() {
            SimulationPlan selectedSimulationPlan = (SimulationPlan)listSimulParamsSimulationPlansList.getSelectedValue();
            simulAction.removeSimulationPlan(selectedSimulationPlan);
            listSimulParamsSimulationPlansList.setModel(getSimulationSimulationPlansListModel());
            setSimulationPlanButtons();
        }
        
        protected void clearSimulationPlan() {
            simulAction.clearSimulationPlans();
            listSimulParamsSimulationPlansList.setModel(getSimulationSimulationPlansListModel());
            setSimulationPlanButtons();
        }
        
        protected void setSimulationPlanButtons() {
            if (getContextValue(SimulAction.class).getParamSimulationPlans().isEmpty()) {
                buttonSimulParamsSimulationPlansClear.setEnabled(false);
                buttonSimulParamsSimulationPlansRemove.setEnabled(false);
            }
            else {
                if (listSimulParamsSimulationPlansList.getSelectedIndex() != -1) {
                    buttonSimulParamsSimulationPlansRemove.setEnabled(true);
                }
                else {
                    buttonSimulParamsSimulationPlansRemove.setEnabled(false);
                }
                buttonSimulParamsSimulationPlansClear.setEnabled(true);
            }
            setSimulParamsSimulationPlans();
        }
        
        protected void setSimulParamsSimulationPlans() {
            SimulationPlan selectedSimulationPlan = (SimulationPlan)listSimulParamsSimulationPlansList.getSelectedValue();
            if (selectedSimulationPlan != null) {
                ScriptParametersTableModel model = new ScriptParametersTableModel(selectedSimulationPlan);
                simulParamsSimulationPlans.setModel(model);
                ScriptParametersTableCellEditor cellEditor = new ScriptParametersTableCellEditor(selectedSimulationPlan);
                cellEditor.setRegionStorage(getContextValue(RegionStorage.class));
                simulParamsSimulationPlans.getColumnModel().getColumn(0).setCellRenderer(new ScriptParametersTableCellRenderer(selectedSimulationPlan));
                simulParamsSimulationPlans.getColumnModel().getColumn(1).setCellEditor(cellEditor);
            }
            else {
                // clear table
                simulParamsSimulationPlans.setModel(new DefaultTableModel());
            }
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SensUI() {
        $initialize();
    }

    public SensUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getParentContainer(fr.ifremer.isisfish.ui.SimulationUI.class).selectParametersTab();
    }

    public void doActionPerformed__on__buttonSimulParamsSimulationPlansAdd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addSimulationPlan();
    }

    public void doActionPerformed__on__buttonSimulParamsSimulationPlansClear(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        clearSimulationPlan();
    }

    public void doActionPerformed__on__buttonSimulParamsSimulationPlansRemove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeSimulationPlan();
    }

    public void doValueChanged__on__listSimulParamsSimulationPlansList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSimulationPlanButtons();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getButtonSimulParamsSimulationPlansAdd() {
        return buttonSimulParamsSimulationPlansAdd;
    }

    public JButton getButtonSimulParamsSimulationPlansClear() {
        return buttonSimulParamsSimulationPlansClear;
    }

    public JButton getButtonSimulParamsSimulationPlansRemove() {
        return buttonSimulParamsSimulationPlansRemove;
    }

    public JComboBox getFieldSimulParamsSimulationPlansSelect() {
        return fieldSimulParamsSimulationPlansSelect;
    }

    public JList getListSimulParamsSimulationPlansList() {
        return listSimulParamsSimulationPlansList;
    }

    public SimulAction getSimulAction() {
        return simulAction;
    }

    public JTable getSimulParamsSimulationPlans() {
        return simulParamsSimulationPlans;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSimulAction(SimulAction simulAction) {
        SimulAction oldValue = this.simulAction;
        this.simulAction = simulAction;
        firePropertyChange(PROPERTY_SIMUL_ACTION, oldValue, simulAction);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createButtonSimulParamsSimulationPlansAdd() {
        $objectMap.put("buttonSimulParamsSimulationPlansAdd", buttonSimulParamsSimulationPlansAdd = new JButton());
        
        buttonSimulParamsSimulationPlansAdd.setName("buttonSimulParamsSimulationPlansAdd");
        buttonSimulParamsSimulationPlansAdd.setText(_("isisfish.common.add"));
        buttonSimulParamsSimulationPlansAdd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonSimulParamsSimulationPlansAdd"));
    }

    protected void createButtonSimulParamsSimulationPlansClear() {
        $objectMap.put("buttonSimulParamsSimulationPlansClear", buttonSimulParamsSimulationPlansClear = new JButton());
        
        buttonSimulParamsSimulationPlansClear.setName("buttonSimulParamsSimulationPlansClear");
        buttonSimulParamsSimulationPlansClear.setEnabled(false);
        buttonSimulParamsSimulationPlansClear.setText(_("isisfish.common.clear"));
        buttonSimulParamsSimulationPlansClear.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonSimulParamsSimulationPlansClear"));
    }

    protected void createButtonSimulParamsSimulationPlansRemove() {
        $objectMap.put("buttonSimulParamsSimulationPlansRemove", buttonSimulParamsSimulationPlansRemove = new JButton());
        
        buttonSimulParamsSimulationPlansRemove.setName("buttonSimulParamsSimulationPlansRemove");
        buttonSimulParamsSimulationPlansRemove.setEnabled(false);
        buttonSimulParamsSimulationPlansRemove.setText(_("isisfish.common.remove"));
        buttonSimulParamsSimulationPlansRemove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonSimulParamsSimulationPlansRemove"));
    }

    protected void createFieldSimulParamsSimulationPlansSelect() {
        $objectMap.put("fieldSimulParamsSimulationPlansSelect", fieldSimulParamsSimulationPlansSelect = new JComboBox());
        
        fieldSimulParamsSimulationPlansSelect.setName("fieldSimulParamsSimulationPlansSelect");
    }

    protected void createListSimulParamsSimulationPlansList() {
        $objectMap.put("listSimulParamsSimulationPlansList", listSimulParamsSimulationPlansList = new JList());
        
        listSimulParamsSimulationPlansList.setName("listSimulParamsSimulationPlansList");
        listSimulParamsSimulationPlansList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__listSimulParamsSimulationPlansList"));
    }

    protected void createSimulAction() {
        $objectMap.put("simulAction", simulAction = getContextValue(SimulAction.class));
    }

    protected void createSimulParamsSimulationPlans() {
        $objectMap.put("simulParamsSimulationPlans", simulParamsSimulationPlans = new JTable());
        
        simulParamsSimulationPlans.setName("simulParamsSimulationPlans");
        simulParamsSimulationPlans.setName("isisfish.sens.planParameters");
        simulParamsSimulationPlans.setRowHeight(24);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(fieldSimulParamsSimulationPlansSelect, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table1, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(listSimulParamsSimulationPlansList);
        // inline complete setup of $Table1
        $Table1.add(buttonSimulParamsSimulationPlansAdd, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(buttonSimulParamsSimulationPlansRemove, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(buttonSimulParamsSimulationPlansClear, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(simulParamsSimulationPlans);
        
        // apply 7 property setters
        fieldSimulParamsSimulationPlansSelect.setModel(getSimulationPlansComboModel());
        fieldSimulParamsSimulationPlansSelect.setRenderer(new SimulationPlanComboRenderer());
        $JScrollPane0.setMinimumSize(new Dimension(0,0));
        $JScrollPane0.setPreferredSize(new Dimension(0,0));
        listSimulParamsSimulationPlansList.setCellRenderer(new SimulationPlanListRenderer());
        listSimulParamsSimulationPlansList.setModel(getSimulationSimulationPlansListModel());
        listSimulParamsSimulationPlansList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createSimulAction();
        createFieldSimulParamsSimulationPlansSelect();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createListSimulParamsSimulationPlansList();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        $Table1.setName("isisfish.sens.title");
        createButtonSimulParamsSimulationPlansAdd();
        createButtonSimulParamsSimulationPlansRemove();
        createButtonSimulParamsSimulationPlansClear();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createSimulParamsSimulationPlans();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("isisfish.sens.backParameter"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}