/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationPlanComboModel.java 3445 2011-07-15 13:12:45Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.simulationplan;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

/**
 * Model pour la liste des plans de simulation.
 *
 * @author chatellier
 * @version $Revision: 3445 $
 * 
 * Last update : $Date: 2011-07-15 15:12:45 +0200 (Fri, 15 Jul 2011) $
 * By : $Author: chatellier $
 */
public class SimulationPlanComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** Analyze plan names. */
    protected List<String> simulationPlanNames;

    /**
     * Empty constructor.
     */
    public SimulationPlanComboModel() {
        this(null);
    }

    /**
     * Constructor with simulation plans list.
     * 
     * @param simulationPlanNames simulation names
     */
    public SimulationPlanComboModel(List<String> simulationPlanNames) {
        setSimulationPlanNames(simulationPlanNames);
    }

    /**
     * Get simulation plan names.
     * 
     * @return the simulation plan names
     */
    public List<String> getSimulationPlanNames() {
        return simulationPlanNames;
    }

    /**
     * Set simulation plan names.
     * 
     * @param simulationPlanNames the simulation plan names to set
     */
    public void setSimulationPlanNames(List<String> simulationPlanNames) {
        this.simulationPlanNames = simulationPlanNames;

        // default first selected
        if (!simulationPlanNames.isEmpty()) {
            setSelectedItem(simulationPlanNames.get(0));
        }
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return simulationPlanNames.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (simulationPlanNames != null) {
            size = simulationPlanNames.size();
        }
        return size;
    }
}
