/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input.variable;

import fr.ifremer.isisfish.entities.Variable;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputOneEquationUI;
import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import static org.nuiton.i18n.I18n._;

public class EntityVariableUI extends InputContentUI<org.nuiton.topia.persistence.TopiaEntityContextable> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_VARIABLE = "variable";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MATRIX_PANEL_ENABLED = "matrixPanel.enabled";
    public static final String BINDING_MATRIX_PANEL_MATRIX = "matrixPanel.matrix";
    public static final String BINDING_VARIABLES_LIST_ENABLED = "variablesList.enabled";
    public static final String BINDING_VARIABLE_COMMENT_ENABLED = "variableComment.enabled";
    public static final String BINDING_VARIABLE_COMMENT_TEXT = "variableComment.text";
    public static final String BINDING_VARIABLE_DOUBLE_VALUE_ENABLED = "variableDoubleValue.enabled";
    public static final String BINDING_VARIABLE_DOUBLE_VALUE_TEXT = "variableDoubleValue.text";
    public static final String BINDING_VARIABLE_EQUATION_VALUE_ACTIVE = "variableEquationValue.active";
    public static final String BINDING_VARIABLE_EQUATION_VALUE_BEAN = "variableEquationValue.bean";
    public static final String BINDING_VARIABLE_NAME_FIELD_ENABLED = "variableNameField.enabled";
    public static final String BINDING_VARIABLE_NAME_FIELD_TEXT = "variableNameField.text";
    public static final String BINDING_VARIABLE_TYPE_COMBO_ENABLED = "variableTypeCombo.enabled";
    public static final String BINDING_VARIABLE_TYPE_COMBO_SELECTED_ITEM = "variableTypeCombo.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXzW8bRRSfmDjfoW2ipAkESFsDooIxTUoRSpS2SRrVkUOjJikVERJj78TZar0znZ1NNj0gJPgD+BPgzgWJGyfEgTMHLoh/ASEOXBFvZj/sjbfrVSeHtf0+fu/33rx5b/P9X6jsCXTlCQkCLHxX2m2Kt+8+fvyg8YQ25Sb1msLmkgkU/g2UUOkQjVuJ3JPo2mFduVcj9+oGa3PmUrfLe6WOxjx55lDvmFIp0Wtpj6bnVfcS9UrAfRGjJqSyUL/95+/SN9aX35UQCjiwewNSWezn1clksI5KtiXRFEQ6IVWHuC2gIWy3BXwnlWzDIZ73MWnTp+gLNFxHQ5wIAJPoavGUNYb2D7hEFys1l/tyg7kSzA9q70t060hg+0jQNoVPz/aObO8Y+za2lSE+IcImDYfiexBKnj2Kfh7UONeoQxKNgc194loOFRKtvAha5N2BHGxQ4kq0zEQLu74tmYsl4zbBnAoABe5NiveVJATS+QRSYXVARuJoEr2ZxYoqV5t6OKbRcR2u7CsBVGcudZ7eKZwO1jplOXre4Yb6eVk9ZhLVZGV7rymY4+wSVyFeVicbRFBdKmU+1/GKyXt1yFeiSykvJVOGryT2o5XtdV9CoSDCdMo2FKfRI7pLGXRHKtt10qAO4EylYyqpMrqW2F6KSaoe3bKpA908m3Lah1PRirTjWGWTNf02nACEme/2UMeIYyXvYaUL/PZzWOyfcQpXocEkmkmx0MJ1FqT9prr96uSMQaHC2mFyKvEGEVYo5dmh1KE556ukhek4UbGXk2Lf6klrKUnro0Q3HcfaZD48HxHH1z1yPW0Wod/MQV9O0G8nuvE2gVETRDm823XRQHGMQy1uwc3d6Rjes8BCpIGi+B9kxJ+JM7j31CfSZq7OQaJq7ozQA+qBmzgd1BTcVk9WNzNaIXXXdK8spA0uxJSgJdp6lM709OtdQYky38loV435Hu+9dlpxNR0sUS51KwV6NTVTYPvgzvbprIeBQ1QWPohhCB32LqyHoApX1dy5VaUAtfa/2enff/rzx614P12H2DOZpl3rFfYGFwzmrBqNULBwOfnSdqo7hK8colGPOrCb9e5dyCC2F6mBHMTTcwsrd3yfeMcAUR7+4+dfZj//7SVU2kJjDiPWFlH2NTQqjwVUgTlWwG/f0YwmTkfgeVFxk2iowYSllszLqxaRZLFhuxac2loARVjIKELCpDH667/Tez/ciQsxAMTmn2veKUb5UzRku47tUr2qoy2cuZrHuUd9i3W2bdb+HVCf8zxqn8/0k2RlOtGkjvOQupAt1ffNCnz1QTV59a2lsV4vgDVMXdXwliFMuc2scLIZgEyGvQO3egfQjMCUmOcgXClAZ1BtG5jgq+EhLxIJo67hS7r2ophK3MxhVTHO661CCF+px9cmCHkc3inOwQghj0PVuA7FEPI43CiE4BshwDAILw21apK2DbGGHP1Gk4PyoXFVVo1PphhCHoc14w4thpDHYd24Dv0RYKRasL9cD0aqejvLAds0Tqg/AjRY+OZoigJvBPZJ3oKoFRnv6r9IQ4wJhbEbvhCd5VS3CFa56ZBnzwwJXThiog2vbBtE0hYTZpz6NWAxhLyeqRtzKIaQx2G3SK8IdurlsOiP0W+gFEPIy+PAuJbFEPI4fGLMQSH8D3X0k074EwAA";
    private static final Log log = LogFactory.getLog(EntityVariableUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TopiaEntityContextable bean;
    protected MatrixPanelEditor matrixPanel;
    protected EntityVariableHandler varHandler;
    protected Variable variable;
    protected JTextArea variableComment;
    protected JTextField variableDoubleValue;
    protected InputOneEquationUI variableEquationValue;
    protected JTextField variableNameField;
    protected JComboBox variableTypeCombo;
    protected CardLayout variableTypeLayout;
    protected JPanel variableTypePanel;
    protected JList variablesList;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EntityVariableUI $InputContentUI0 = this;
    private Table $Table0;
    private Table $Table1;
    private JScrollPane $JScrollPane0;
    private JButton $JButton0;
    private Table $Table2;
    private JLabel $JLabel0;
    private Document $Document0;
    private JLabel $JLabel1;
    private Table $Table3;
    private JLabel $JLabel2;
    private Table $Table4;
    private JLabel $JLabel3;
    private Table $Table5;
    private JLabel $JLabel4;
    private JScrollPane $JScrollPane1;
    private Document $Document1;
    private JButton $JButton1;
    private JButton $JButton2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            addPropertyChangeListener(PROPERTY_BEAN, new java.beans.PropertyChangeListener() {
                public void propertyChange(java.beans.PropertyChangeEvent evt) {
                    varHandler.initView(EntityVariableUI.this);
                }
            });
            
            addPropertyChangeListener(PROPERTY_VARIABLE, new java.beans.PropertyChangeListener() {
                public void propertyChange(java.beans.PropertyChangeEvent evt) {
                    if (evt.getNewValue() == null) {
                        matrixPanel.setMatrix(null);
                    }
                }
            });
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EntityVariableUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntityVariableUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EntityVariableUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EntityVariableUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntityVariableUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EntityVariableUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntityVariableUI() {
        $initialize();
    }

    public EntityVariableUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVarHandler().addNewVariable(this);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVarHandler().deleteVariable(this);
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVarHandler().saveVariable(this);
    }

    public void doActionPerformed__on__variableTypeCombo(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVarHandler().showSelectedType(this);
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVariable().setComment(variableComment.getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVariable().setComment(variableComment.getText());
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVariable().setName(variableNameField.getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVariable().setName(variableNameField.getText());
    }

    public void doValueChanged__on__variablesList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVarHandler().showSelectedVariable(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TopiaEntityContextable getBean() {
        return bean;
    }

    public MatrixPanelEditor getMatrixPanel() {
        return matrixPanel;
    }

    public EntityVariableHandler getVarHandler() {
        return varHandler;
    }

    public Variable getVariable() {
        return variable;
    }

    public JTextArea getVariableComment() {
        return variableComment;
    }

    public JTextField getVariableDoubleValue() {
        return variableDoubleValue;
    }

    public InputOneEquationUI getVariableEquationValue() {
        return variableEquationValue;
    }

    public JTextField getVariableNameField() {
        return variableNameField;
    }

    public JComboBox getVariableTypeCombo() {
        return variableTypeCombo;
    }

    public CardLayout getVariableTypeLayout() {
        return variableTypeLayout;
    }

    public JPanel getVariableTypePanel() {
        return variableTypePanel;
    }

    public JList getVariablesList() {
        return variablesList;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(TopiaEntityContextable bean) {
        TopiaEntityContextable oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setVariable(Variable variable) {
        Variable oldValue = this.variable;
        this.variable = variable;
        firePropertyChange(PROPERTY_VARIABLE, oldValue, variable);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Document get$Document0() {
        return $Document0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected Table get$Table5() {
        return $Table5;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToVariableTypePanel() {
        if (!allComponentsCreated) {
            return;
        }
        variableTypePanel.add($Table3, "doubletype");
        variableTypePanel.add($Table4, "matrixtype");
        variableTypePanel.add($Table5, "equationtype");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createMatrixPanel() {
        $objectMap.put("matrixPanel", matrixPanel = new MatrixPanelEditor());
        
        matrixPanel.setName("matrixPanel");
        matrixPanel.setDimensionEdit(true);
        matrixPanel.putClientProperty("sensitivityBean", fr.ifremer.isisfish.entities.Variable.class);
        matrixPanel.putClientProperty("sensitivityMethod", "MatrixValue");
    }

    protected void createVarHandler() {
        $objectMap.put("varHandler", varHandler = new EntityVariableHandler());
    }

    protected void createVariable() {
        $objectMap.put("variable", variable = null);
    }

    protected void createVariableComment() {
        $objectMap.put("variableComment", variableComment = new JTextArea());
        
        variableComment.setName("variableComment");
        variableComment.setColumns(15);
        variableComment.setLineWrap(true);
        variableComment.setWrapStyleWord(true);
        variableComment.setRows(3);
    }

    protected void createVariableDoubleValue() {
        $objectMap.put("variableDoubleValue", variableDoubleValue = new JTextField());
        
        variableDoubleValue.setName("variableDoubleValue");
        variableDoubleValue.setColumns(15);
        variableDoubleValue.putClientProperty("sensitivityBean", fr.ifremer.isisfish.entities.Variable.class);
        variableDoubleValue.putClientProperty("sensitivityMethod", "DoubleValue");
    }

    protected void createVariableEquationValue() {
        $objectMap.put("variableEquationValue", variableEquationValue = new InputOneEquationUI(this));
        
        variableEquationValue.setName("variableEquationValue");
        variableEquationValue.setBeanProperty("EquationValue");
        variableEquationValue.setFormuleCategory("Variable");
        variableEquationValue.setText(_("isisfish.common.equation"));
        variableEquationValue.putClientProperty("sensitivityBean", fr.ifremer.isisfish.entities.Variable.class);
        variableEquationValue.putClientProperty("sensitivityMethod", "EquationValue");
    }

    protected void createVariableNameField() {
        $objectMap.put("variableNameField", variableNameField = new JTextField());
        
        variableNameField.setName("variableNameField");
        variableNameField.setColumns(15);
    }

    protected void createVariableTypeCombo() {
        $objectMap.put("variableTypeCombo", variableTypeCombo = new JComboBox());
        
        variableTypeCombo.setName("variableTypeCombo");
        variableTypeCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__variableTypeCombo"));
    }

    protected void createVariableTypeLayout() {
        $objectMap.put("variableTypeLayout", variableTypeLayout = new CardLayout());
    }

    protected void createVariableTypePanel() {
        $objectMap.put("variableTypePanel", variableTypePanel = new JPanel());
        
        variableTypePanel.setName("variableTypePanel");
        variableTypePanel.setLayout(variableTypeLayout);
    }

    protected void createVariablesList() {
        $objectMap.put("variablesList", variablesList = new JList());
        
        variablesList.setName("variablesList");
        variablesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__variablesList"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $InputContentUI0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(1, 0, 1, 2, 3.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer($JButton0), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(variablesList);
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(variableNameField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(variableTypeCombo), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(variableTypePanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 4.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane1, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer($JButton1), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer($JButton2), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToVariableTypePanel();
        // inline complete setup of $Table3
        $Table3.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 12, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(SwingUtil.boxComponentWithJxLayer(variableDoubleValue), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table4
        $Table4.add($JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(SwingUtil.boxComponentWithJxLayer(matrixPanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table5
        $Table5.add(SwingUtil.boxComponentWithJxLayer(variableEquationValue), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(SwingUtil.boxComponentWithJxLayer(variableComment));
        
        // apply 21 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        $Table1.setBorder(BorderFactory.createTitledBorder(_("isisfish.variables.variableslist")));
        variablesList.setCellRenderer(new VariableListRenderer());
        variablesList.setModel(new fr.ifremer.isisfish.ui.input.model.TopiaEntityListModel());
        variablesList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        $Table2.setBorder(BorderFactory.createTitledBorder(_("isisfish.variables.variabledetail")));
        variableTypeCombo.setModel(new VariableTypeComboModel());
        variableEquationValue.setClazz(fr.ifremer.isisfish.equation.VariableEquation.class);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createVarHandler();
        createBean();
        createVariable();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createVariablesList();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("isisfish.variables.addvariable"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.variables.variablename"));
        createVariableNameField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = variableNameField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.variables.variabletype"));
        createVariableTypeCombo();
        createVariableTypeLayout();
        createVariableTypePanel();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.variables.double.value"));
        createVariableDoubleValue();
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.variables.matrix.value"));
        createMatrixPanel();
        // inline creation of $Table5
        $objectMap.put("$Table5", $Table5 = new Table());
        
        $Table5.setName("$Table5");
        createVariableEquationValue();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.variables.comment"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createVariableComment();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = variableComment.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("isisfish.variables.deletevariable"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("isisfish.variables.savevariable"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 21 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 21 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLES_LIST_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                variablesList.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_NAME_FIELD_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableNameField.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VARIABLE_NAME_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getVariable() != null) {
                    SwingUtil.setText(variableNameField, getVariable().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_TYPE_COMBO_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableTypeCombo.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VARIABLE_TYPE_COMBO_SELECTED_ITEM, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().addPropertyChangeListener("type", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getVariable() != null) {
                    variableTypeCombo.setSelectedItem(getVariable().getType());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().removePropertyChangeListener("type", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_DOUBLE_VALUE_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableDoubleValue.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VARIABLE_DOUBLE_VALUE_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().addPropertyChangeListener("doubleValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getVariable() != null) {
                    SwingUtil.setText(variableDoubleValue, String.valueOf(getVariable().getDoubleValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().removePropertyChangeListener("doubleValue", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MATRIX_PANEL_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                matrixPanel.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MATRIX_PANEL_MATRIX, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().addPropertyChangeListener("matrixValue", this);
                }
                if (getVariable() != null) {
                    getVariable().addPropertyChangeListener("matrixValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getVariable() != null && getVariable().getMatrixValue() != null) {
                    matrixPanel.setMatrix(getVariable().getMatrixValue() != null ? getVariable().getMatrixValue().copy() : null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().removePropertyChangeListener("matrixValue", this);
                }
                if (getVariable() != null) {
                    getVariable().removePropertyChangeListener("matrixValue", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_EQUATION_VALUE_ACTIVE, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableEquationValue.setActive(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_EQUATION_VALUE_BEAN, true ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableEquationValue.setBean(getVariable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_COMMENT_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableComment.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VARIABLE_COMMENT_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getVariable() != null) {
                    SwingUtil.setText(variableComment, jaxx.runtime.SwingUtil.getStringValue(getVariable().getComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setEnabled(isActive() && getVariable() != null);
            }
        });
    }

}