/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.ui.input.model.SetOfVesselsComboModel;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class StrategyTabUI extends InputContentUI<Strategy> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_STRATEGY_COMMENT_ENABLED = "fieldStrategyComment.enabled";
    public static final String BINDING_FIELD_STRATEGY_COMMENT_TEXT = "fieldStrategyComment.text";
    public static final String BINDING_FIELD_STRATEGY_NAME_ENABLED = "fieldStrategyName.enabled";
    public static final String BINDING_FIELD_STRATEGY_NAME_TEXT = "fieldStrategyName.text";
    public static final String BINDING_FIELD_STRATEGY_PROPORTION_SET_OF_VESSELS_ENABLED = "fieldStrategyProportionSetOfVessels.enabled";
    public static final String BINDING_FIELD_STRATEGY_PROPORTION_SET_OF_VESSELS_TEXT = "fieldStrategyProportionSetOfVessels.text";
    public static final String BINDING_FIELD_STRATEGY_SET_OF_VESSELS_ENABLED = "fieldStrategySetOfVessels.enabled";
    public static final String BINDING_FIELD_USE_EQUATION_INACTIVITY_ENABLED = "fieldUseEquationInactivity.enabled";
    public static final String BINDING_FIELD_USE_EQUATION_INACTIVITY_SELECTED = "fieldUseEquationInactivity.selected";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_STRATEGY_INACTIVITY_ACTIVE = "strategyInactivity.active";
    public static final String BINDING_STRATEGY_INACTIVITY_BEAN = "strategyInactivity.bean";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWzW8bRRSfmNhJ+kHbpPkoDZCSUCFA65AeEEqgTQ1RHbkk4KaN8IXx7nM8ZT27nZlN1z0g/gT+BLhzQeLGCXHgzIEL4l9AiEOvFW/G9tprL5uVNoexPe+93/u9j3kvP/xNilKQG49pGFoi4Ip1wNrfPT4+aD4GW30M0hbMV54gvb+pAik0yHknupeKrDdq2rzcNy9XvI7vceAj1ts1ck6qrguyDaAUeTVuYUtZrkfi7dAPxAA1IpWE+t2//xS+db75vkBI6CO7ZQxl7SyrYSTTNVJgjiLz6OmUll3KT5CGYPwE+V7UdxWXSvkp7cAT8jWZqZGSTwWCKfJG9pANhrEPfUUub1S5H6iKxxWqH1U3FXm7JSzWEtAB/JRMtphsWwGzmFa0kBBVcNJ9QJtHVd83SCVFpptAuSJvJtkiMFMMZGQ7NJs7pS5zKPJT5J1YpiKBJZ9iBqy6Ph8OLkcde04Xc6bTE/Z19w8pB3eoM7OBbF3A2FZiPnraRqY158cN3tM/l/WxGIlmN/ZrtAnu5rhPc6uVViLdKy0GrjOIWtdNkaWY0QMI1Z5WihsOnBgCq3HZtRhoHdRB6yFICS62/mIMHLug6d31wmTsrQTs9Rj2ofB8LAzz+KgXrfr6BKTJ+Kb+fTUue8VAHkn45ElANVaVU1uxU6a6E3zbYH81wXde9umMGpZTe9S09AGPXB5Vk1NwKyEFFzf267bwXFdHhEVejlEciuJWV2OJw8R3zLNcnCj2rgCqbW6N99pWQq9NS3qKLbMQQ7kbKOVxrfFBpFiyKbd73ffhuAQdKkiSOOBCXCLI9dj7wDloDefgcFBNNUhRBHiND6oxOTo/R1FvaK6MDU0NaKQvlhb++Pmvn/YGk3INfS8mqo4MepxgPrYkCD1MFLnUG5OBYm75PvW3G2QO+xO3hNkCqwnE6n0xkkN/V7S5pc2te1S2EaI48+cvvy59+ftLpLBHzrkedfao1q+SOdUWmAXPdUL/9h3D6MLTWTwva25YROC6iDi8X97BAUXXmow7WK6PQszCakIWIirNud+eL9R/vDPIxBQyu/a/6sNsFL8gJcZdxsFsjf5CSNwS530JgeMNB3/SKpjSn9f9/tCsmvN+UqjTCtsYn+VOz/saVbiimoECjFUbfWaC0N/qGTH19YE+DpMRXsuE8Cg3QhqHG9k5HOdBSOOwnhvhZu4osiGkcXgrdzWzIaRxeDdDn8/2hgk4uXDOymcWJiWz9yCFRznLu9X/oeXEuKAxDnszuJsSVRasou3SZ89yErrU8kQHt0RF711P5ON0Vq2yIaT13VZuDtkQ0ji8n/v9ZUNI47CTOw/ZENI43M7NIRtCGofd3ByyIaRxqOTmoBH+A3Vcs7K5DwAA";
    private static final Log log = LogFactory.getLog(StrategyTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Strategy bean;
    protected JButton cancel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldStrategyComment;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "fieldStrategyName")
    protected JTextField fieldStrategyName;
    protected JTextField fieldStrategyProportionSetOfVessels;
    protected JComboBox fieldStrategySetOfVessels;
    protected JCheckBox fieldUseEquationInactivity;
    protected JButton save;
    protected InputOneEquationUI strategyInactivity;
    @Validator( validatorId = "validator")
    protected SwingValidator<Strategy> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private StrategyTabUI $InputContentUI0 = this;
    private Table $Table0;
    private Table $Table1;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private JLabel $JLabel3;
    private JScrollPane $JScrollPane0;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected boolean init;
    
    
    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    fieldStrategyName.setText("");
                    fieldStrategyProportionSetOfVessels.setText("");
                    fieldStrategyComment.setText("");
                }
                if (evt.getNewValue() != null) {
                    init = true;
                    setSetOfVesselsModel();
                    init = false;
                }
            }
        });
    }
    
    /*public void refresh() {
        //Strategy strategy = (Strategy)getSaveVerifier().getEntity(Strategy.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        //setBean(null);
        //setBean(strategy);
    
        if (getBean() != null) {
            setSetOfVesselsModel();
            //fieldStrategyProportionSetOfVessels.init();
            
            // code to replace bindings :
            strategyInactivity.setActive(isActive() && getBean().getInactivityEquationUsed());
            
            //getSaveVerifier().addCurrentPanel(strategyInactivity);
        }
        else {
            // listener seam to be called after refresh and remove content :(
            fieldStrategyName.setText("");
            //fieldStrategyProportionSetOfVessels.setModelText("0.0");
            fieldStrategyProportionSetOfVessels.setText("0.0");
            fieldStrategyComment.setText("");
            
            // code to replace bindings :
            strategyInactivity.setActive(isActive());
        }
    }*/
    
    protected void setSetOfVesselsModel() {
        SetOfVesselsComboModel modelVessel = new SetOfVesselsComboModel(getFisheryRegion().getSetOfVessels());
        fieldStrategySetOfVessels.setModel(modelVessel);
        fieldStrategySetOfVessels.setSelectedItem(getBean().getSetOfVessels());
    }
    
    protected void setOfVesselsChanged() {
        if (!init) {
            getBean().setSetOfVessels((SetOfVessels)fieldStrategySetOfVessels.getSelectedItem());
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StrategyTabUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyTabUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public StrategyTabUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public StrategyTabUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyTabUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public StrategyTabUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyTabUI() {
        $initialize();
    }

    public StrategyTabUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().create(Strategy.class);
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().delete();
    }

    public void doActionPerformed__on__fieldUseEquationInactivity(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setInactivityEquationUsed(fieldUseEquationInactivity.isSelected());
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doItemStateChanged__on__fieldStrategySetOfVessels(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setOfVesselsChanged();
    }

    public void doKeyReleased__on__fieldStrategyComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComment(fieldStrategyComment.getText());
    }

    public void doKeyReleased__on__fieldStrategyName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(fieldStrategyName.getText());
    }

    public void doKeyReleased__on__fieldStrategyProportionSetOfVessels(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setProportionSetOfVessels(Double.parseDouble(fieldStrategyProportionSetOfVessels.getText()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Strategy getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextArea getFieldStrategyComment() {
        return fieldStrategyComment;
    }

    public JTextField getFieldStrategyName() {
        return fieldStrategyName;
    }

    public JTextField getFieldStrategyProportionSetOfVessels() {
        return fieldStrategyProportionSetOfVessels;
    }

    public JComboBox getFieldStrategySetOfVessels() {
        return fieldStrategySetOfVessels;
    }

    public JCheckBox getFieldUseEquationInactivity() {
        return fieldUseEquationInactivity;
    }

    public JButton getSave() {
        return save;
    }

    public InputOneEquationUI getStrategyInactivity() {
        return strategyInactivity;
    }

    public SwingValidator<Strategy> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Strategy bean) {
        Strategy oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(_("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(_("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldStrategyComment() {
        $objectMap.put("fieldStrategyComment", fieldStrategyComment = new JTextArea());
        
        fieldStrategyComment.setName("fieldStrategyComment");
        fieldStrategyComment.setColumns(15);
        fieldStrategyComment.setLineWrap(true);
        fieldStrategyComment.setWrapStyleWord(true);
        fieldStrategyComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldStrategyComment"));
    }

    protected void createFieldStrategyName() {
        $objectMap.put("fieldStrategyName", fieldStrategyName = new JTextField());
        
        fieldStrategyName.setName("fieldStrategyName");
        fieldStrategyName.setColumns(15);
        fieldStrategyName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldStrategyName"));
    }

    protected void createFieldStrategyProportionSetOfVessels() {
        $objectMap.put("fieldStrategyProportionSetOfVessels", fieldStrategyProportionSetOfVessels = new JTextField());
        
        fieldStrategyProportionSetOfVessels.setName("fieldStrategyProportionSetOfVessels");
        fieldStrategyProportionSetOfVessels.setColumns(15);
        fieldStrategyProportionSetOfVessels.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldStrategyProportionSetOfVessels"));
        fieldStrategyProportionSetOfVessels.putClientProperty("sensitivityBean", Strategy.class);
        fieldStrategyProportionSetOfVessels.putClientProperty("sensitivityMethod", "ProportionSetOfVessels");
    }

    protected void createFieldStrategySetOfVessels() {
        $objectMap.put("fieldStrategySetOfVessels", fieldStrategySetOfVessels = new JComboBox());
        
        fieldStrategySetOfVessels.setName("fieldStrategySetOfVessels");
        fieldStrategySetOfVessels.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldStrategySetOfVessels"));
    }

    protected void createFieldUseEquationInactivity() {
        $objectMap.put("fieldUseEquationInactivity", fieldUseEquationInactivity = new JCheckBox());
        
        fieldUseEquationInactivity.setName("fieldUseEquationInactivity");
        fieldUseEquationInactivity.setText(_("isisfish.strategy.inactivityEquationUsed"));
        fieldUseEquationInactivity.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldUseEquationInactivity"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(_("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createStrategyInactivity() {
        $objectMap.put("strategyInactivity", strategyInactivity = new InputOneEquationUI(this));
        
        strategyInactivity.setName("strategyInactivity");
        strategyInactivity.setBeanProperty("InactivityEquation");
        strategyInactivity.setFormuleCategory("Inactivity");
        strategyInactivity.setText(_("isisfish.strategy.inactivity"));
        strategyInactivity.putClientProperty("sensitivityBean", Strategy.class);
        strategyInactivity.putClientProperty("sensitivityMethod", "Inactivity");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(Strategy.class, "basics"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldStrategyName)), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldStrategySetOfVessels), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldStrategyProportionSetOfVessels), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel0, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldUseEquationInactivity), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(strategyInactivity), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldStrategyComment));
        // inline complete setup of $Table2
        $Table2.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 20 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        strategyInactivity.setClazz(fr.ifremer.isisfish.equation.StrategyInactivityEquation.class);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.strategy.name"));
        createFieldStrategyName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.common.setOfVessels"));
        createFieldStrategySetOfVessels();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.strategy.proportionSetOfVessels"));
        createFieldStrategyProportionSetOfVessels();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createFieldUseEquationInactivity();
        createStrategyInactivity();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.strategy.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldStrategyComment();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSave();
        createCancel();
        createCreate();
        createDelete();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 20 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 20 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_STRATEGY_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldStrategyName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_STRATEGY_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldStrategyName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_STRATEGY_SET_OF_VESSELS_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldStrategySetOfVessels.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_STRATEGY_PROPORTION_SET_OF_VESSELS_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldStrategyProportionSetOfVessels.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_STRATEGY_PROPORTION_SET_OF_VESSELS_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldStrategyProportionSetOfVessels, String.valueOf(getBean().getProportionSetOfVessels()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_USE_EQUATION_INACTIVITY_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldUseEquationInactivity.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_USE_EQUATION_INACTIVITY_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    fieldUseEquationInactivity.setSelected(getBean().getInactivityEquationUsed());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STRATEGY_INACTIVITY_ACTIVE, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("active", this);
                addPropertyChangeListener("bean", this);
                if (bean != null) {
                    bean.addPropertyChangeListener("inactivityEquationUsed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    strategyInactivity.setActive(isActive() && getBean() != null && bean.getInactivityEquationUsed());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("active", this);
                removePropertyChangeListener("bean", this);
                if (bean != null) {
                    bean.removePropertyChangeListener("inactivityEquationUsed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_INACTIVITY_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyInactivity.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_STRATEGY_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldStrategyComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_STRATEGY_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldStrategyComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    create.setEnabled(!validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                addPropertyChangeListener("bean", this);
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    delete.setEnabled(!validator.isChanged() && getBean() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                removePropertyChangeListener("bean", this);
            }
        });
    }

}