/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class PopulationMigrationEquationUI extends InputContentUI<Population> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_POP_INFO = "popInfo";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EMIGRATION_EQUATION_ACTIVE = "emigrationEquation.active";
    public static final String BINDING_EMIGRATION_EQUATION_BEAN = "emigrationEquation.bean";
    public static final String BINDING_IMMIGRATION_EQUATION_ACTIVE = "immigrationEquation.active";
    public static final String BINDING_IMMIGRATION_EQUATION_BEAN = "immigrationEquation.bean";
    public static final String BINDING_MIGRATION_EQUATION_ACTIVE = "migrationEquation.active";
    public static final String BINDING_MIGRATION_EQUATION_BEAN = "migrationEquation.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUTU8TQRjHn1ZaXhUogYCiQSXRqNmqF40golW0pAixkhB7cdqdtkO2M8PMLCwcjB/Bj6B3LybePBkPnj14MX4FYzx4Nc5sS19gXTe0h93NPM/zm//z1rc/ICEFnN1EnmcJlypSw9by3Y2N1eImLqn7WJYE4YoJqP9icYgXYNBunksF5ws5E55uhKczrMYZxbQtei4HA1LtOlhWMVYKTndGlKRM55vmOY+7Yp/aFBVEff3rZ/yV/fJNHMDjWl2fTmXmf1GtTHpyECe2gpS+aRulHUQrWoYgtKL1HjdnGQdJ+RjV8Ba8gN4cJDkSGqbgXPSUfYYf73EFI7NZyl2VYVRp9/XsVQW3ysIiZYFrWL8lkWUiq5ZLLGIcrTXGXQcpwugKqQj/48GW67/Xs5z75KSCniJGVMGFIJa+iCiCZRurFdjLGc/SMlNwLWJsHiPJqIlpv57Zu7qSpmieJXd0Da3lNUSx03bT7FNUdLDOeLKjR3Vv32Y8U82A0drBjBWkQ4vl13aV4laFDGq8SUzhQ0hjOdnpNUZqoW4CTnUkoMfXao1va75iBUgIVx/rjAuHJ/6JNtVnffLArBugb/0zMfb1w/f3S/sDntJ3jwe6tu2nHjwuGMfC9E3BcH26XUWc9AricwXol9jRy+0v73SAsHzDrMXp+0ZNuGXCrUdIVjUi0fvt46eJ51+OQXwJBhyG7CVk/LPQr6pCV4E5tsfvLPqKhnb69HPEaFOQ1H5kW9foxLyNFJopEmrr5i94ugjTAUVoKin2f/49ln+3uF+ImBY29U/3VjESzyBJqEMo9ne9scaBuz3IJXZt1lrXoAWOmfcUbwz1rP+8GJSpv4/GetlzzeuKL9p8WZEZQ4axVm+lWa75eiYzSOk/qaKr8MLR2YmSg/b2uhQ4XGaipocvgxSuMLFrHG8eHdejsKe6YpjjSyFJTUciXO+acCMki2iE211ruNe1hoddE8J6cabrXkQjhPUiGiGsF9EIYb2IRgjrhSH8BYU3Zu7JCQAA";
    private static final Log log = LogFactory.getLog(PopulationMigrationEquationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected InputOneEquationUI emigrationEquation;
    protected InputOneEquationUI immigrationEquation;
    protected InputOneEquationUI migrationEquation;
    protected PopulationSeasonInfo popInfo;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationMigrationEquationUI $InputContentUI0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(PopulationSeasonInfo populationSeasonInfo) {
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        //setPopInfo(null);
        //setPopInfo(populationSeasonInfo);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationMigrationEquationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationEquationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationMigrationEquationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationEquationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationEquationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationEquationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationEquationUI() {
        $initialize();
    }

    public PopulationMigrationEquationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public InputOneEquationUI getEmigrationEquation() {
        return emigrationEquation;
    }

    public InputOneEquationUI getImmigrationEquation() {
        return immigrationEquation;
    }

    public InputOneEquationUI getMigrationEquation() {
        return migrationEquation;
    }

    public PopulationSeasonInfo getPopInfo() {
        return popInfo;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPopInfo(PopulationSeasonInfo popInfo) {
        PopulationSeasonInfo oldValue = this.popInfo;
        this.popInfo = popInfo;
        firePropertyChange(PROPERTY_POP_INFO, oldValue, popInfo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createEmigrationEquation() {
        $objectMap.put("emigrationEquation", emigrationEquation = new InputOneEquationUI(this));
        
        emigrationEquation.setName("emigrationEquation");
        emigrationEquation.setBeanProperty("EmigrationEquation");
        emigrationEquation.setFormuleCategory("Emigration");
        emigrationEquation.setText(_("isisfish.common.emigration"));
        emigrationEquation.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        emigrationEquation.putClientProperty("sensitivityMethod", "EmigrationEquation");
    }

    protected void createImmigrationEquation() {
        $objectMap.put("immigrationEquation", immigrationEquation = new InputOneEquationUI(this));
        
        immigrationEquation.setName("immigrationEquation");
        immigrationEquation.setBeanProperty("ImmigrationEquation");
        immigrationEquation.setFormuleCategory("Immigration");
        immigrationEquation.setText(_("isisfish.common.immigration"));
        immigrationEquation.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        immigrationEquation.putClientProperty("sensitivityMethod", "ImmigrationEquation");
    }

    protected void createMigrationEquation() {
        $objectMap.put("migrationEquation", migrationEquation = new InputOneEquationUI(this));
        
        migrationEquation.setName("migrationEquation");
        migrationEquation.setBeanProperty("MigrationEquation");
        migrationEquation.setFormuleCategory("Migration");
        migrationEquation.setText(_("isisfish.common.migration"));
        migrationEquation.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        migrationEquation.putClientProperty("sensitivityMethod", "MigrationEquation");
    }

    protected void createPopInfo() {
        $objectMap.put("popInfo", popInfo = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add(SwingUtil.boxComponentWithJxLayer(migrationEquation), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(emigrationEquation), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(immigrationEquation), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        migrationEquation.setClazz(fr.ifremer.isisfish.equation.MigrationEquation.class);
        emigrationEquation.setClazz(fr.ifremer.isisfish.equation.EmigrationEquation.class);
        immigrationEquation.setClazz(fr.ifremer.isisfish.equation.ImmigrationEquation.class);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopInfo();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createMigrationEquation();
        createEmigrationEquation();
        createImmigrationEquation();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        /*public void refresh() {
            getSaveVerifier().addCurrentPanel(immigrationEquation, emigrationEquation, migrationEquation);
        }*/;// registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MIGRATION_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                migrationEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MIGRATION_EQUATION_BEAN, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                migrationEquation.setBean(getPopInfo());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EMIGRATION_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                emigrationEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EMIGRATION_EQUATION_BEAN, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                emigrationEquation.setBean(getPopInfo());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_IMMIGRATION_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                immigrationEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_IMMIGRATION_EQUATION_BEAN, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                immigrationEquation.setBean(getPopInfo());
            }
        });
    }

}