/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUtils;
import fr.ifremer.isisfish.ui.sensitivity.TableBlockingLayerUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.BlockingLayerUI2;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import static org.nuiton.i18n.I18n._;

public abstract class InputContentUI<B extends TopiaEntityContextable> extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACTIVE = "active";
    public static final String PROPERTY_BUTTON_TITLE = "buttonTitle";
    public static final String PROPERTY_NEXT_PATH = "nextPath";
    public static final String PROPERTY_SENSITIVITY = "sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_NEXT_TEXT = "next.text";
    public static final String BINDING_NEXT_VISIBLE = "next.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVkp/gYJEggoJijExxq2ihgNGgRpCSVUikBB7cbo70MHp7DgzC9uL8U/wT9C7FxNvnowHzx68GP8FYzx4Nb7Z3XZbbWkTepjdznzfN997+957+wOllEQX9rHvW9LjmtaJtb68s/Oouk9sfZ8oW1KhXYnCXyKJkhWUd1r7SqO5StnQCxG9UHTrwuWEt7EXyyindIMRVSNEazTTybCVKmy2jhd94cmmastUN9XXv34mXzkv3yQR8gW4y0Mos/1YcSRDZZSkjkan4aYDXGCY74ENSfke+B01e0WGlXqI6+Q5eoHSZTQssAQxjS4OHnKgEfB9oVHm0voG5oRd1+jqrrToriR1Ak9F1S5VNcujFuXC01bJrEWXa1DdLgkRSAxrlK5h7jAiNbrSn78WYmP2MLY1PSAajZvwLBOyteK6jGAeg/KKcEUBR3XDbI23HVU9rV2+RTUDkbFYJMxbDMxw4usNrGvm/2SbfYYbRG6XIIUdH0odUmOFufYzeCmHoDa5iDYP5dafNx8TRzSuMlJuXrrQI2dtEVtbhtHTyVDVdRpQMyZ0P7o+/KQGkI1xJgEaTXTgVoLsRUCJzneEAl1gxV0Ql2miglLSg22Npir/N85jOApbZuqfljGCwemfyYmvH76/X232SQbuPtMV2tbmUL9CugIqjZqrT4VN4mnKCg+wWKygrCIMZkQwA6a7GNuMjsEc3BcWnKFba1jVQCKV/vbx0+TTLydQchXlmIudVWzwJZTVNQlZcJnji3tLgaORwwysY8YbVDFUgwupRCfvOFjj2SrlDuT3rg9JmO6ShJaTavbz74nNd0vNRCTA2Nme8DgZqSdomHJGOQlGRjQNuo6IvFDEc9y467vNgYR55kRUVdeC9Ua3SEerUR0WXeZKA7vle+ZxO3Bv3hYCsXMDiI1g2yZCL8MICIuwh9bMAFq5UKtkH1spG4R4bCGzffMIhbkBrAxp6NkjNC4PoJE+gLkCA6SPzF+Rqg4beQcAAA==";
    private static final Log log = LogFactory.getLog(InputContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean active;
    protected JPanel body;
    protected String buttonTitle;
    protected InputHandler handler;
    protected BlockingLayerUI layerUI;
    protected BlockingLayerUI2 layerUI2;
    protected JButton next;
    protected String nextPath;
    protected Boolean sensitivity;
    protected TableBlockingLayerUI tableLayerUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private InputContentUI<B> $JPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /*
     * Overriden with generic type
     */
    public abstract void setBean(B entity);
    
    public abstract B getBean();
    
    /**
     * Pas tr?s safe, le bean doit s'appeler changeModel dans l'heritage "FORCEMENT"
     *
     * FIXME echatellier 20111201 small fix because save
     * button has to reset internal ui change model state
     */
    public void resetChangeModel() {
    
    }
    
    public InputAction getAction() {
        return getContextValue(InputAction.class);
    }
    public InputSaveVerifier getSaveVerifier() {
        return getContextValue(InputSaveVerifier.class);
    }
    public FisheryRegion getFisheryRegion() {
        return getContextValue(FisheryRegion.class);
    }
    public TopiaContext getTopiaContext() {
        return getContextValue(TopiaContext.class);
    }
    public void setInfoText(String msg) {
        WelcomePanelUI root = getParentContainer(WelcomePanelUI.class);
        if (root != null){
            root.setStatusMessage(msg);
        }
    }
    protected void goTo() {
        // FIXME il ne faut pas appeler le parent
        // on ne sais jamais de quel type est le parent
        InputUI inputUI = getParentContainer(InputUI.class);
        if (inputUI != null) {
            inputUI.getHandler().setTreeSelection(this, nextPath);
        }
    }
    
    /**
     * Mettre a jour la region dans une map si necessaire.
     *
     * @param map la map a mettre a jour si necessaire
     */
    protected void refreshRegionInMap(fr.ifremer.isisfish.map.IsisMapBean map) {
        FisheryRegion fisheryRegion = map.getFisheryRegion();
        FisheryRegion regionFromContext = getFisheryRegion();
        if (fisheryRegion == null || !fisheryRegion.equals(regionFromContext)) {
            if (log.isInfoEnabled()) {
                log.info("Use now " + regionFromContext + " in map " + map);
            }
            map.setFisheryRegion(regionFromContext);
        }
    }
    
    /**
     * Method appel?e par l'arbre de navigation et le gestionnaire
     * de changement d'onglet pour ajouter les layers sur une interface
     * 'input' seulement dans le cas de la sensibilit?.
     */
    public void setLayer(boolean active) {
        if (get$objectMap() != null) {
            for (JComponent boxed : SwingUtil.getLayeredComponents(this)) {
                // Verifie si dans l'entr? existe dans le fichier sensitivity.properties
                Class<?> sensitivityBeanClass = (Class<?>)boxed.getClientProperty("sensitivityBean");
                String method = (String)boxed.getClientProperty("sensitivityMethod");
    
                // test if factor is enabled
                boolean isSensitivityFactorEnabled = false;
                if (sensitivityBeanClass != null) {
                    // sensitivityBeanClass is defined in property file without "Impl"
                    String className = sensitivityBeanClass.getSimpleName().replace("Impl", "");
    
                    // ensure that method name is uncapitalized
                    method = StringUtils.uncapitalize(method);
    
                    String sensitivityFactorName = className + "." + method;
                    isSensitivityFactorEnabled = SensitivityUtils.isSensitivityFactorEnabled(sensitivityFactorName);
                }
                
                // install correct layer depending if factor enable
                if (isSensitivityFactorEnabled) {
                    jaxx.runtime.swing.BlockingLayerUI2 ui = getLayerUI2().clone();
                    SwingUtil.getLayer(boxed).setUI(ui);
                } else {
                    if (boxed instanceof JTable) {
                        SwingUtil.getLayer(boxed).setUI(getTableLayerUI());
                    }
                    else {
                        jaxx.runtime.swing.BlockingLayerUI ui = getLayerUI().clone();
                        ui.setBlock(true);
                        ui.setUseIcon(isActive());
                        SwingUtil.getLayer(boxed).setUI(ui);
                    }
                }
            }
        }
    }
    
    /**
     * Install tabbed pane change listener depending on sensitivity.
     * (init at first call)
     *
     * @param tabbedPane tabbed pane to install change listener
     */
    protected void installChangeListener(JTabbedPane tabbedPane) {
        // in fichery input, we must listener for tab switch
        // to ask user for saving
        // in sensitivity, fishery can't be saved
        if (!isSensitivity()) {
            ChangeListener tabbedPaneChangeListener = new InputTabbedPaneListener();
            tabbedPane.addChangeListener(tabbedPaneChangeListener);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public InputContentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public InputContentUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public InputContentUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public InputContentUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public InputContentUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public InputContentUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public InputContentUI() {
        $initialize();
    }

    public InputContentUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        goTo();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getActive() {
        return active;
    }

    public JPanel getBody() {
        return body;
    }

    public String getButtonTitle() {
        return buttonTitle;
    }

    public InputHandler getHandler() {
        return handler;
    }

    public BlockingLayerUI getLayerUI() {
        return layerUI;
    }

    public BlockingLayerUI2 getLayerUI2() {
        return layerUI2;
    }

    public JButton getNext() {
        return next;
    }

    public String getNextPath() {
        return nextPath;
    }

    public Boolean getSensitivity() {
        return sensitivity;
    }

    public TableBlockingLayerUI getTableLayerUI() {
        return tableLayerUI;
    }

    public Boolean isActive() {
        return active !=null && active;
    }

    public Boolean isSensitivity() {
        return sensitivity !=null && sensitivity;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setActive(Boolean active) {
        Boolean oldValue = this.active;
        this.active = active;
        firePropertyChange(PROPERTY_ACTIVE, oldValue, active);
    }

    public void setButtonTitle(String buttonTitle) {
        String oldValue = this.buttonTitle;
        this.buttonTitle = buttonTitle;
        firePropertyChange(PROPERTY_BUTTON_TITLE, oldValue, buttonTitle);
    }

    public void setNextPath(String nextPath) {
        String oldValue = this.nextPath;
        this.nextPath = nextPath;
        firePropertyChange(PROPERTY_NEXT_PATH, oldValue, nextPath);
    }

    public void setSensitivity(Boolean sensitivity) {
        Boolean oldValue = this.sensitivity;
        this.sensitivity = sensitivity;
        firePropertyChange(PROPERTY_SENSITIVITY, oldValue, sensitivity);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createActive() {
        $objectMap.put("active", active = false);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JPanel());
        
        body.setName("body");
        body.setLayout(new BorderLayout());
    }

    protected void createButtonTitle() {
        $objectMap.put("buttonTitle", buttonTitle = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new InputHandler());
    }

    protected void createLayerUI() {
        $objectMap.put("layerUI", layerUI = new BlockingLayerUI());
    }

    protected void createLayerUI2() {
        $objectMap.put("layerUI2", layerUI2 = new BlockingLayerUI2());
    }

    protected void createNext() {
        $objectMap.put("next", next = new JButton());
        
        next.setName("next");
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createNextPath() {
        $objectMap.put("nextPath", nextPath = null);
    }

    protected void createSensitivity() {
        $objectMap.put("sensitivity", sensitivity = false);
    }

    protected void createTableLayerUI() {
        $objectMap.put("tableLayerUI", tableLayerUI = new TableBlockingLayerUI(this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(body, BorderLayout.CENTER);
        add(SwingUtil.boxComponentWithJxLayer(next), BorderLayout.SOUTH);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        layerUI.setBlockingColor(new Color(25,25,25));
        layerUI2.setAcceptAction(new AbstractAction() {              private static final long serialVersionUID = 1L;              @Override              public void actionPerformed(ActionEvent e) {                 getHandler().accept(InputContentUI.this, e);              }          });
        layerUI2.setAcceptIcon(SwingUtil.createImageIcon("building_add.png"));
        layerUI2.setBlockIcon(SwingUtil.createImageIcon("building.png"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createActive();
        createSensitivity();
        createButtonTitle();
        createNextPath();
        createLayerUI();
        createLayerUI2();
        createTableLayerUI();
        createBody();
        createNext();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NEXT_TEXT, true ,"buttonTitle") {
        
            @Override
            public void processDataBinding() {
                next.setText(_(getButtonTitle()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NEXT_VISIBLE, true ,"buttonTitle") {
        
            @Override
            public void processDataBinding() {
                next.setVisible(getButtonTitle() != null);
            }
        });
    }

}