/*
 * #%L
 * IsisFish
 * 
 * $Id: AbstractRule.java 3437 2011-07-08 11:26:05Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2011 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.rule;

import java.util.HashMap;
import java.util.Map;

/**
 * Class abstraite d'une regles comprenant le code commun à toutes les regles.
 * 
 * Permet de :
 * <ul>
 * <li>Gerer les valeurs entre les regles
 * </ul>
 * 
 * Created: 12 janv. 2006 17:12:51
 *
 * @author poussin
 * @version $Revision: 3437 $
 *
 * Last update: $Date: 2011-07-08 13:26:05 +0200 (Fri, 08 Jul 2011) $
 * by : $Author: chatellier $
 */
public abstract class AbstractRule implements Rule {

    protected transient Map<String, Object> values = new HashMap<String, Object>();

    /*
     * @see fr.ifremer.isisfish.rule.Rule#getValue(java.lang.String)
     */
    @Override
    public Object getValue(String name) {
        return values.get(name);
    }

    /*
     * @see fr.ifremer.isisfish.rule.Rule#setValue(java.lang.String, java.lang.Object)
     */
    @Override
    public void setValue(String name, Object value) {
        values.put(name, value);
    }
}
