/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.xml;

import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.TopiaEntity;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.RuleDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;

/**
 * XML factor visitor.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 5 mars 2009 $
 * By : $Author: chatellier $
 */
public class FactorXMLVisitor extends AbstractXMLVisitor implements FactorVisitor {

    /*
     * @see fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor#start(fr.ifremer.isisfish.simulator.sensitivity.Factor)
     */
    @Override
    public void start(Factor factor) {
        xmlBuffer.append("<factor");
        xmlBuffer.append(" name=\"").append(factor.getName()).append("\"");
        Object referenceValueForType = null;
        // property attribute

        Domain domain = factor.getDomain();

        if (domain instanceof ContinuousDomain) {
            if (domain instanceof MatrixContinuousDomain) {
                xmlBuffer.append(" property=\"matrixcontinuous\"");
            } else if (domain instanceof EquationContinuousDomain) {
                xmlBuffer.append(" property=\"equationcontinuous\"");
            } else {
                xmlBuffer.append(" property=\"continuous\"");
            }
            referenceValueForType = ((ContinuousDomain) domain).getReferenceValue();
            if (referenceValueForType == null) {
                referenceValueForType = ((ContinuousDomain) domain).getMinBound();
            }
        } else if (domain instanceof DiscreteDomain) {
            xmlBuffer.append(" property=\"discrete\"");
            Object firstKey = ((DiscreteDomain) domain).getValues().firstKey();
            referenceValueForType = ((DiscreteDomain) domain).getValues().get(firstKey);
        }
        // type attribute
        if (referenceValueForType instanceof Double || referenceValueForType instanceof Float
                || referenceValueForType instanceof MatrixND) {
            xmlBuffer.append(" type=\"real\"");
        } else if (referenceValueForType instanceof Integer) {
            xmlBuffer.append(" type=\"integer\"");
        } else if (domain instanceof RuleDiscreteDomain) {
            xmlBuffer.append(" type=\"rule\"");
        } else if (domain instanceof EquationDiscreteDomain) {
            xmlBuffer.append(" type=\"equation\"");
        } else if (referenceValueForType instanceof TopiaEntity ||
                    referenceValueForType instanceof TimeStep ||
                    referenceValueForType instanceof Month) {
            xmlBuffer.append(" type=\"string\"");
        }

        //cardinality
        xmlBuffer.append(" cardinality=\"");
        xmlBuffer.append(factor.getCardinality());
        xmlBuffer.append("\"");

        xmlBuffer.append(">");
        // target element
        xmlBuffer.append("<target>").append(factor.getPath()).append("</target>");
        // value element
        /* TODO value should be only in simulation export,
        not in design plan export
        if (factor.getValue() != null) {
            xmlBuffer.append("<value>" + factor.getValue() + "</value>");
        }*/
    }

    /*
     * @see fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor#visit(fr.ifremer.isisfish.simulator.sensitivity.Domain)
     */
    @Override
    public void visit(Factor factor, Domain domain) {
        DomainXMLVisitor visitor = null;
        if (factor.getDomain() instanceof MatrixContinuousDomain) {
            visitor = new MatrixContinuousDomainXMLVisitor();
        } else if (factor.getDomain() instanceof EquationContinuousDomain) {
            visitor = new EquationContinuousDomainXMLVisitor();
        } else if (factor.getDomain() instanceof ContinuousDomain) {
            visitor = new ContinuousDomainXMLVisitor();
        } else if (factor.getDomain() instanceof RuleDiscreteDomain) {
            visitor = new RuleDiscreteDomainXMLVisitor();
        } else if (factor.getDomain() instanceof EquationDiscreteDomain) {
            visitor = new EquationDiscreteDomainXMLVisitor();
        } else if (factor.getDomain() instanceof DiscreteDomain) {
            visitor = new DiscreteDomainXMLVisitor();
        }
        domain.accept(visitor);
        xmlBuffer.append(visitor.getXML());
    }

    /*
     * @see fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor#end(fr.ifremer.isisfish.simulator.sensitivity.Factor)
     */
    @Override
    public void end(Factor factor) {
        xmlBuffer.append("</factor>");
    }
}
