/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ZoneDAOAbstract<E extends Zone> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Zone.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.Zone;
    }

    @Override
    public void delete(E entity) throws TopiaException {
        {
            List<MetierSeasonInfo> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from metierSeasonInfo main, metierseasoninfo_zone secondary " +
                    "where main.topiaid=secondary.metierSeasonInfo" +
                    " and secondary.zone='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(MetierSeasonInfo.class)).list();

            for (MetierSeasonInfo item : list) {
                item.removeZone(entity);
            }
        }

        {
            List<Population> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from population main, population_reproductionzone secondary " +
                    "where main.topiaid=secondary.population" +
                    " and secondary.reproductionZone='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(Population.class)).list();

            for (Population item : list) {
                item.removeReproductionZone(entity);
            }
        }

        {
            List<Population> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from population main, population_populationzone secondary " +
                    "where main.topiaid=secondary.population" +
                    " and secondary.populationZone='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(Population.class)).list();

            for (Population item : list) {
                item.removePopulationZone(entity);
            }
        }

        {
            List<Population> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from population main, population_recruitmentzone secondary " +
                    "where main.topiaid=secondary.population" +
                    " and secondary.recruitmentZone='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(Population.class)).list();

            for (Population item : list) {
                item.removeRecruitmentZone(entity);
            }
        }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Zone.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Zone.PROPERTY_NAME, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Zone.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Zone.PROPERTY_COMMENT, v);
        return result;
    }

    public E findContainsCell(Cell v) throws TopiaException {
        E result = findContains(Zone.PROPERTY_CELL, v);
        return result;
    }

    public List<E> findAllContainsCell(Cell v) throws TopiaException {
        List<E> result = findAllContains(Zone.PROPERTY_CELL, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllContainsReproductionZone(entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllContainsPopulationZone(entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllContainsRecruitmentZone(entity);
            result.addAll(tmp);
        }

        if (type == MetierSeasonInfo.class) {
            MetierSeasonInfoDAO dao = (MetierSeasonInfoDAO)
                getContext().getDAO(MetierSeasonInfo.class);
            tmp = dao.findAllContainsZone(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Population.class, entity);
        if (!list.isEmpty()) {
            result.put(Population.class, list);
        }

        list = findUsages(MetierSeasonInfo.class, entity);
        if (!list.isEmpty()) {
            result.put(MetierSeasonInfo.class, list);
        }

        return result;
    }

} //ZoneDAOAbstract<E extends Zone>
