/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.workingDb;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.DriverType;
import fr.ifremer.echobase.persistence.EchoBaseEntityHelper;
import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.ui.actions.workingDb.AbstractWorkingDbAction;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class Connect
extends AbstractWorkingDbAction {
    private static final long serialVersionUID = 1L;
    protected String login;
    protected String password;
    protected JdbcConfiguration jdbcConf;

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @InputConfig(methodName="input")
    public String execute() throws Exception {
        String result = "input";
        try {
            EchoBaseEntityHelper.checkJdbcConnection((JdbcConfiguration)this.jdbcConf);
            this.getEchoBaseSession().initUserDb(this.jdbcConf, true);
            this.addFlashMessage(this.t("echobase.info.workingDbconfiguration.connected", new Object[]{this.conf.getUrl()}));
            result = "success";
        }
        catch (SQLException e) {
            this.jdbcConf = null;
            this.addFieldError("login", this.t("echobase.error.workingDbConfiguration.couldNotConnect", new Object[]{e.getMessage()}));
            this.addFieldError("password", this.t("echobase.error.workingDbConfiguration.couldNotConnect", new Object[]{e.getMessage()}));
        }
        return result;
    }

    public void validate() {
        this.jdbcConf = JdbcConfiguration.newConfig((DriverType)this.getConf().getDriverType(), (String)this.getConf().getUrl(), (String)this.login, (String)this.password);
        try {
            EchoBaseEntityHelper.checkJdbcConnection((JdbcConfiguration)this.jdbcConf);
        }
        catch (SQLException e) {
            this.jdbcConf = null;
            this.addFieldError("login", this.t("echobase.error.workingDbConfiguration.couldNotConnect", new Object[]{e.getMessage()}));
            this.addFieldError("password", this.t("echobase.error.workingDbConfiguration.couldNotConnect", new Object[]{e.getMessage()}));
        }
    }

    public void prepare() throws Exception {
        super.prepare();
        if (DriverType.H2.equals((Object)this.conf.getDriverType()) && StringUtils.isBlank((CharSequence)this.getPassword())) {
            this.setLogin("sa");
            this.setPassword("sa");
        }
    }
}

