/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import fr.ifremer.echobase.ui.EchoBaseApplicationContext;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EchoBaseApplicationListener
implements ServletContextListener {
    protected static final Log log;

    public void contextInitialized(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application starting at " + new Date() + "..."));
        }
        EchoBaseApplicationContext applicationContext = new EchoBaseApplicationContext();
        EchoBaseApplicationContext.setApplicationContext((ServletContext)sce.getServletContext(), (EchoBaseApplicationContext)applicationContext);
        applicationContext.init();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application is ending at " + new Date() + "..."));
        }
        ServletContext servletContext = sce.getServletContext();
        EchoBaseApplicationContext applicationContext = EchoBaseApplicationContext.getApplicationContext((ServletContext)servletContext);
        EchoBaseApplicationContext.removeApplicationContext((ServletContext)servletContext);
        applicationContext.close();
    }

    static {
        block8: {
            block7: {
                block6: {
                    log = LogFactory.getLog(EchoBaseApplicationListener.class);
                    try {
                        Class.forName("org.postgresql.Driver");
                    }
                    catch (ClassNotFoundException e) {
                        if (!log.isErrorEnabled()) break block6;
                        log.error((Object)"Could not find pg driver", (Throwable)e);
                    }
                }
                try {
                    Class.forName("org.h2.Driver");
                }
                catch (ClassNotFoundException e) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)"Could not find h2 driver", (Throwable)e);
                }
            }
            try {
                Class.forName("org.sqlite.JDBC");
            }
            catch (ClassNotFoundException e) {
                if (!log.isErrorEnabled()) break block8;
                log.error((Object)"Could not find sqlite driver", (Throwable)e);
            }
        }
    }
}

