/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.spatial;

import fr.ifremer.echobase.entities.EchoBaseUserPersistenceContext;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.services.service.UserDbPersistenceService;
import fr.ifremer.echobase.services.service.spatial.GisService;
import fr.ifremer.echobase.services.service.spatial.SpatialDataService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShowVoyageMap
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ShowVoyageMap.class);
    @Inject
    protected transient GisService gisService;
    @Inject
    protected transient SpatialDataService spatialDataService;
    @Inject
    protected transient EchoBaseUserPersistenceContext userPersistenceContext;
    @Inject
    private transient UserDbPersistenceService persistenceService;
    protected String voyageId;
    protected boolean spatialSupport;
    protected boolean spatialStructureFound;
    protected boolean gisSupport;
    protected boolean spatialDataToComputeExists;
    protected String lizmapUrl;
    protected Voyage voyage;

    public String getVoyageId() {
        return this.voyageId;
    }

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    public String getLizmapUrl() {
        return this.lizmapUrl;
    }

    public boolean isSpatialStructureFound() {
        return this.spatialStructureFound;
    }

    public boolean isSpatialSupport() {
        return this.spatialSupport;
    }

    public boolean isSpatialDataToComputeExists() {
        return this.spatialDataToComputeExists;
    }

    public boolean isGisSupport() {
        return this.gisSupport;
    }

    public Voyage getVoyage() {
        return this.voyage;
    }

    public String execute() throws Exception {
        this.voyage = this.persistenceService.getVoyage(this.voyageId);
        this.spatialSupport = this.userPersistenceContext.isSpatialSupport();
        if (this.spatialSupport) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Db has spatial supports");
            }
            this.spatialStructureFound = this.userPersistenceContext.isSpatialStructureFound();
            if (this.spatialStructureFound) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Spatial structure found.");
                }
                this.spatialDataToComputeExists = this.spatialDataService.isSpatialDataToComputeExist();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Is there some spatial data to compute? " + this.spatialDataToComputeExists));
                }
                this.gisSupport = this.getEchoBaseApplicationContext().isGisSupport();
                if (this.gisSupport) {
                    JdbcConfiguration dbConf = this.getEchoBaseSession().getWorkingDbConfiguration();
                    this.gisService.generateMap(dbConf, this.voyage);
                    this.lizmapUrl = this.gisService.getVoyageMapUrl(dbConf, this.voyage);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Gis url access: " + this.lizmapUrl));
                    }
                } else if (log.isInfoEnabled()) {
                    log.info((Object)"Application does not support gis features.");
                }
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"Db has no spatial support.");
        }
        return "success";
    }
}

