/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.interceptors;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import fr.ifremer.echobase.ui.EchoBaseApplicationContext;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.user.Login;
import fr.ifremer.echobase.ui.interceptors.AbstractCheckInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckLogguedInterceptor
extends AbstractCheckInterceptor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CheckLogguedInterceptor.class);
    protected String loginAction;
    protected static final String URL_PATTERN = "%s?redirectAction=%s";

    public void setLoginAction(String loginAction) {
        this.loginAction = loginAction;
    }

    protected boolean doCheck(ActionInvocation invocation) {
        boolean autoLogin;
        boolean userLoggued;
        EchoBaseSession echoBaseSession = EchoBaseSession.getEchoBaseSession((ActionContext)invocation.getInvocationContext());
        boolean bl = userLoggued = echoBaseSession.getUser() != null;
        if (!userLoggued && (autoLogin = EchoBaseApplicationContext.getApplicationContext((ActionContext)invocation.getInvocationContext()).getConfiguration().getOptionAsBoolean("autoLogin"))) {
            block5: {
                if (log.isInfoEnabled()) {
                    log.info((Object)"AutotLogin with admin/admin user");
                }
                Login logAction = new Login();
                logAction.setSession(invocation.getInvocationContext().getSession());
                logAction.setEmail("admin");
                logAction.setPassword("admin");
                try {
                    logAction.execute();
                }
                catch (Exception eee) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Could not auto-login", (Throwable)eee);
                }
            }
            return true;
        }
        if (!userLoggued && log.isDebugEnabled()) {
            log.debug((Object)"User is not loggued, will redirect to home");
        }
        return userLoggued;
    }

    protected String getRedirectUrl() {
        String url = String.format(URL_PATTERN, this.loginAction, this.redirectAction);
        return url;
    }
}

