/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.spatial;

import fr.ifremer.echobase.entities.EchoBaseUserPersistenceContext;
import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.services.service.spatial.GisService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Show
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Show.class);
    @Inject
    protected transient GisService gisService;
    @Inject
    protected transient EchoBaseUserPersistenceContext userPersistenceContext;
    protected boolean spatialSupport;
    protected boolean spatialStructureFound;
    protected boolean gisSupport;
    protected String lizmapUrl;

    public String getLizmapUrl() {
        return this.lizmapUrl;
    }

    public boolean isSpatialStructureFound() {
        return this.spatialStructureFound;
    }

    public boolean isSpatialSupport() {
        return this.spatialSupport;
    }

    public boolean isGisSupport() {
        return this.gisSupport;
    }

    public String execute() throws Exception {
        this.spatialSupport = this.userPersistenceContext.isSpatialSupport();
        if (this.spatialSupport) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Db has spatial supports");
            }
            this.spatialStructureFound = this.userPersistenceContext.isSpatialStructureFound();
            if (this.spatialStructureFound) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Spatial structure found.");
                }
                this.gisSupport = this.getEchoBaseApplicationContext().isGisSupport();
                if (this.gisSupport) {
                    JdbcConfiguration dbConf = this.getEchoBaseSession().getWorkingDbConfiguration();
                    this.gisService.generateMaps(dbConf);
                    this.lizmapUrl = this.gisService.getRepositoryUrl(dbConf);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Gis url access: " + this.lizmapUrl));
                    }
                } else if (log.isInfoEnabled()) {
                    log.info((Object)"Application does not support gis features.");
                }
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"Db has no spatial support.");
        }
        return "success";
    }
}

