/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.workingDb;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.ui.actions.workingDb.AbstractWorkingDbAction;
import org.apache.commons.lang3.StringUtils;

public class Create
extends AbstractWorkingDbAction {
    private static final long serialVersionUID = 1L;

    public boolean isNewConf() {
        return true;
    }

    public String createConf() throws Exception {
        this.addFlashMessage(this._("echobase.info.new.workingDbConfiguration.inprogress", new Object[0]));
        return "input";
    }

    public String cloneConf() throws Exception {
        this.getConf().setTopiaId(null);
        this.addFlashMessage(this._("echobase.info.new.workingDbConfiguration.inprogress", new Object[0]));
        return "input";
    }

    @InputConfig(methodName="input")
    public String execute() throws Exception {
        this.conf = this.workingDbConfigurationService.create(this.getConf());
        this.addFlashMessage(this._("echobase.info.workingDbconfiguration.created", new Object[]{this.conf.getUrl()}));
        return "success";
    }

    public void validate() {
        boolean urlUsed;
        if (StringUtils.isBlank((CharSequence)this.getConf().getUrl())) {
            this.addFieldError("conf.url", this._("echobase.error.workingDbConfiguration.url.required", new Object[0]));
        } else if (!this.isConfExists() && (urlUsed = this.workingDbConfigurationService.isUrlAlreadyUsed(this.getConf().getUrl()))) {
            this.addFieldError("conf.url", this._("echobase.error.workingDbConfiguration.url.already.exists", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.getConf().getDescription())) {
            this.addFieldError("conf.description", this._("echobase.error.workingDbConfiguration.description.required", new Object[0]));
        }
    }
}

