/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.interceptors;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import fr.ifremer.echobase.services.EchoBaseService;
import fr.ifremer.echobase.services.EchoBaseServiceContext;
import fr.ifremer.echobase.ui.EchoBaseApplicationContext;
import fr.ifremer.echobase.ui.EchoBaseInternalDbTransactionFilter;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.EchoBaseWorkingDbTransactionFilter;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.beans.PropertyDescriptor;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.util.beans.BeanUtil;

public class EchoBaseInjectInterceptor
implements Interceptor {
    private static final Log log = LogFactory.getLog(EchoBaseInjectInterceptor.class);
    private static final long serialVersionUID = 1L;

    public void init() {
        if (log.isInfoEnabled()) {
            log.info((Object)("init " + this));
        }
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action instanceof EchoBaseActionSupport) {
            EchoBaseActionSupport echoBaseActionSupport = (EchoBaseActionSupport)action;
            EchoBaseSession userSession = this.getEchoBaseSession(invocation);
            EchoBaseServiceContext serviceContext = this.newServiceContext(invocation, echoBaseActionSupport.getLocale());
            Set descriptors = BeanUtil.getDescriptors(action.getClass(), (Predicate)BeanUtil.IS_WRITE_DESCRIPTOR);
            for (PropertyDescriptor propertyDescriptor : descriptors) {
                Class<?> propertyType = propertyDescriptor.getPropertyType();
                EchoBaseServiceContext toInject = null;
                if (EchoBaseServiceContext.class.isAssignableFrom(propertyType)) {
                    toInject = serviceContext;
                } else if (EchoBaseService.class.isAssignableFrom(propertyType)) {
                    Class<?> serviceClass = propertyType;
                    toInject = serviceContext.newService(serviceClass);
                } else if (EchoBaseSession.class.isAssignableFrom(propertyType)) {
                    toInject = userSession;
                } else if (EchoBaseApplicationContext.class.isAssignableFrom(propertyType)) {
                    toInject = this.getEchoBaseApplicationContext(invocation);
                }
                if (toInject == null) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("injecting " + toInject + " in action " + action));
                }
                propertyDescriptor.getWriteMethod().invoke(action, toInject);
            }
        }
        return invocation.invoke();
    }

    protected EchoBaseSession getEchoBaseSession(ActionInvocation invocation) {
        EchoBaseSession session = EchoBaseSession.getEchoBaseSession((ActionContext)invocation.getInvocationContext());
        return session;
    }

    protected EchoBaseApplicationContext getEchoBaseApplicationContext(ActionInvocation invocation) {
        EchoBaseApplicationContext applicationContext = EchoBaseApplicationContext.getApplicationContext((ActionContext)invocation.getInvocationContext());
        Preconditions.checkNotNull((Object)"application context must be initialized before calling an action", (Object)applicationContext);
        return applicationContext;
    }

    protected EchoBaseServiceContext newServiceContext(ActionInvocation invocation, Locale locale) {
        TopiaContext topiaInternalContext = EchoBaseInternalDbTransactionFilter.getTransaction((ActionContext)invocation.getInvocationContext());
        TopiaContext topiaContext = EchoBaseWorkingDbTransactionFilter.getTransaction((ActionContext)invocation.getInvocationContext());
        EchoBaseApplicationContext applicationContext = this.getEchoBaseApplicationContext(invocation);
        EchoBaseServiceContext serviceContext = applicationContext.newServiceContext(locale, topiaInternalContext, topiaContext);
        return serviceContext;
    }

    public void destroy() {
        if (log.isInfoEnabled()) {
            log.info((Object)("destroy " + this));
        }
    }
}

