/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: GetForeignEntities.java 842 2013-08-15 10:53:16Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.4/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/GetForeignEntities.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.services.service.WorkingDbPersistenceService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

import java.util.Map;

/**
 * Obtains the html select form for the given entity type.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class GetForeignEntities extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Type of entity to load. */
    protected EchoBaseEntityEnum entityType;

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    /** Entities loaded (key are id, values are decoration of entity). */
    protected Map<String, String> entities;

    public Map<String, String> getEntities() {
        return entities;
    }

    @Override
    public String execute() throws Exception {

        entities = workingDbPersistenceService.loadSortAndDecorate(entityType.getContract());

        return SUCCESS;
    }

    //------------------------------------------------------------------------//
    //-- Injected objects                                                     //
    //------------------------------------------------------------------------//

    protected transient WorkingDbPersistenceService workingDbPersistenceService;

    public void setWorkingDbPersistenceService(WorkingDbPersistenceService workingDbPersistenceService) {
        this.workingDbPersistenceService = workingDbPersistenceService;
    }
}
