/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportQuery;

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.entities.ExportQuery;
import fr.ifremer.echobase.services.service.InternalDbPersistenceService;
import fr.ifremer.echobase.services.service.exportquery.ExportQueryInvalidNameException;
import fr.ifremer.echobase.services.service.exportquery.ExportQueryNameAlreadyExistException;
import fr.ifremer.echobase.services.service.exportquery.ExportQueryService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManageExportQuery
extends EchoBaseActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ManageExportQuery.class);
    protected ExportQuery query;
    protected boolean newQuery;
    protected boolean newLibreOfficeQuery;
    protected boolean queryExists;
    protected boolean canUpdateQuery;
    protected Map<String, String> queries;
    protected transient ExportQueryService exportQueryService;
    protected transient InternalDbPersistenceService internalDbPersistenceService;

    public ExportQuery getQuery() {
        if (this.query == null) {
            this.query = this.exportQueryService.newExportQuery();
        }
        return this.query;
    }

    public void setNewQuery(boolean newQuery) {
        this.newQuery = newQuery;
    }

    public boolean isNewQuery() {
        return this.newQuery;
    }

    public void setNewLibreOfficeQuery(boolean newLibreOfficeQuery) {
        this.newLibreOfficeQuery = newLibreOfficeQuery;
    }

    public boolean isNewLibreOfficeQuery() {
        return this.newLibreOfficeQuery;
    }

    public boolean isQueryExists() {
        return StringUtils.isNotEmpty((CharSequence)this.getQuery().getTopiaId());
    }

    public boolean isCanUpdateQuery() {
        return this.canUpdateQuery;
    }

    public Map<String, String> getQueries() {
        return this.queries;
    }

    public Map<String, String> getTableNames() {
        return this.queries;
    }

    public String saveQuery() throws Exception {
        String result = "input";
        boolean safeSql = this.checkQuery();
        if (safeSql) {
            try {
                this.query = this.exportQueryService.createOrUpdate(this.getQuery(), this.getEchoBaseSession().getUser());
                result = "success";
            }
            catch (ExportQueryInvalidNameException e) {
                this.addFieldError("query.name", this._("echobase.error.query.invalid.name", new Object[0]));
            }
            catch (ExportQueryNameAlreadyExistException e) {
                this.addFieldError("query.name", this._("echobase.error.query.name.already.exists", new Object[0]));
            }
        }
        return result;
    }

    public String cloneQuery() throws Exception {
        this.getQuery().setTopiaId(null);
        this.getQuery().setName(this.getQuery().getName() + "-clone");
        this.query = this.exportQueryService.createOrUpdate(this.getQuery(), this.getEchoBaseSession().getUser());
        return "success";
    }

    public String confirmDeleteQuery() throws Exception {
        return "success";
    }

    public String deleteQuery() throws Exception {
        this.exportQueryService.delete(this.getQuery().getTopiaId());
        this.query = null;
        return "success";
    }

    public String execute() {
        if (StringUtils.isNotEmpty((CharSequence)this.getQuery().getTopiaId())) {
            this.checkQuery();
        }
        return "success";
    }

    public void prepare() throws Exception {
        this.queries = this.internalDbPersistenceService.loadSortAndDecorate(ExportQuery.class);
        if (this.queries.isEmpty()) {
            this.addFlashMessage(this._("echobase.info.no.sqlQuery.saved", new Object[0]));
        } else {
            String selectedQueryId = this.getQuery().getTopiaId();
            if (!this.isQueryExists()) {
                if (this.isNewQuery() || this.isNewLibreOfficeQuery()) {
                    this.addFlashMessage(this._("echobase.info.new.sqlQuery.inprogress", new Object[0]));
                } else {
                    this.addFlashMessage(this._("echobase.info.no.sqlQuery.selected", new Object[0]));
                }
            } else {
                this.query = this.exportQueryService.getExportQuery(selectedQueryId);
                EchoBaseUser echoBaseUser = this.getEchoBaseSession().getUser();
                boolean bl = this.canUpdateQuery = echoBaseUser.isAdmin() || echoBaseUser.getEmail().equals(this.query.getLastModifiedUser());
                if (!this.canUpdateQuery) {
                    this.addFlashMessage(this._("echobase.info.sqlQuery.not.modifiable", new Object[0]));
                }
            }
        }
    }

    private boolean checkQuery() {
        boolean result;
        try {
            this.exportQueryService.testSql(this.getQuery().getSqlQuery());
            result = true;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (log.isWarnEnabled()) {
                log.warn((Object)"Invalid sql ", cause);
            }
            this.addFieldError("query.sqlQuery", this._("echobase.error.invalid.sql", new Object[]{cause.getMessage()}));
            result = false;
        }
        return result;
    }

    public void setExportQueryService(ExportQueryService exportQueryService) {
        this.exportQueryService = exportQueryService;
    }

    public void setInternalDbPersistenceService(InternalDbPersistenceService internalDbPersistenceService) {
        this.internalDbPersistenceService = internalDbPersistenceService;
    }
}

