/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.spatial;

import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.CellType;
import fr.ifremer.echobase.services.service.WorkingDbPersistenceService;
import fr.ifremer.echobase.services.service.spatial.SpatialService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import fr.ifremer.echobase.ui.actions.spatial.ShowSpatialModel;
import java.util.Map;

public class ShowSpatialData
extends EchoBaseActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    protected final ShowSpatialModel model = new ShowSpatialModel();
    protected Map<String, String> voyages;
    protected Map<String, String> cellTypes;
    protected transient WorkingDbPersistenceService workingDbPersistenceService;
    protected transient SpatialService spatialService;

    public ShowSpatialModel getModel() {
        return this.model;
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public Map<String, String> getCellTypes() {
        return this.cellTypes;
    }

    public void prepare() throws Exception {
        this.voyages = this.workingDbPersistenceService.loadSortAndDecorate(Voyage.class);
        this.cellTypes = this.workingDbPersistenceService.loadSortAndDecorate(CellType.class);
        this.model.setJdbcUrl(this.getServiceContext().getWorkgingDbUrl());
        this.model.setWithSpatial(this.spatialService.isSpatialAware());
    }

    public String input() throws Exception {
        this.model.setWithData(false);
        return "success";
    }

    @InputConfig(methodName="input")
    public String execute() throws Exception {
        this.getModel().setWithData(true);
        return "success";
    }

    public void setWorkingDbPersistenceService(WorkingDbPersistenceService workingDbPersistenceService) {
        this.workingDbPersistenceService = workingDbPersistenceService;
    }

    public void setSpatialService(SpatialService spatialService) {
        this.spatialService = spatialService;
    }
}

